/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.HSLActivity;
import com.farmerbb.taskbar.activity.HomeActivity;
import com.farmerbb.taskbar.activity.ImportSettingsActivity;
import com.farmerbb.taskbar.activity.KeyboardShortcutActivity;
import com.farmerbb.taskbar.activity.KeyboardShortcutActivityLockDevice;
import com.farmerbb.taskbar.activity.SecondaryHomeActivity;
import com.farmerbb.taskbar.activity.ShortcutActivity;
import com.farmerbb.taskbar.activity.StartTaskbarActivity;
import com.farmerbb.taskbar.fragment.AboutFragment;
import com.farmerbb.taskbar.fragment.AdvancedFragment;
import com.farmerbb.taskbar.fragment.AppearanceFragment;
import com.farmerbb.taskbar.fragment.DesktopModeFragment;
import com.farmerbb.taskbar.fragment.FreeformModeFragment;
import com.farmerbb.taskbar.fragment.ManageAppDataFragment;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.GlobalHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.service.DashboardService;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.service.StartMenuService;
import com.farmerbb.taskbar.service.TaskbarService;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.U;
import com.google.android.material.snackbar.Snackbar;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;

public class MainActivity
extends AppCompatActivity {
    private SwitchCompat theSwitch;
    private ImageView helpButton;
    private BroadcastReceiver switchReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            MainActivity.this.updateSwitch();
        }
    };
    private boolean hasCaption = false;
    private final int latestChangelogVersion = 1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        U.registerReceiver((Context)this, this.switchReceiver, "com.farmerbb.taskbar.UPDATE_SWITCH");
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        SharedPreferences.Editor editor = pref.edit();
        if (!U.isLibrary((Context)this)) {
            this.setTheme(U.isDarkTheme((Context)this) ? R.style.Taskbar_Dark : R.style.Taskbar);
        } else {
            int theme = this.getIntent().getIntExtra("theme", -1);
            if (theme != -1) {
                this.setTheme(theme);
            }
        }
        if (pref.getBoolean("taskbar_active", false) && !U.isServiceRunning((Context)this, NotificationService.class)) {
            editor.putBoolean("taskbar_active", false);
        }
        boolean launcherEnabled = pref.getBoolean("launcher", false) && U.canDrawOverlays((Context)this) || U.isLauncherPermanentlyEnabled((Context)this);
        boolean desktopModeEnabled = U.isDesktopModeSupported((Context)this) && pref.getBoolean("desktop_mode", false);
        editor.putBoolean("launcher", launcherEnabled);
        editor.putBoolean("desktop_mode", desktopModeEnabled);
        editor.apply();
        boolean isLibrary = U.isLibrary((Context)this);
        if (!isLibrary) {
            U.setComponentEnabled((Context)this, HomeActivity.class, launcherEnabled && !U.isDelegatingHomeActivity((Context)this));
            U.setComponentEnabled((Context)this, KeyboardShortcutActivity.class, pref.getBoolean("keyboard_shortcut", false));
            U.setComponentEnabled((Context)this, ShortcutActivity.class, U.enableFreeformModeShortcut((Context)this));
            U.setComponentEnabled((Context)this, StartTaskbarActivity.class, true);
            U.setComponentEnabled((Context)this, SecondaryHomeActivity.class, desktopModeEnabled);
            U.setComponentEnabled((Context)this, HSLActivity.class, desktopModeEnabled);
            if (Build.VERSION.SDK_INT >= 28) {
                U.setComponentEnabled((Context)this, KeyboardShortcutActivityLockDevice.class, pref.getBoolean("keyboard_shortcut", false));
            }
        }
        if (!(launcherEnabled || desktopModeEnabled || isLibrary)) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.KILL_HOME_ACTIVITY");
        }
        if (Build.VERSION.SDK_INT >= 24 && U.isChromeOs((Context)this)) {
            this.getWindow().setRestrictedCaptionAreaListener(rect -> {
                this.hasCaption = true;
            });
            new Handler().postDelayed(() -> pref.edit().putBoolean("has_caption", this.hasCaption).apply(), 500L);
        }
        if (this.getPackageName().equals("com.farmerbb.taskbar.paid")) {
            File file = new File(this.getFilesDir() + File.separator + "imported_successfully");
            if (this.freeVersionInstalled() && !file.exists()) {
                this.startActivity(new Intent((Context)this, ImportSettingsActivity.class));
                this.finish();
            } else {
                this.proceedWithAppLaunch(savedInstanceState);
            }
        } else {
            this.proceedWithAppLaunch(savedInstanceState);
        }
    }

    private boolean freeVersionInstalled() {
        PackageManager pm = this.getPackageManager();
        try {
            PackageInfo pInfo = pm.getPackageInfo("com.farmerbb.taskbar", 0);
            return pInfo.versionCode >= 68 && pm.checkSignatures("com.farmerbb.taskbar", this.getPackageName()) == 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private void proceedWithAppLaunch(Bundle savedInstanceState) {
        ShortcutManager shortcutManager;
        SharedPreferences pref;
        try {
            this.setContentView(R.layout.tb_main);
        }
        catch (IllegalStateException e) {
            this.setTheme(R.style.Theme_AppCompat_Light);
            this.setContentView(R.layout.tb_main);
        }
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null && !U.isLibrary((Context)this)) {
            actionBar.setCustomView(R.layout.tb_switch_layout);
            actionBar.setDisplayOptions(24);
        }
        this.theSwitch = (SwitchCompat)this.findViewById(R.id.the_switch);
        this.helpButton = (ImageView)this.findViewById(R.id.help_button);
        if (this.theSwitch != null) {
            pref = U.getSharedPreferences((Context)this);
            this.theSwitch.setChecked(pref.getBoolean("taskbar_active", false));
            this.theSwitch.setOnCheckedChangeListener((compoundButton, b) -> {
                if (b) {
                    if (U.canDrawOverlays((Context)this)) {
                        boolean firstRun = pref.getBoolean("first_run", true);
                        this.startTaskbarService();
                        if (firstRun) {
                            U.showRecentAppsDialog((Context)this);
                        }
                    } else {
                        U.showPermissionDialog((Context)this);
                        compoundButton.setChecked(false);
                    }
                } else {
                    this.stopTaskbarService();
                }
            });
        }
        if (savedInstanceState == null) {
            U.initPrefs((Context)this);
            File restoreInProgress = new File(this.getFilesDir(), "restore_in_progress");
            File restoreSuccessful = new File(this.getFilesDir(), "restore_successful");
            if (restoreInProgress.exists() || restoreSuccessful.exists()) {
                if (restoreInProgress.exists()) {
                    U.showToastLong((Context)this, R.string.tb_restore_failed);
                    restoreInProgress.delete();
                }
                if (restoreSuccessful.exists()) {
                    U.showToastLong((Context)this, R.string.tb_restore_successful);
                    restoreSuccessful.delete();
                }
                this.navigateTo((Fragment)new ManageAppDataFragment());
            } else if (!this.getIntent().hasExtra("theme_change")) {
                this.navigateTo((Fragment)new AboutFragment());
            } else {
                this.navigateTo((Fragment)new AppearanceFragment());
            }
        } else {
            try {
                Fragment oldFragment = this.getFragmentManager().findFragmentById(R.id.fragmentContainer);
                this.navigateTo((Fragment)oldFragment.getClass().newInstance());
            }
            catch (IllegalAccessException | InstantiationException oldFragment) {
                // empty catch block
            }
        }
        pref = U.getSharedPreferences((Context)this);
        if (!this.getPackageName().equals("com.farmerbb.taskbar") && this.freeVersionInstalled()) {
            if (!pref.getBoolean("dont_show_uninstall_dialog", false)) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setTitle(R.string.tb_settings_imported_successfully).setMessage(R.string.tb_import_dialog_message).setPositiveButton(R.string.tb_action_uninstall, (dialog, which) -> {
                    pref.edit().putBoolean("uninstall_dialog_shown", true).apply();
                    try {
                        this.startActivity(new Intent("android.intent.action.DELETE", Uri.parse((String)"package:com.farmerbb.taskbar")));
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        // empty catch block
                    }
                });
                if (pref.getBoolean("uninstall_dialog_shown", false)) {
                    builder.setNegativeButton(R.string.tb_action_dont_show_again, (dialogInterface, i) -> pref.edit().putBoolean("dont_show_uninstall_dialog", true).apply());
                }
                AlertDialog dialog2 = builder.create();
                dialog2.show();
                dialog2.setCancelable(false);
            }
            if (!pref.getBoolean("uninstall_dialog_shown", false)) {
                if (this.theSwitch != null) {
                    this.theSwitch.setChecked(false);
                }
                SharedPreferences.Editor editor = pref.edit();
                String iconPack = pref.getString("icon_pack", "com.farmerbb.taskbar");
                if (iconPack.contains("com.farmerbb.taskbar")) {
                    editor.putString("icon_pack", this.getPackageName());
                } else {
                    U.refreshPinnedIcons((Context)this);
                }
                editor.putBoolean("first_run", true);
                editor.apply();
            }
        }
        if (Build.VERSION.SDK_INT >= 25 && !U.isLibrary((Context)this) && (shortcutManager = (ShortcutManager)this.getSystemService(ShortcutManager.class)).getDynamicShortcuts().size() == 0) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClass((Context)this, StartTaskbarActivity.class);
            intent.putExtra("is_launching_shortcut", true);
            ShortcutInfo shortcut = new ShortcutInfo.Builder((Context)this, "start_taskbar").setShortLabel((CharSequence)this.getString(R.string.tb_start_taskbar)).setIcon(Icon.createWithResource((Context)this, (int)R.drawable.tb_shortcut_icon_start)).setIntent(intent).build();
            if (U.enableFreeformModeShortcut((Context)this)) {
                Intent intent2 = new Intent("android.intent.action.MAIN");
                intent2.setClass((Context)this, ShortcutActivity.class);
                intent2.putExtra("is_launching_shortcut", true);
                ShortcutInfo shortcut2 = new ShortcutInfo.Builder((Context)this, "freeform_mode").setShortLabel((CharSequence)this.getString(R.string.tb_pref_header_freeform)).setIcon(Icon.createWithResource((Context)this, (int)R.drawable.tb_shortcut_icon_freeform)).setIntent(intent2).build();
                shortcutManager.setDynamicShortcuts(Arrays.asList(shortcut, shortcut2));
            } else {
                shortcutManager.setDynamicShortcuts(Collections.singletonList(shortcut));
            }
        }
        if (pref.getInt("show_changelog", 0) < 1 && U.isConsumerBuild((Context)this)) {
            Snackbar snackbar = Snackbar.make((View)this.findViewById(R.id.main_activity_layout), (int)R.string.tb_see_whats_new, (int)-2);
            snackbar.setAction(R.string.tb_action_view, v -> {
                pref.edit().putInt("show_changelog", 1).apply();
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"https://github.com/farmerbb/Taskbar/blob/200/CHANGELOG.md"));
                try {
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException | IllegalArgumentException throwable) {
                    // empty catch block
                }
            });
            snackbar.show();
        }
    }

    protected void onResume() {
        super.onResume();
        this.updateSwitch();
    }

    protected void onStart() {
        super.onStart();
        GlobalHelper.getInstance().setOnMainActivity(true);
    }

    protected void onStop() {
        super.onStop();
        GlobalHelper.getInstance().setOnMainActivity(false);
    }

    protected void onDestroy() {
        U.unregisterReceiver((Context)this, this.switchReceiver);
        if (Build.VERSION.SDK_INT >= 24 && U.isChromeOs((Context)this)) {
            this.getWindow().setRestrictedCaptionAreaListener(null);
        }
        if (this.isFinishing() && U.isConsumerBuild((Context)this)) {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            pref.edit().putInt("show_changelog", 1).apply();
        }
        super.onDestroy();
    }

    @TargetApi(value=24)
    private void startTaskbarService() {
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean("is_hidden", false);
        if (pref.getBoolean("first_run", true)) {
            editor.putBoolean("first_run", false);
            editor.putBoolean("collapsed", true);
        }
        editor.putBoolean("taskbar_active", true);
        editor.putLong("time_of_service_start", System.currentTimeMillis());
        editor.apply();
        if (U.hasFreeformSupport((Context)this) && U.isFreeformModeEnabled((Context)this) && !FreeformHackHelper.getInstance().isFreeformHackActive()) {
            U.startFreeformHack((Context)this, true);
        }
        this.startService(new Intent((Context)this, TaskbarService.class));
        this.startService(new Intent((Context)this, StartMenuService.class));
        this.startService(new Intent((Context)this, DashboardService.class));
        this.startService(new Intent((Context)this, NotificationService.class));
    }

    private void stopTaskbarService() {
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        pref.edit().putBoolean("taskbar_active", false).apply();
        if (!LauncherHelper.getInstance().isOnHomeScreen((Context)this)) {
            this.stopService(new Intent((Context)this, TaskbarService.class));
            this.stopService(new Intent((Context)this, StartMenuService.class));
            this.stopService(new Intent((Context)this, DashboardService.class));
            IconCache.getInstance((Context)this).clearCache();
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.START_MENU_DISAPPEARING");
        }
        this.stopService(new Intent((Context)this, NotificationService.class));
    }

    private void updateSwitch() {
        if (this.theSwitch != null) {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            this.theSwitch.setChecked(pref.getBoolean("taskbar_active", false));
        }
    }

    public void onBackPressed() {
        Fragment oldFragment = this.getFragmentManager().findFragmentById(R.id.fragmentContainer);
        if (oldFragment instanceof AboutFragment) {
            super.onBackPressed();
        } else {
            SettingsFragment newFragment = oldFragment instanceof ManageAppDataFragment ? new AdvancedFragment() : new AboutFragment();
            this.getFragmentManager().beginTransaction().replace(R.id.fragmentContainer, (Fragment)newFragment, ((Object)((Object)newFragment)).getClass().getSimpleName()).setTransition(8194).commit();
        }
    }

    public String getAboutFragmentTitle() {
        if (!U.isLibrary((Context)this)) {
            return this.getString(R.string.tb_app_name);
        }
        String title = this.getIntent().getStringExtra("title");
        return title != null ? title : this.getString(R.string.tb_settings);
    }

    public boolean getAboutFragmentBackArrow() {
        if (!U.isLibrary((Context)this)) {
            return false;
        }
        return this.getIntent().getBooleanExtra("back_arrow", false);
    }

    public void updateHelpButton(SettingsFragment fragment) {
        if (this.helpButton == null) {
            return;
        }
        if (fragment instanceof FreeformModeFragment) {
            this.helpButton.setVisibility(0);
            this.helpButton.setOnClickListener(v -> this.showHelpDialog(R.string.tb_freeform_help_dialog_message));
        } else if (fragment instanceof DesktopModeFragment) {
            this.helpButton.setVisibility(0);
            this.helpButton.setOnClickListener(v -> this.showHelpDialog(R.string.tb_desktop_mode_help));
        } else {
            this.helpButton.setVisibility(4);
            this.helpButton.setOnClickListener(null);
        }
    }

    private void navigateTo(Fragment fragment) {
        this.getFragmentManager().beginTransaction().replace(R.id.fragmentContainer, fragment, fragment.getClass().getSimpleName()).commit();
    }

    private void showHelpDialog(int helpText) {
        View view = View.inflate((Context)this, (int)R.layout.tb_freeform_help_dialog, null);
        TextView dialogMessage = (TextView)view.findViewById(R.id.dialogMessage);
        dialogMessage.setText(helpText);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setView(view).setTitle(R.string.tb_freeform_help_dialog_title).setPositiveButton(R.string.tb_action_close, null);
        AlertDialog dialog = builder.create();
        dialog.show();
    }
}

