/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import com.farmerbb.taskbar.activity.DummyActivity;
import com.farmerbb.taskbar.activity.InvisibleActivityAlt;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.service.DashboardService;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.service.StartMenuService;
import com.farmerbb.taskbar.service.TaskbarService;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.U;

public class InvisibleActivityFreeform
extends Activity {
    boolean showTaskbar = false;
    boolean doNotHide = false;
    boolean proceedWithOnCreate = true;
    boolean finish = false;
    boolean bootToFreeform = false;
    boolean initialLaunch = true;
    private BroadcastReceiver appearingReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            InvisibleActivityFreeform.this.doNotHide = true;
        }
    };
    private BroadcastReceiver disappearingReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            InvisibleActivityFreeform.this.doNotHide = false;
        }
    };
    private BroadcastReceiver finishReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            InvisibleActivityFreeform.this.reallyFinish();
        }
    };

    @SuppressLint(value={"HardwareIds"})
    @TargetApi(value=24)
    protected void onCreate(Bundle savedInstanceState) {
        SharedPreferences pref;
        super.onCreate(savedInstanceState);
        FreeformHackHelper helper = FreeformHackHelper.getInstance();
        if (helper.isFreeformHackActive()) {
            this.proceedWithOnCreate = false;
            super.finish();
        }
        if (this.getIntent().hasExtra("check_multiwindow")) {
            this.showTaskbar = false;
            if (!this.isInMultiWindowMode()) {
                this.proceedWithOnCreate = false;
                super.finish();
            }
        }
        if (U.isOverridingFreeformHack((Context)this)) {
            helper.setFreeformHackActive(true);
            helper.setInFreeformWorkspace(true);
            this.proceedWithOnCreate = false;
            super.finish();
            this.overridePendingTransition(0, 0);
        }
        if (!this.proceedWithOnCreate) {
            return;
        }
        this.getWindow().setFlags(32, 32);
        this.getWindow().setFlags(262144, 262144);
        U.registerReceiver((Context)this, this.appearingReceiver, "com.farmerbb.taskbar.START_MENU_APPEARING", "com.farmerbb.taskbar.CONTEXT_MENU_APPEARING", "com.farmerbb.taskbar.DASHBOARD_APPEARING");
        U.registerReceiver((Context)this, this.disappearingReceiver, "com.farmerbb.taskbar.START_MENU_DISAPPEARING", "com.farmerbb.taskbar.CONTEXT_MENU_DISAPPEARING", "com.farmerbb.taskbar.DASHBOARD_DISAPPEARING");
        U.registerReceiver((Context)this, this.finishReceiver, "com.farmerbb.taskbar.FINISH_FREEFORM_ACTIVITY");
        helper.setFreeformHackActive(true);
        if (this.getPackageManager().hasSystemFeature("com.cyanogenmod.android") && !(pref = U.getSharedPreferences((Context)this)).getString("power_button_warning", "null").equals(Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id"))) {
            new Handler().postDelayed(() -> {
                if (helper.isInFreeformWorkspace()) {
                    Intent intent = U.getThemedIntent((Context)this, InvisibleActivityAlt.class);
                    intent.setFlags(0x10000000);
                    intent.putExtra("power_button_warning", true);
                    U.startActivityMaximized(U.getDisplayContext((Context)this), intent);
                }
            }, 100L);
        }
        this.showTaskbar = true;
    }

    @TargetApi(value=24)
    protected void onResume() {
        super.onResume();
        if (this.showTaskbar) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.SHOW_TASKBAR");
        }
        if (!this.isInMultiWindowMode() && !this.initialLaunch) {
            this.reallyFinish();
        }
        this.initialLaunch = false;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (!this.proceedWithOnCreate) {
            return;
        }
        U.unregisterReceiver((Context)this, this.appearingReceiver);
        U.unregisterReceiver((Context)this, this.disappearingReceiver);
        U.unregisterReceiver((Context)this, this.finishReceiver);
        this.cleanup();
    }

    protected void onStart() {
        super.onStart();
        FreeformHackHelper.getInstance().setInFreeformWorkspace(true);
        if (U.launcherIsDefault((Context)this) && !U.isChromeOs((Context)this)) {
            LauncherHelper.getInstance().setOnPrimaryHomeScreen(true);
            this.bootToFreeform = true;
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            if (pref.getBoolean("first_run", true)) {
                SharedPreferences.Editor editor = pref.edit();
                editor.putBoolean("first_run", false);
                editor.putBoolean("collapsed", true);
                editor.apply();
                new Handler().postDelayed(() -> {
                    Intent intent = new Intent((Context)this, DummyActivity.class);
                    intent.putExtra("show_recent_apps_dialog", true);
                    intent.setFlags(0x10000000);
                    this.startActivity(intent);
                }, 250L);
            }
            this.startService(new Intent((Context)this, TaskbarService.class));
            this.startService(new Intent((Context)this, StartMenuService.class));
            this.startService(new Intent((Context)this, DashboardService.class));
            if (pref.getBoolean("taskbar_active", false) && !U.isServiceRunning((Context)this, NotificationService.class)) {
                pref.edit().putBoolean("taskbar_active", false).apply();
            }
            if (this.showTaskbar) {
                new Handler().postDelayed(() -> U.sendBroadcast((Context)this, "com.farmerbb.taskbar.SHOW_TASKBAR"), 100L);
            }
        }
        if (this.showTaskbar) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.SHOW_TASKBAR");
        }
    }

    protected void onPause() {
        super.onPause();
        this.possiblyHideTaskbar();
    }

    protected void onStop() {
        super.onStop();
        if (!this.finish) {
            FreeformHackHelper.getInstance().setInFreeformWorkspace(false);
        }
        this.possiblyHideTaskbar();
        if (this.bootToFreeform && !this.finish) {
            LauncherHelper.getInstance().setOnPrimaryHomeScreen(false);
            this.bootToFreeform = false;
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            if (!pref.getBoolean("taskbar_active", false) || pref.getBoolean("is_hidden", false)) {
                this.stopService(new Intent((Context)this, TaskbarService.class));
                this.stopService(new Intent((Context)this, StartMenuService.class));
                this.stopService(new Intent((Context)this, DashboardService.class));
                IconCache.getInstance((Context)this).clearCache();
            }
        }
    }

    public void finish() {
    }

    private void possiblyHideTaskbar() {
        if (!this.doNotHide) {
            new Handler().postDelayed(() -> {
                if (U.shouldCollapse((Context)this, false) && !LauncherHelper.getInstance().isOnHomeScreen((Context)this)) {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_TASKBAR");
                } else {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU");
                }
            }, 100L);
        }
    }

    private void reallyFinish() {
        super.finish();
        this.overridePendingTransition(0, 0);
        this.cleanup();
    }

    private void cleanup() {
        if (!this.finish) {
            FreeformHackHelper helper = FreeformHackHelper.getInstance();
            helper.setFreeformHackActive(false);
            helper.setInFreeformWorkspace(false);
            this.finish = true;
        }
    }
}

