/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.util.IconPack;
import com.farmerbb.taskbar.util.IconPackManager;
import com.farmerbb.taskbar.util.U;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IconPackActivity
extends AppCompatActivity {
    private AppListGenerator appListGenerator;
    private ProgressBar progressBar;
    private ListView appList;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tb_select_app);
        this.setFinishOnTouchOutside(false);
        this.setTitle(R.string.tb_icon_pack);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.appList = (ListView)this.findViewById(R.id.list);
        this.appListGenerator = new AppListGenerator();
        this.appListGenerator.execute(new Void[0]);
    }

    public void finish() {
        if (this.appListGenerator != null && this.appListGenerator.getStatus() == AsyncTask.Status.RUNNING) {
            this.appListGenerator.cancel(true);
        }
        super.finish();
    }

    private void openIconPackActivity(String packageName) {
        Intent intent = new Intent("org.adw.launcher.THEMES");
        intent.setPackage(packageName);
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    private final class AppListGenerator
    extends AsyncTask<Void, Void, AppListAdapter> {
        private AppListGenerator() {
        }

        protected AppListAdapter doInBackground(Void ... params) {
            List<IconPack> list = IconPackManager.getInstance().getAvailableIconPacks((Context)IconPackActivity.this);
            if (list.isEmpty()) {
                return null;
            }
            ArrayList<IconPack> finalList = new ArrayList<IconPack>();
            IconPack dummyIconPack = new IconPack();
            dummyIconPack.setPackageName(IconPackActivity.this.getPackageName());
            dummyIconPack.setName(IconPackActivity.this.getString(R.string.tb_icon_pack_none));
            Collections.sort(list, (ip1, ip2) -> Collator.getInstance().compare(ip1.getName(), ip2.getName()));
            finalList.add(dummyIconPack);
            finalList.addAll(list);
            return new AppListAdapter((Context)IconPackActivity.this, R.layout.tb_row, finalList);
        }

        protected void onPostExecute(AppListAdapter adapter) {
            if (adapter == null) {
                U.showToast((Context)IconPackActivity.this, R.string.tb_no_icon_packs_installed);
                IconPackActivity.this.setResult(0);
                IconPackActivity.this.finish();
            } else {
                IconPackActivity.this.progressBar.setVisibility(8);
                IconPackActivity.this.appList.setAdapter((ListAdapter)adapter);
                IconPackActivity.this.setFinishOnTouchOutside(true);
            }
        }
    }

    private class AppListAdapter
    extends ArrayAdapter<IconPack> {
        AppListAdapter(Context context, int layout2, List<IconPack> list) {
            super(context, layout2, list);
        }

        @NonNull
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tb_row, parent, false);
            }
            IconPack entry = (IconPack)this.getItem(position);
            assert (entry != null);
            TextView textView = (TextView)convertView.findViewById(R.id.name);
            textView.setText((CharSequence)entry.getName());
            PackageManager pm = IconPackActivity.this.getPackageManager();
            ImageView imageView = (ImageView)convertView.findViewById(R.id.icon);
            if (entry.getPackageName().equals(IconPackActivity.this.getPackageName())) {
                imageView.setImageDrawable(null);
            } else {
                try {
                    imageView.setImageDrawable(pm.getApplicationIcon(entry.getPackageName()));
                }
                catch (PackageManager.NameNotFoundException e) {
                    imageView.setImageDrawable(pm.getDefaultActivityIcon());
                }
            }
            LinearLayout layout2 = (LinearLayout)convertView.findViewById(R.id.entry);
            layout2.setOnClickListener(view -> {
                SharedPreferences pref = U.getSharedPreferences((Context)IconPackActivity.this);
                pref.edit().putString("icon_pack", entry.getPackageName()).apply();
                IconPackActivity.this.setResult(-1);
                IconPackActivity.this.finish();
            });
            layout2.setOnLongClickListener(v -> {
                IconPackActivity.this.openIconPackActivity(entry.getPackageName());
                return false;
            });
            layout2.setOnGenericMotionListener((view, motionEvent) -> {
                if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                    IconPackActivity.this.openIconPackActivity(entry.getPackageName());
                }
                return false;
            });
            return convertView;
        }
    }
}

