/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.WallpaperManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.LauncherApps;
import android.content.res.ColorStateList;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.SparseArray;
import android.view.DragEvent;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.GridLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.HomeActivity;
import com.farmerbb.taskbar.activity.SecondaryHomeActivity;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.GlobalHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.helper.MenuHelper;
import com.farmerbb.taskbar.service.DashboardService;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.service.StartMenuService;
import com.farmerbb.taskbar.service.TaskbarService;
import com.farmerbb.taskbar.ui.DashboardController;
import com.farmerbb.taskbar.ui.StartMenuController;
import com.farmerbb.taskbar.ui.TaskbarController;
import com.farmerbb.taskbar.ui.UIHost;
import com.farmerbb.taskbar.ui.ViewParams;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.Callbacks;
import com.farmerbb.taskbar.util.DesktopIconInfo;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.FABWrapper;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.TaskbarPosition;
import com.farmerbb.taskbar.util.U;
import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;

public class HomeActivityDelegate
extends AppCompatActivity
implements UIHost {
    private TaskbarController taskbarController;
    private StartMenuController startMenuController;
    private DashboardController dashboardController;
    private FrameLayout layout;
    private GridLayout desktopIcons;
    private FABWrapper fab;
    private ImageView wallpaper;
    private boolean forceTaskbarStart = false;
    private AlertDialog dialog;
    private WindowManager windowManager;
    private boolean shouldDelayFreeformHack;
    private int hits;
    private boolean isDesktopIconsEnabled;
    private boolean iconArrangeMode = false;
    private int startDragIndex;
    private int endDragIndex;
    private boolean isSecondaryHome;
    private boolean waitingForPermission;
    private boolean isWallpaperEnabled;
    private GestureDetector detector;
    private BroadcastReceiver killReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.killHomeActivity();
        }
    };
    private BroadcastReceiver forceTaskbarStartReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.forceTaskbarStart = true;
        }
    };
    private BroadcastReceiver restartReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (HomeActivityDelegate.this.taskbarController != null) {
                HomeActivityDelegate.this.taskbarController.onRecreateHost(HomeActivityDelegate.this);
            }
            if (HomeActivityDelegate.this.startMenuController != null) {
                HomeActivityDelegate.this.startMenuController.onRecreateHost(HomeActivityDelegate.this);
            }
            if (HomeActivityDelegate.this.dashboardController != null) {
                HomeActivityDelegate.this.dashboardController.onRecreateHost(HomeActivityDelegate.this);
            }
        }
    };
    private BroadcastReceiver freeformToggleReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (HomeActivityDelegate.this.isDesktopIconsEnabled == U.isDesktopIconsEnabled((Context)HomeActivityDelegate.this)) {
                HomeActivityDelegate.this.updateWindowFlags();
            } else {
                HomeActivityDelegate.this.recreate();
            }
        }
    };
    private BroadcastReceiver refreshDesktopIconsReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.refreshDesktopIcons();
        }
    };
    private BroadcastReceiver iconArrangeModeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.enterIconArrangeMode();
        }
    };
    private BroadcastReceiver sortDesktopIconsReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.sortDesktopIcons();
        }
    };
    private BroadcastReceiver updateMarginsReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.updateMargins();
        }
    };
    private BroadcastReceiver removeDesktopWallpaperReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HomeActivityDelegate.this.removeCustomWallpaper();
        }
    };
    private BroadcastReceiver wallpaperChangeRequestReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            U.showImageChooser((Activity)HomeActivityDelegate.this);
        }
    };
    private LauncherApps.Callback callback = new LauncherApps.Callback(){

        public void onPackageRemoved(String packageName, UserHandle user) {
            HomeActivityDelegate.this.refreshDesktopIcons();
        }

        public void onPackageAdded(String packageName, UserHandle user) {
            HomeActivityDelegate.this.refreshDesktopIcons();
        }

        public void onPackageChanged(String packageName, UserHandle user) {
            HomeActivityDelegate.this.refreshDesktopIcons();
        }

        public void onPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
            HomeActivityDelegate.this.refreshDesktopIcons();
        }

        public void onPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
            HomeActivityDelegate.this.refreshDesktopIcons();
        }
    };

    @SuppressLint(value={"RestrictedApi"})
    protected void onCreate(final Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final SharedPreferences pref = U.getSharedPreferences((Context)this);
        this.isSecondaryHome = this instanceof SecondaryHomeActivity;
        if (this.isSecondaryHome) {
            this.windowManager = (WindowManager)this.getSystemService("window");
            if (this.windowManager.getDefaultDisplay().getDisplayId() == 0 || !U.isDesktopModeActive((Context)this) && !U.isLibrary((Context)this)) {
                this.finish();
                return;
            }
            if (pref.getBoolean("dim_screen", false) && U.launcherIsDefault((Context)this) && !GlobalHelper.getInstance().isOnMainActivity()) {
                Intent homeIntent = new Intent("android.intent.action.MAIN");
                homeIntent.addCategory("android.intent.category.HOME");
                homeIntent.setFlags(0x10000000);
                this.getApplicationContext().startActivity(homeIntent);
            }
        }
        this.shouldDelayFreeformHack = true;
        this.hits = 0;
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        if (U.applyDisplayCutoutModeTo(params)) {
            this.getWindow().setAttributes(params);
        }
        this.layout = new FrameLayout((Context)this){

            protected void onAttachedToWindow() {
                super.onAttachedToWindow();
                WallpaperManager wallpaperManager = (WallpaperManager)HomeActivityDelegate.this.getSystemService("wallpaper");
                wallpaperManager.setWallpaperOffsets(this.getWindowToken(), 0.5f, 0.5f);
                if (Build.VERSION.SDK_INT >= 23) {
                    DisplayInfo display = U.getDisplayInfo((Context)HomeActivityDelegate.this);
                    if (display.width > 0 && display.height > 0) {
                        wallpaperManager.suggestDesiredDimensions(display.width, display.height);
                    }
                }
                boolean shouldStartFreeformHack = HomeActivityDelegate.this.shouldDelayFreeformHack && HomeActivityDelegate.this.hits > 0;
                HomeActivityDelegate.this.shouldDelayFreeformHack = false;
                if (shouldStartFreeformHack) {
                    HomeActivityDelegate.this.startFreeformHack();
                }
            }
        };
        boolean bl = this.isWallpaperEnabled = this.isSecondaryHome || U.isChromeOs((Context)this);
        if (this.isWallpaperEnabled) {
            this.wallpaper = new ImageView((Context)this);
            this.wallpaper.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.layout.addView((View)this.wallpaper);
        }
        this.isDesktopIconsEnabled = U.isDesktopIconsEnabled((Context)this);
        if (this.isDesktopIconsEnabled) {
            this.layout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    HomeActivityDelegate.this.layout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    if (savedInstanceState != null) {
                        HomeActivityDelegate.this.iconArrangeMode = savedInstanceState.getBoolean("icon_arrange_mode");
                    }
                    HomeActivityDelegate.this.initDesktopIcons();
                }
            });
        } else {
            this.layout.setOnClickListener(view1 -> U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU"));
            this.layout.setOnLongClickListener(view2 -> {
                if (!U.isFreeformModeEnabled((Context)this)) {
                    this.setWallpaper();
                }
                return false;
            });
            this.layout.setOnGenericMotionListener((view3, motionEvent) -> {
                if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2 && !U.isFreeformModeEnabled((Context)this)) {
                    this.setWallpaper();
                }
                return false;
            });
        }
        this.layout.setFitsSystemWindows(true);
        if (Build.VERSION.SDK_INT >= 28 && this.isDesktopIconsEnabled && !U.isLibrary((Context)this)) {
            this.detector = new GestureDetector((Context)this, new GestureDetector.OnGestureListener(){

                public boolean onSingleTapUp(MotionEvent e) {
                    return false;
                }

                public void onShowPress(MotionEvent e) {
                }

                public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                    return false;
                }

                public void onLongPress(MotionEvent e) {
                }

                public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                    return false;
                }

                public boolean onDown(MotionEvent e) {
                    return false;
                }
            });
            this.detector.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

                public boolean onDoubleTap(MotionEvent e) {
                    if (!pref.getBoolean("dont_show_double_tap_dialog", false) && !HomeActivityDelegate.this.isSecondaryHome) {
                        if (pref.getBoolean("double_tap_to_sleep", false)) {
                            U.lockDevice((Context)HomeActivityDelegate.this);
                        } else {
                            AlertDialog.Builder builder = new AlertDialog.Builder(U.wrapContext((Context)HomeActivityDelegate.this));
                            builder.setTitle(R.string.tb_double_tap_to_sleep).setMessage(R.string.tb_enable_double_tap_to_sleep).setNegativeButton(pref.getBoolean("double_tap_dialog_shown", false) ? R.string.tb_action_dont_show_again : R.string.tb_action_cancel, (dialog, which) -> pref.edit().putBoolean(pref.getBoolean("double_tap_dialog_shown", false) ? "dont_show_double_tap_dialog" : "double_tap_dialog_shown", true).apply()).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> {
                                pref.edit().putBoolean("double_tap_to_sleep", true).apply();
                                U.lockDevice((Context)HomeActivityDelegate.this);
                            });
                            AlertDialog dialog2 = builder.create();
                            dialog2.show();
                        }
                    }
                    return false;
                }

                public boolean onDoubleTapEvent(MotionEvent e) {
                    return false;
                }

                public boolean onSingleTapConfirmed(MotionEvent e) {
                    return false;
                }
            });
        }
        if (this instanceof HomeActivity || this.isSecondaryHome || U.isLauncherPermanentlyEnabled((Context)this)) {
            File file;
            this.setContentView((View)this.layout);
            if (this.isWallpaperEnabled && (file = new File(this.getFilesDir() + "/tb_images", "desktop_wallpaper")).exists()) {
                U.applyCustomImage((Context)this, "desktop_wallpaper", this.wallpaper, null);
                this.getWindow().setNavigationBarColor(-16777216);
            }
            pref.edit().putBoolean("launcher", !this.isSecondaryHome).putBoolean("desktop_mode", U.isDesktopModeSupported((Context)this) && this.isSecondaryHome).apply();
        } else {
            this.killHomeActivity();
        }
        this.updateWindowFlags();
        U.registerReceiver((Context)this, this.killReceiver, "com.farmerbb.taskbar.KILL_HOME_ACTIVITY");
        U.registerReceiver((Context)this, this.forceTaskbarStartReceiver, "com.farmerbb.taskbar.FORCE_TASKBAR_RESTART");
        U.registerReceiver((Context)this, this.freeformToggleReceiver, "com.farmerbb.taskbar.UPDATE_FREEFORM_CHECKBOX", "com.farmerbb.taskbar.TOUCH_ABSORBER_STATE_CHANGED", "com.farmerbb.taskbar.FREEFORM_PREF_CHANGED");
        if (this.isSecondaryHome) {
            U.registerReceiver((Context)this, this.restartReceiver, "com.farmerbb.taskbar.RESTART");
        }
        if (this.isWallpaperEnabled) {
            U.registerReceiver((Context)this, this.removeDesktopWallpaperReceiver, "com.farmerbb.taskbar.REMOVE_DESKTOP_WALLPAPER");
            U.registerReceiver((Context)this, this.wallpaperChangeRequestReceiver, "com.farmerbb.taskbar.WALLPAPER_CHANGE_REQUESTED");
        }
        if (this.isDesktopIconsEnabled) {
            U.registerReceiver((Context)this, this.refreshDesktopIconsReceiver, "com.farmerbb.taskbar.REFRESH_DESKTOP_ICONS");
            U.registerReceiver((Context)this, this.iconArrangeModeReceiver, "com.farmerbb.taskbar.ENTER_ICON_ARRANGE_MODE");
            U.registerReceiver((Context)this, this.sortDesktopIconsReceiver, "com.farmerbb.taskbar.SORT_DESKTOP_ICONS");
            U.registerReceiver((Context)this, this.updateMarginsReceiver, "com.farmerbb.taskbar.UPDATE_HOME_SCREEN_MARGINS");
            LauncherApps launcherApps = (LauncherApps)this.getSystemService("launcherapps");
            launcherApps.registerCallback(this.callback);
        }
        U.initPrefs((Context)this);
    }

    private void setWallpaper() {
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_HIDE_TASKBAR");
        try {
            this.startActivity(Intent.createChooser((Intent)new Intent("android.intent.action.SET_WALLPAPER"), (CharSequence)this.getString(R.string.tb_set_wallpaper)));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    @TargetApi(value=24)
    protected void onResume() {
        super.onResume();
        if (U.canBootToFreeform((Context)this)) {
            if (U.launcherIsDefault((Context)this)) {
                this.startFreeformHack();
            } else {
                U.showToastLong((Context)this, R.string.tb_set_as_default_home);
                Intent homeIntent = new Intent("android.intent.action.MAIN");
                homeIntent.addCategory("android.intent.category.HOME");
                homeIntent.setFlags(0x10000000);
                try {
                    this.startActivity(homeIntent);
                    this.finish();
                }
                catch (ActivityNotFoundException activityNotFoundException) {}
            }
        } else {
            this.performOnResumeLogic();
        }
    }

    protected void onStart() {
        super.onStart();
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU");
        this.init();
    }

    private void init() {
        if (U.canDrawOverlays((Context)this)) {
            if (!U.canBootToFreeform((Context)this)) {
                this.setOnHomeScreen(true);
                if (this.forceTaskbarStart) {
                    this.forceTaskbarStart = false;
                    new Handler().postDelayed(() -> {
                        this.setOnHomeScreen(true);
                        this.startTaskbar();
                    }, 250L);
                } else {
                    this.startTaskbar();
                }
            } else if (U.launcherIsDefault((Context)this)) {
                this.startFreeformHack();
            }
        } else if (!this.waitingForPermission) {
            this.dialog = U.showPermissionDialog(U.wrapContext((Context)this), new Callbacks(() -> {
                this.dialog = U.showErrorDialog(U.wrapContext((Context)this), "SYSTEM_ALERT_WINDOW");
            }, () -> {
                this.waitingForPermission = true;
            }));
        }
    }

    private void startTaskbar() {
        SharedPreferences pref;
        if (U.hasFreeformSupport((Context)this) && U.isFreeformModeEnabled((Context)this) && !FreeformHackHelper.getInstance().isFreeformHackActive()) {
            U.startFreeformHack((Context)this, true);
        }
        if ((pref = U.getSharedPreferences((Context)this)).getBoolean("first_run", true)) {
            SharedPreferences.Editor editor = pref.edit();
            editor.putBoolean("first_run", false);
            editor.putBoolean("collapsed", true);
            editor.apply();
            this.dialog = U.showRecentAppsDialog(U.wrapContext((Context)this), new Callbacks(() -> {
                this.dialog = U.showErrorDialog(U.wrapContext((Context)this), "GET_USAGE_STATS");
            }, null));
        }
        if (this.isSecondaryHome) {
            this.stopService(new Intent((Context)this, TaskbarService.class));
            this.stopService(new Intent((Context)this, StartMenuService.class));
            this.stopService(new Intent((Context)this, DashboardService.class));
            this.taskbarController = new TaskbarController((Context)this);
            this.startMenuController = new StartMenuController((Context)this);
            this.dashboardController = new DashboardController((Context)this);
            this.taskbarController.onCreateHost(this);
            this.startMenuController.onCreateHost(this);
            this.dashboardController.onCreateHost(this);
        } else {
            try {
                this.startService(new Intent((Context)this, TaskbarService.class));
                this.startService(new Intent((Context)this, StartMenuService.class));
                this.startService(new Intent((Context)this, DashboardService.class));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (pref.getBoolean("taskbar_active", false) && !U.isServiceRunning((Context)this, NotificationService.class)) {
            pref.edit().putBoolean("taskbar_active", false).apply();
        }
        new Handler().postDelayed(() -> U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_SHOW_TASKBAR"), 100L);
    }

    private void startFreeformHack() {
        if (this.shouldDelayFreeformHack) {
            ++this.hits;
        } else {
            U.startFreeformHack((Context)this);
        }
    }

    protected void onStop() {
        super.onStop();
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        if (!U.canBootToFreeform((Context)this)) {
            if (U.shouldCollapse((Context)this, false)) {
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_HIDE_TASKBAR");
            }
            if (this.isSecondaryHome) {
                if (this.taskbarController != null) {
                    this.taskbarController.onDestroyHost(this);
                }
                if (this.startMenuController != null) {
                    this.startMenuController.onDestroyHost(this);
                }
                if (this.dashboardController != null) {
                    this.dashboardController.onDestroyHost(this);
                }
                IconCache.getInstance((Context)this).clearCache();
                if (pref.getBoolean("taskbar_active", false) && !pref.getBoolean("is_hidden", false)) {
                    this.startService(new Intent((Context)this, TaskbarService.class));
                    this.startService(new Intent((Context)this, StartMenuService.class));
                    this.startService(new Intent((Context)this, DashboardService.class));
                }
            } else if (!pref.getBoolean("taskbar_active", false) || pref.getBoolean("is_hidden", false)) {
                this.stopService(new Intent((Context)this, TaskbarService.class));
                this.stopService(new Intent((Context)this, StartMenuService.class));
                if (!pref.getBoolean("dont_stop_dashboard", false)) {
                    this.stopService(new Intent((Context)this, DashboardService.class));
                }
                IconCache.getInstance((Context)this).clearCache();
            }
            if (this.isChangingConfigurations()) {
                this.setOnHomeScreen(false);
            } else {
                new Handler().post(() -> this.setOnHomeScreen(false));
            }
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        U.unregisterReceiver((Context)this, this.killReceiver);
        U.unregisterReceiver((Context)this, this.forceTaskbarStartReceiver);
        U.unregisterReceiver((Context)this, this.freeformToggleReceiver);
        if (this.isSecondaryHome) {
            U.unregisterReceiver((Context)this, this.restartReceiver);
        }
        if (this.isWallpaperEnabled) {
            U.unregisterReceiver((Context)this, this.removeDesktopWallpaperReceiver);
            U.unregisterReceiver((Context)this, this.wallpaperChangeRequestReceiver);
        }
        if (this.isDesktopIconsEnabled) {
            U.unregisterReceiver((Context)this, this.refreshDesktopIconsReceiver);
            U.unregisterReceiver((Context)this, this.iconArrangeModeReceiver);
            U.unregisterReceiver((Context)this, this.sortDesktopIconsReceiver);
            U.unregisterReceiver((Context)this, this.updateMarginsReceiver);
            LauncherApps launcherApps = (LauncherApps)this.getSystemService("launcherapps");
            launcherApps.unregisterCallback(this.callback);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putBoolean("icon_arrange_mode", this.iconArrangeMode);
        super.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU");
    }

    private void killHomeActivity() {
        if (this.isSecondaryHome) {
            if (this.taskbarController != null) {
                this.taskbarController.onDestroyHost(this);
            }
            if (this.startMenuController != null) {
                this.startMenuController.onDestroyHost(this);
            }
            if (this.dashboardController != null) {
                this.dashboardController.onDestroyHost(this);
            }
            IconCache.getInstance((Context)this).clearCache();
            U.stopFreeformHack((Context)this);
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            if (pref.getBoolean("taskbar_active", false) && !pref.getBoolean("is_hidden", false)) {
                this.startService(new Intent((Context)this, TaskbarService.class));
                this.startService(new Intent((Context)this, StartMenuService.class));
                this.startService(new Intent((Context)this, DashboardService.class));
            }
        } else {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            if (!pref.getBoolean("taskbar_active", false) || pref.getBoolean("is_hidden", false)) {
                this.stopService(new Intent((Context)this, TaskbarService.class));
                this.stopService(new Intent((Context)this, StartMenuService.class));
                this.stopService(new Intent((Context)this, DashboardService.class));
                IconCache.getInstance((Context)this).clearCache();
                U.stopFreeformHack((Context)this);
            }
        }
        new Handler().post(() -> {
            this.setOnHomeScreen(false);
            this.finish();
        });
    }

    private void updateWindowFlags() {
        int flags = 24;
        if (FreeformHackHelper.getInstance().isTouchAbsorberActive() && U.isOverridingFreeformHack((Context)this)) {
            this.getWindow().setFlags(flags, flags);
        } else {
            this.getWindow().clearFlags(flags);
        }
    }

    @Override
    public void addView(View view, ViewParams params) {
        this.windowManager.addView(view, (ViewGroup.LayoutParams)params.toWindowManagerParams());
    }

    @Override
    public void removeView(View view) {
        this.windowManager.removeView(view);
    }

    @Override
    public void terminate() {
    }

    private void initDesktopIcons() {
        this.desktopIcons = new GridLayout((Context)this);
        this.fab = new FABWrapper((Context)this);
        this.updateMargins();
        this.refreshDesktopIcons();
        this.fab.setImageResource(R.drawable.tb_done);
        this.fab.view.setOnClickListener(v -> {
            this.iconArrangeMode = false;
            this.fab.hide();
            this.refreshDesktopIcons();
        });
        if (!this.iconArrangeMode) {
            this.fab.hide();
        }
        this.layout.addView((View)this.desktopIcons);
        this.layout.addView(this.fab.view);
    }

    private void refreshDesktopIcons() {
        if (this.desktopIcons == null) {
            return;
        }
        boolean taskbarIsVertical = TaskbarPosition.isVertical((Context)this);
        int iconSize = this.getResources().getDimensionPixelSize(R.dimen.tb_icon_size);
        int desktopIconSize = this.getResources().getDimensionPixelSize(R.dimen.tb_start_menu_grid_width);
        int columns = (this.layout.getWidth() - (taskbarIsVertical ? iconSize : 0)) / desktopIconSize;
        int rows = (this.layout.getHeight() - (!taskbarIsVertical ? iconSize : 0)) / desktopIconSize;
        this.desktopIcons.removeAllViews();
        this.desktopIcons.setOrientation(1);
        this.desktopIcons.setColumnCount(columns);
        this.desktopIcons.setRowCount(rows);
        LauncherApps launcherApps = (LauncherApps)this.getSystemService("launcherapps");
        UserManager userManager = (UserManager)this.getSystemService("user");
        SparseArray icons = new SparseArray();
        ArrayList<Integer> iconsToRemove = new ArrayList<Integer>();
        try {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            JSONArray jsonIcons = new JSONArray(pref.getString("desktop_icons", "[]"));
            for (int i = 0; i < jsonIcons.length(); ++i) {
                DesktopIconInfo info = DesktopIconInfo.fromJson(jsonIcons.getJSONObject(i));
                if (info == null) continue;
                if (launcherApps.isActivityEnabled(ComponentName.unflattenFromString((String)info.entry.getComponentName()), userManager.getUserForSerialNumber(info.entry.getUserId((Context)this)))) {
                    icons.put(this.getIndex(info), (Object)info);
                    continue;
                }
                iconsToRemove.add(i);
            }
            if (!iconsToRemove.isEmpty()) {
                Iterator i = iconsToRemove.iterator();
                while (i.hasNext()) {
                    int i2 = (Integer)i.next();
                    jsonIcons.remove(i2);
                }
                pref.edit().putString("desktop_icons", jsonIcons.toString()).apply();
            }
        }
        catch (JSONException pref) {
            // empty catch block
        }
        for (int i = 0; i < columns * rows; ++i) {
            GridLayout.LayoutParams params = new GridLayout.LayoutParams(GridLayout.spec((int)Integer.MIN_VALUE, (GridLayout.Alignment)GridLayout.FILL, (float)1.0f), GridLayout.spec((int)Integer.MIN_VALUE, (GridLayout.Alignment)GridLayout.FILL, (float)1.0f));
            params.width = 0;
            params.height = 0;
            FrameLayout iconContainer = new FrameLayout((Context)this);
            iconContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            iconContainer.setOnDragListener((View.OnDragListener)new DesktopIconDragListener());
            int index = i;
            iconContainer.setOnClickListener(view -> {
                boolean isStartMenuOpen = MenuHelper.getInstance().isStartMenuOpen();
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU");
                DesktopIconInfo info = (DesktopIconInfo)icons.get(index);
                if (!isStartMenuOpen && info != null && info.entry != null) {
                    U.launchApp((Context)this, info.entry, null, false, false, view);
                }
            });
            iconContainer.setOnLongClickListener(view -> {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                DesktopIconInfo info = (DesktopIconInfo)icons.get(index);
                if (info == null) {
                    info = this.getDesktopIconInfo(index);
                }
                this.openContextMenu(info, location);
                return true;
            });
            iconContainer.setOnGenericMotionListener((view, motionEvent) -> {
                int action = motionEvent.getAction();
                if (action == 11 && motionEvent.getButtonState() == 2) {
                    int[] location = new int[2];
                    view.getLocationOnScreen(location);
                    DesktopIconInfo info = (DesktopIconInfo)icons.get(index);
                    if (info == null) {
                        info = this.getDesktopIconInfo(index);
                    }
                    this.openContextMenu(info, location);
                }
                return false;
            });
            iconContainer.setOnTouchListener((v, event) -> {
                if (this.detector != null) {
                    this.detector.onTouchEvent(event);
                }
                return false;
            });
            iconContainer.setFocusable(false);
            DesktopIconInfo info = (DesktopIconInfo)icons.get(index);
            if (info != null && info.entry != null && info.column < columns && info.row < rows) {
                iconContainer.addView(this.inflateDesktopIcon((ViewGroup)iconContainer, info.entry));
            }
            this.desktopIcons.addView((View)iconContainer);
        }
    }

    private void sortDesktopIcons() {
        try {
            int i;
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            JSONArray jsonIcons = new JSONArray(pref.getString("desktop_icons", "[]"));
            if (jsonIcons.length() == 0) {
                U.showToast((Context)this, R.string.tb_no_icons_to_sort);
                return;
            }
            ArrayList<DesktopIconInfo> icons = new ArrayList<DesktopIconInfo>();
            for (i = 0; i < jsonIcons.length(); ++i) {
                DesktopIconInfo info = DesktopIconInfo.fromJson(jsonIcons.getJSONObject(i));
                if (info == null) continue;
                icons.add(info);
            }
            Collections.sort(icons, (o1, o2) -> Collator.getInstance().compare(o1.entry.getLabel(), o2.entry.getLabel()));
            jsonIcons = new JSONArray();
            for (i = 0; i < icons.size(); ++i) {
                DesktopIconInfo oldInfo = (DesktopIconInfo)icons.get(i);
                DesktopIconInfo newInfo = this.getDesktopIconInfo(i);
                oldInfo.column = newInfo.column;
                oldInfo.row = newInfo.row;
                jsonIcons.put((Object)oldInfo.toJson((Context)this));
            }
            pref.edit().putString("desktop_icons", jsonIcons.toString()).apply();
            this.refreshDesktopIcons();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void reassignDroppedIcon() {
        if (this.startDragIndex == this.endDragIndex) {
            return;
        }
        try {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            JSONArray jsonIcons = new JSONArray(pref.getString("desktop_icons", "[]"));
            int iconToRemove = -1;
            DesktopIconInfo oldInfo = this.getDesktopIconInfo(this.startDragIndex);
            DesktopIconInfo newInfo = this.getDesktopIconInfo(this.endDragIndex);
            for (int i = 0; i < jsonIcons.length(); ++i) {
                DesktopIconInfo info = DesktopIconInfo.fromJson(jsonIcons.getJSONObject(i));
                if (info == null || info.column != oldInfo.column || info.row != oldInfo.row) continue;
                newInfo.entry = info.entry;
                iconToRemove = i;
                break;
            }
            if (iconToRemove > -1) {
                jsonIcons.remove(iconToRemove);
                jsonIcons.put((Object)newInfo.toJson((Context)this));
                pref.edit().putString("desktop_icons", jsonIcons.toString()).apply();
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void enterIconArrangeMode() {
        try {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            JSONArray jsonIcons = new JSONArray(pref.getString("desktop_icons", "[]"));
            if (jsonIcons.length() == 0) {
                U.showToast((Context)this, R.string.tb_no_icons_to_arrange);
                return;
            }
            this.fab.view.setBackgroundTintList(ColorStateList.valueOf((int)ColorUtils.setAlphaComponent((int)U.getAccentColor((Context)this), (int)255)));
            this.iconArrangeMode = true;
            this.fab.show();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void updateMargins() {
        if (this.desktopIcons == null || this.fab == null) {
            return;
        }
        String position = TaskbarPosition.getTaskbarPosition((Context)this);
        int iconSize = this.getResources().getDimensionPixelSize(R.dimen.tb_icon_size);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (TaskbarPosition.isVerticalLeft(position)) {
            left = iconSize;
        } else if (TaskbarPosition.isVerticalRight(position)) {
            right = iconSize;
        } else if (TaskbarPosition.isBottom(position)) {
            bottom = iconSize;
        } else {
            top = iconSize;
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.setMargins(left, top, right, bottom);
        this.desktopIcons.setLayoutParams((ViewGroup.LayoutParams)params);
        int fabMargin = this.getResources().getDimensionPixelSize(R.dimen.tb_desktop_icon_fab_margin);
        FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
        params2.gravity = 0x800055;
        params2.setMargins(left += fabMargin, top += fabMargin, right += fabMargin, bottom += fabMargin);
        this.fab.view.setLayoutParams((ViewGroup.LayoutParams)params2);
    }

    private int getIndex(DesktopIconInfo info) {
        return info.column * this.desktopIcons.getRowCount() + info.row;
    }

    private DesktopIconInfo getDesktopIconInfo(int index) {
        int row = index % this.desktopIcons.getRowCount();
        int pos = index;
        int column = -1;
        while (pos >= 0) {
            pos -= this.desktopIcons.getRowCount();
            ++column;
        }
        return new DesktopIconInfo(column, row, null);
    }

    private View inflateDesktopIcon(ViewGroup parent, AppEntry entry) {
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        View icon = LayoutInflater.from((Context)this).inflate(R.layout.tb_row_alt, parent, false);
        TextView textView = (TextView)icon.findViewById(R.id.name);
        textView.setText((CharSequence)(pref.getBoolean("hide_icon_labels", false) ? "" : entry.getLabel()));
        textView.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.tb_desktop_icon_text));
        textView.setShadowLayer(10.0f, 0.0f, 0.0f, R.color.tb_desktop_icon_shadow);
        ImageView imageView = (ImageView)icon.findViewById(R.id.icon);
        imageView.setImageDrawable(entry.getIcon((Context)this));
        icon.setOnTouchListener((View.OnTouchListener)new DesktopIconTouchListener());
        return icon;
    }

    private void openContextMenu(DesktopIconInfo info, int[] location) {
        if (this.iconArrangeMode) {
            return;
        }
        Bundle args = new Bundle();
        args.putSerializable("app_entry", (Serializable)info.entry);
        args.putSerializable("desktop_icon", (Serializable)info);
        args.putInt("x", location[0]);
        args.putInt("y", location[1]);
        U.startContextMenuActivity((Context)this, args);
    }

    private void setOnHomeScreen(boolean value) {
        LauncherHelper helper = LauncherHelper.getInstance();
        if (this.isSecondaryHome) {
            int displayID = this.windowManager.getDefaultDisplay().getDisplayId();
            if (displayID == 0) {
                this.finish();
                return;
            }
            helper.setOnSecondaryHomeScreen(value, displayID);
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            if (pref.getBoolean("auto_hide_navbar_desktop_mode", false)) {
                U.showHideNavigationBar((Context)this, displayID, !value, 0);
            }
        } else {
            helper.setOnPrimaryHomeScreen(value);
        }
    }

    public void onTopResumedActivityChanged(boolean isTopResumedActivity) {
        if (isTopResumedActivity) {
            this.performOnResumeLogic();
        }
    }

    private void performOnResumeLogic() {
        if (this.waitingForPermission) {
            this.waitingForPermission = false;
            this.init();
        }
        this.overridePendingTransition(0, R.anim.close_anim);
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_SHOW_TASKBAR");
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 1001) {
            if (data.getData() == null) {
                return;
            }
            if (U.importImage((Context)this, data.getData(), "desktop_wallpaper")) {
                U.applyCustomImage((Context)this, "desktop_wallpaper", this.wallpaper, null);
                this.getWindow().setNavigationBarColor(-16777216);
            }
        }
    }

    private void removeCustomWallpaper() {
        File file = new File(this.getFilesDir() + "/tb_images", "desktop_wallpaper");
        if (file.exists()) {
            file.delete();
        }
        if (this.wallpaper != null) {
            this.wallpaper.setImageDrawable(null);
        }
        this.getWindow().setNavigationBarColor(0);
    }

    private final class DesktopIconDragListener
    implements View.OnDragListener {
        private DesktopIconDragListener() {
        }

        public boolean onDrag(View v, DragEvent event) {
            switch (event.getAction()) {
                default: {
                    break;
                }
                case 5: {
                    FrameLayout container = (FrameLayout)v;
                    if (container.getChildCount() != 0 && HomeActivityDelegate.this.startDragIndex != HomeActivityDelegate.this.desktopIcons.indexOfChild((View)container)) break;
                    v.setBackgroundColor(U.getAccentColor((Context)HomeActivityDelegate.this));
                    v.setAlpha(0.5f);
                    break;
                }
                case 4: {
                    View view = (View)event.getLocalState();
                    view.setVisibility(0);
                }
                case 6: {
                    v.setBackground(null);
                    v.setAlpha(1.0f);
                    break;
                }
                case 3: {
                    FrameLayout container2 = (FrameLayout)v;
                    if (container2.getChildCount() != 0) break;
                    View view2 = (View)event.getLocalState();
                    ViewGroup owner = (ViewGroup)view2.getParent();
                    owner.removeView(view2);
                    container2.addView(view2);
                    HomeActivityDelegate.this.endDragIndex = HomeActivityDelegate.this.desktopIcons.indexOfChild((View)container2);
                    HomeActivityDelegate.this.reassignDroppedIcon();
                }
            }
            return true;
        }
    }

    private final class DesktopIconTouchListener
    implements View.OnTouchListener {
        private DesktopIconTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (HomeActivityDelegate.this.iconArrangeMode && motionEvent.getAction() == 0) {
                HomeActivityDelegate.this.startDragIndex = HomeActivityDelegate.this.desktopIcons.indexOfChild((View)((ViewGroup)view.getParent()));
                ClipData data = ClipData.newPlainText((CharSequence)"", (CharSequence)"");
                View.DragShadowBuilder shadowBuilder = new View.DragShadowBuilder(view);
                view.startDrag(data, shadowBuilder, (Object)view, 0);
                view.setVisibility(4);
                return true;
            }
            return false;
        }
    }
}

