/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.util.U;
import java.util.ArrayList;
import java.util.List;

public class HSLConfigActivity
extends AppCompatActivity {
    private boolean returnToSettings;
    ArrayList<String> packageIds;
    ArrayList<String> packageNames;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean isDarkTheme = U.isDarkTheme((Context)this);
        this.setTheme(isDarkTheme ? R.style.Taskbar_Dark : R.style.Taskbar);
        this.setContentView(R.layout.tb_activity_hsl_config);
        this.returnToSettings = this.getIntent().getBooleanExtra("return_to_settings", false);
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        pref.edit().putBoolean("desktop_mode", U.isDesktopModeSupported((Context)this)).apply();
        if (this.getSupportActionBar() == null) {
            return;
        }
        if (this.returnToSettings) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(this.returnToSettings);
            this.findViewById(R.id.space).setVisibility(8);
        } else {
            this.getSupportActionBar().setElevation(0.0f);
            this.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getWindow().setStatusBarColor(ContextCompat.getColor((Context)this, (int)(isDarkTheme ? R.color.tb_main_activity_background_dark : R.color.tb_main_activity_background)));
            if (!isDarkTheme && Build.VERSION.SDK_INT >= 23) {
                View view = this.getWindow().getDecorView();
                view.setSystemUiVisibility(view.getSystemUiVisibility() | 0x2000);
            }
            this.setTitle(null);
        }
    }

    protected void onStart() {
        super.onStart();
        this.packageIds = new ArrayList();
        this.packageNames = new ArrayList();
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        PackageManager manager = this.getPackageManager();
        List listOfLaunchers = manager.queryIntentActivities(homeIntent, 0);
        for (ResolveInfo launcher : listOfLaunchers) {
            String string2 = launcher.activityInfo.packageName;
            if (string2.equals("com.android.settings") || string2.equals("com.android.tv.settings") || string2.startsWith("com.farmerbb.taskbar")) continue;
            if (string2.equals("com.google.android.googlequicksearchbox")) {
                try {
                    this.packageNames.add(manager.getApplicationInfo("com.google.android.launcher", 0).loadLabel(manager).toString());
                    this.packageIds.add(string2);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {}
                continue;
            }
            this.packageNames.add(launcher.activityInfo.applicationInfo.loadLabel(manager).toString());
            this.packageIds.add(string2);
        }
        ListView listView = (ListView)this.findViewById(R.id.listView);
        TextView textView = (TextView)this.findViewById(R.id.textView);
        if (this.packageNames.size() > 0) {
            textView.setText(R.string.tb_hsl_main_activity_text);
            LauncherListAdapter adapter = new LauncherListAdapter((Context)this, this.packageNames);
            listView.setAdapter((ListAdapter)adapter);
            listView.setClickable(true);
            listView.setOnItemClickListener((arg0, arg1, position, arg3) -> {
                SharedPreferences pref = U.getSharedPreferences((Context)this);
                SharedPreferences.Editor editor = pref.edit();
                editor.putString("hsl_id", this.packageIds.get(position));
                editor.putString("hsl_name", this.packageNames.get(position));
                editor.apply();
                for (ResolveInfo launcher : listOfLaunchers) {
                    if (!this.packageIds.get(position).equals(launcher.activityInfo.packageName)) continue;
                    if (!this.returnToSettings) {
                        try {
                            this.startActivity(homeIntent);
                        }
                        catch (ActivityNotFoundException activityNotFoundException) {
                            // empty catch block
                        }
                    }
                    this.finish();
                }
            });
        } else {
            textView.setText(R.string.tb_hsl_no_launchers_found);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (!this.returnToSettings) {
            this.getMenuInflater().inflate(R.menu.tb_hsl_config, menu2);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_settings) {
            Intent intent = new Intent((Context)this, MainActivity.class);
            intent.addFlags(0x10000000);
            this.startActivity(intent);
        } else if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return true;
    }

    public void onBackPressed() {
        if (this.returnToSettings) {
            super.onBackPressed();
        }
    }

    private final class LauncherListAdapter
    extends ArrayAdapter<String> {
        private LauncherListAdapter(Context context, ArrayList<String> notes) {
            super(context, R.layout.tb_hsl_row_layout, notes);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            String launcher = (String)this.getItem(position);
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tb_hsl_row_layout, parent, false);
            }
            TextView launcherTitle = (TextView)convertView.findViewById(R.id.launcherTitle);
            launcherTitle.setText((CharSequence)launcher);
            return convertView;
        }
    }
}

