/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.DimScreenActivity;
import com.farmerbb.taskbar.activity.HSLConfigActivity;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.fragment.DesktopModeFragment;
import com.farmerbb.taskbar.util.U;
import java.util.List;

public class HSLActivity
extends Activity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        if (DesktopModeFragment.isConfiguringHomeApp) {
            int enter = this.getResources().getIdentifier("activity_close_enter", "anim", "android");
            int exit = this.getResources().getIdentifier("activity_close_exit", "anim", "android");
            this.startActivity(new Intent((Context)this, MainActivity.class));
            this.overridePendingTransition(enter, exit);
        } else if (pref.getBoolean("dim_screen", false) && U.isDesktopModeActive((Context)this)) {
            this.startActivity(new Intent((Context)this, DimScreenActivity.class));
        } else {
            this.startPrimaryLauncher();
        }
        this.finish();
    }

    private void startPrimaryLauncher() {
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        String activityToLaunch = pref.getString("hsl_id", "null");
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        PackageManager manager = this.getPackageManager();
        List listOfLaunchers = manager.queryIntentActivities(homeIntent, 0);
        try {
            manager.getApplicationInfo(activityToLaunch, 0);
            for (ResolveInfo launcher : listOfLaunchers) {
                if (activityToLaunch.equals("com.google.android.googlequicksearchbox")) {
                    try {
                        manager.getApplicationInfo("com.google.android.launcher", 0);
                        if (!activityToLaunch.equals(launcher.activityInfo.packageName)) continue;
                        activityToLaunch = activityToLaunch + "/" + launcher.activityInfo.name;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        activityToLaunch = "null";
                    }
                    continue;
                }
                if (!activityToLaunch.equals(launcher.activityInfo.packageName)) continue;
                activityToLaunch = activityToLaunch + "/" + launcher.activityInfo.name;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            activityToLaunch = "null";
        }
        if (activityToLaunch.equals("null")) {
            this.launcherNotFound();
        } else {
            Intent intent = this.getIntent();
            intent.setComponent(ComponentName.unflattenFromString((String)activityToLaunch));
            try {
                this.startActivity(intent);
                new Handler().post(() -> this.startActivity(intent));
            }
            catch (ActivityNotFoundException e) {
                this.launcherNotFound();
            }
        }
    }

    private void launcherNotFound() {
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        if (!pref.getString("hsl_name", "null").equals("null")) {
            U.showToast((Context)this, this.getString(R.string.tb_hsl_launcher_uninstalled, new Object[]{pref.getString("hsl_name", "null")}), 1);
        }
        Intent intent = new Intent((Context)this, HSLConfigActivity.class);
        this.startActivity(intent);
    }
}

