/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.UserManager;
import android.view.View;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.util.ApplicationType;
import com.farmerbb.taskbar.util.Callbacks;
import com.farmerbb.taskbar.util.U;

public class DummyActivity
extends Activity {
    boolean shouldFinish = false;
    boolean finishOnPause = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(new View((Context)this));
        if (this.getIntent().hasExtra("finish_on_pause")) {
            this.finishOnPause = true;
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    @TargetApi(value=24)
    protected void onResume() {
        super.onResume();
        if (this.shouldFinish) {
            this.finish();
        } else {
            this.shouldFinish = true;
            if (this.getIntent().hasExtra("uninstall")) {
                UserManager userManager = (UserManager)this.getSystemService("user");
                Intent intent = new Intent("android.intent.action.DELETE", Uri.parse((String)("package:" + this.getIntent().getStringExtra("uninstall"))));
                intent.putExtra("android.intent.extra.USER", (Parcelable)userManager.getUserForSerialNumber(this.getIntent().getLongExtra("user_id", 0L)));
                try {
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException activityNotFoundException) {}
            } else if (this.getIntent().hasExtra("accessibility")) {
                AlertDialog.Builder builder = new AlertDialog.Builder(U.wrapContext((Context)this));
                builder.setTitle(R.string.tb_permission_dialog_title).setMessage(R.string.tb_enable_accessibility).setNegativeButton(R.string.tb_action_cancel, (dialog, which) -> new Handler().post(() -> ((DummyActivity)this).finish())).setPositiveButton(R.string.tb_action_activate, (dialog, which) -> {
                    Intent intent = new Intent("android.settings.ACCESSIBILITY_SETTINGS");
                    SharedPreferences pref = U.getSharedPreferences((Context)this);
                    if (pref.getBoolean("disable_animations", false)) {
                        intent.addFlags(65536);
                    }
                    U.launchApp((Context)this, () -> {
                        try {
                            this.startActivity(intent, U.getActivityOptionsBundle((Context)this, ApplicationType.APP_PORTRAIT, null));
                            U.showToastLong((Context)this, R.string.tb_usage_stats_message);
                        }
                        catch (ActivityNotFoundException e) {
                            U.showToast((Context)this, R.string.tb_lock_device_not_supported);
                            this.finish();
                        }
                    });
                });
                AlertDialog dialog2 = builder.create();
                dialog2.show();
                dialog2.setCancelable(false);
            } else if (this.getIntent().hasExtra("start_freeform_hack")) {
                if (U.hasFreeformSupport((Context)this) && U.isFreeformModeEnabled((Context)this) && !FreeformHackHelper.getInstance().isFreeformHackActive()) {
                    U.startFreeformHack((Context)this, true);
                }
                this.finish();
            } else if (this.getIntent().hasExtra("show_permission_dialog")) {
                U.showPermissionDialog(U.wrapContext((Context)this), new Callbacks(null, () -> ((DummyActivity)this).finish()));
            } else if (this.getIntent().hasExtra("show_recent_apps_dialog")) {
                U.showRecentAppsDialog(U.wrapContext((Context)this), new Callbacks(null, () -> ((DummyActivity)this).finish()));
            } else if (!this.finishOnPause) {
                this.finish();
            }
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.finishOnPause) {
            this.finish();
        }
    }
}

