/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.util.U;

public class DimScreenActivity
extends AppCompatActivity {
    private boolean isResumed = false;
    private boolean isTopResumed = false;
    private DisplayManager.DisplayListener listener = new DisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
            DimScreenActivity.this.checkIfShouldFinish();
        }

        public void onDisplayChanged(int displayId) {
            DimScreenActivity.this.checkIfShouldFinish();
        }

        public void onDisplayRemoved(int displayId) {
            DimScreenActivity.this.checkIfShouldFinish();
        }
    };
    private BroadcastReceiver unDimScreenReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DimScreenActivity.this.dimScreen(false);
        }
    };
    private BroadcastReceiver finishReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DimScreenActivity.this.finish();
        }
    };

    private boolean checkIfShouldFinish() {
        boolean shouldFinish;
        boolean bl = shouldFinish = !U.isDesktopModeActive((Context)this);
        if (shouldFinish) {
            this.finish();
        }
        return shouldFinish;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tb_activity_hsl_config);
        this.setRequestedOrientation(1);
        TextView textView = (TextView)this.findViewById(R.id.textView);
        textView.setText(R.string.tb_desktop_mode_is_active);
        DisplayManager manager = (DisplayManager)this.getSystemService("display");
        manager.registerDisplayListener(this.listener, null);
        U.registerReceiver((Context)this, this.unDimScreenReceiver, "com.farmerbb.taskbar.ACTION_UNDIM_SCREEN");
        U.registerReceiver((Context)this, this.finishReceiver, "com.farmerbb.taskbar.FINISH_DIM_SCREEN_ACTIVITY", "com.farmerbb.taskbar.KILL_HOME_ACTIVITY");
        if (this.getSupportActionBar() == null) {
            return;
        }
        this.getSupportActionBar().setElevation(0.0f);
        this.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setTitle(null);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (this.isResumed && this.isTopResumed) {
            this.dimScreen(hasFocus);
        }
    }

    protected void onDestroy() {
        DisplayManager manager = (DisplayManager)this.getSystemService("display");
        manager.unregisterDisplayListener(this.listener);
        U.unregisterReceiver((Context)this, this.unDimScreenReceiver);
        U.unregisterReceiver((Context)this, this.finishReceiver);
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.tb_hsl_config, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_settings) {
            Intent intent = new Intent((Context)this, MainActivity.class);
            intent.addFlags(0x10000000);
            this.startActivity(intent);
        }
        return true;
    }

    public void onBackPressed() {
    }

    public void onTopResumedActivityChanged(boolean isTopResumedActivity) {
        this.isTopResumed = isTopResumedActivity;
        this.dimScreen(true);
    }

    protected void onPause() {
        super.onPause();
        this.isResumed = false;
        this.dimScreen(false);
    }

    protected void onResume() {
        super.onResume();
        this.isResumed = true;
        this.dimScreen(true);
    }

    private void dimScreen(boolean shouldDim) {
        if (this.checkIfShouldFinish()) {
            return;
        }
        WindowManager.LayoutParams wmParams = this.getWindow().getAttributes();
        wmParams.screenBrightness = shouldDim ? 0.003921569f : -1.0f;
        this.getWindow().setAttributes(wmParams);
        if (shouldDim) {
            View view = this.getWindow().getDecorView();
            view.setSystemUiVisibility(4102);
        }
    }
}

