/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.appwidget.AppWidgetHost;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.helper.DashboardHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.U;

public class DashboardActivity
extends Activity {
    private AppWidgetManager mAppWidgetManager;
    private AppWidgetHost mAppWidgetHost;
    private final int REQUEST_PICK_APPWIDGET = 456;
    private final int REQUEST_CREATE_APPWIDGET = 789;
    private boolean shouldFinish = true;
    private boolean shouldCollapse = true;
    private boolean contextMenuFix = false;
    private int cellId = -1;
    private BroadcastReceiver addWidgetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardActivity.this.mAppWidgetManager = AppWidgetManager.getInstance((Context)context);
            DashboardActivity.this.mAppWidgetHost = new AppWidgetHost(context, intent.getIntExtra("appWidgetId", -1));
            DashboardActivity.this.cellId = intent.getIntExtra("cellId", -1);
            int appWidgetId = DashboardActivity.this.mAppWidgetHost.allocateAppWidgetId();
            Intent pickIntent = new Intent("android.appwidget.action.APPWIDGET_PICK");
            pickIntent.putExtra("appWidgetId", appWidgetId);
            try {
                DashboardActivity.this.startActivityForResult(pickIntent, 456);
                U.sendBroadcast((Context)DashboardActivity.this, "com.farmerbb.taskbar.TEMP_HIDE_TASKBAR");
            }
            catch (ActivityNotFoundException e) {
                U.showToast((Context)DashboardActivity.this, R.string.tb_lock_device_not_supported);
                DashboardActivity.this.finish();
            }
            DashboardActivity.this.shouldFinish = false;
        }
    };
    private BroadcastReceiver removeWidgetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardActivity.this.cellId = intent.getIntExtra("cellId", -1);
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)DashboardActivity.this);
            builder.setTitle(R.string.tb_remove_widget).setMessage(R.string.tb_are_you_sure).setNegativeButton(R.string.tb_action_cancel, (dialog, which) -> {
                U.sendBroadcast((Context)DashboardActivity.this, "com.farmerbb.taskbar.REMOVE_WIDGET_COMPLETED");
                DashboardActivity.this.shouldFinish = true;
            }).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> {
                Intent intent1 = new Intent("com.farmerbb.taskbar.REMOVE_WIDGET_COMPLETED");
                intent1.putExtra("cellId", DashboardActivity.this.cellId);
                U.sendBroadcast((Context)DashboardActivity.this, intent1);
                DashboardActivity.this.shouldFinish = true;
            });
            AlertDialog dialog2 = builder.create();
            dialog2.show();
            dialog2.setCancelable(false);
            DashboardActivity.this.shouldFinish = false;
        }
    };
    private BroadcastReceiver finishReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardActivity.this.shouldCollapse = false;
            if (DashboardActivity.this.contextMenuFix) {
                U.startFreeformHack((Context)DashboardActivity.this);
            }
            DashboardActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.contextMenuFix = this.getIntent().hasExtra("context_menu_fix");
        this.getWindow().setFlags(32, 32);
        this.getWindow().setFlags(262144, 262144);
        DisplayInfo display = U.getDisplayInfo((Context)this);
        this.setContentView(R.layout.tb_incognito);
        LinearLayout layout2 = (LinearLayout)this.findViewById(R.id.incognitoLayout);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(display.width, display.height));
        U.registerReceiver((Context)this, this.addWidgetReceiver, "com.farmerbb.taskbar.ADD_WIDGET_REQUESTED");
        U.registerReceiver((Context)this, this.removeWidgetReceiver, "com.farmerbb.taskbar.REMOVE_WIDGET_REQUESTED");
        U.registerReceiver((Context)this, this.finishReceiver, "com.farmerbb.taskbar.DASHBOARD_DISAPPEARING");
        if (!DashboardHelper.getInstance().isDashboardOpen()) {
            this.finish();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 || event.getAction() == 4) {
            this.onBackPressed();
        }
        return super.onTouchEvent(event);
    }

    public void onBackPressed() {
        if (this.contextMenuFix) {
            U.startFreeformHack((Context)this);
        }
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_DASHBOARD");
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            event.getKeyCode();
            return true;
        }
        return super.dispatchKeyShortcutEvent(event);
    }

    public void onTopResumedActivityChanged(boolean isTopResumedActivity) {
        if (!isTopResumedActivity) {
            this.performOnPauseLogic();
        }
    }

    protected void onPause() {
        super.onPause();
        if (Build.VERSION.SDK_INT <= 28) {
            this.performOnPauseLogic();
        }
    }

    private void performOnPauseLogic() {
        if (this.shouldFinish) {
            if (this.shouldCollapse) {
                if (U.shouldCollapse((Context)this, true)) {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_TASKBAR");
                } else {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU");
                }
            }
            this.contextMenuFix = false;
            this.onBackPressed();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        U.unregisterReceiver((Context)this, this.addWidgetReceiver);
        U.unregisterReceiver((Context)this, this.removeWidgetReceiver);
        U.unregisterReceiver((Context)this, this.finishReceiver);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            if (requestCode == 456) {
                this.configureWidget(data);
            } else if (requestCode == 789) {
                this.createWidget(data);
            }
        } else if (resultCode == 0) {
            int appWidgetId;
            if (data != null && (appWidgetId = data.getIntExtra("appWidgetId", -1)) != -1) {
                this.mAppWidgetHost.deleteAppWidgetId(appWidgetId);
            }
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.ADD_WIDGET_COMPLETED");
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_SHOW_TASKBAR");
            this.shouldFinish = true;
        }
    }

    private void configureWidget(Intent data) {
        Bundle extras = data.getExtras();
        int appWidgetId = extras.getInt("appWidgetId", -1);
        AppWidgetProviderInfo appWidgetInfo = this.mAppWidgetManager.getAppWidgetInfo(appWidgetId);
        if (appWidgetInfo.configure != null) {
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_CONFIGURE");
            intent.setComponent(appWidgetInfo.configure);
            intent.putExtra("appWidgetId", appWidgetId);
            this.startActivityForResult(intent, 789);
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            if (LauncherHelper.getInstance().isOnHomeScreen((Context)this) && (!pref.getBoolean("taskbar_active", false) || pref.getBoolean("is_hidden", false))) {
                pref.edit().putBoolean("dont_stop_dashboard", true).apply();
            }
            this.shouldFinish = false;
        } else {
            this.createWidget(data);
        }
    }

    private void createWidget(Intent data) {
        Intent intent = new Intent("com.farmerbb.taskbar.ADD_WIDGET_COMPLETED");
        intent.putExtra("appWidgetId", data.getExtras().getInt("appWidgetId", -1));
        intent.putExtra("cellId", this.cellId);
        U.sendBroadcast((Context)this, intent);
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_SHOW_TASKBAR");
        this.shouldFinish = true;
    }
}

