/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.UserManager;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.view.View;
import android.view.WindowManager;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.DesktopIconSelectAppActivity;
import com.farmerbb.taskbar.activity.DummyActivity;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.activity.SelectAppActivity;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.helper.MenuHelper;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.ApplicationType;
import com.farmerbb.taskbar.util.DesktopIconInfo;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.PinnedBlockedApps;
import com.farmerbb.taskbar.util.SavedWindowSizes;
import com.farmerbb.taskbar.util.TaskbarPosition;
import com.farmerbb.taskbar.util.U;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class ContextMenuActivity
extends PreferenceActivity
implements Preference.OnPreferenceClickListener {
    private AppEntry entry;
    private DesktopIconInfo desktopIcon;
    boolean showStartMenu = false;
    boolean shouldHideTaskbar = false;
    boolean isStartButton = false;
    boolean isOverflowMenu = false;
    boolean secondaryMenu = false;
    boolean dashboardOrStartMenuAppearing = false;
    boolean contextMenuFix = false;
    boolean showQuitOption = false;
    List<ShortcutInfo> shortcuts;
    private BroadcastReceiver dashboardOrStartMenuAppearingReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ContextMenuActivity.this.dashboardOrStartMenuAppearing = true;
            ContextMenuActivity.this.finish();
        }
    };
    private BroadcastReceiver finishReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ContextMenuActivity.this.finish();
        }
    };

    @SuppressLint(value={"RtlHardcoded"})
    protected void onPostCreate(Bundle savedInstanceState) {
        View view;
        SharedPreferences pref;
        int x;
        super.onPostCreate(savedInstanceState);
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.CONTEXT_MENU_APPEARING");
        MenuHelper.getInstance().setContextMenuOpen(true);
        Bundle args = this.getIntent().getBundleExtra("args");
        this.entry = (AppEntry)args.getSerializable("app_entry");
        this.desktopIcon = (DesktopIconInfo)args.getSerializable("desktop_icon");
        this.showStartMenu = args.getBoolean("launched_from_start_menu", false);
        this.isStartButton = this.entry == null && args.getBoolean("is_start_button", false);
        this.isOverflowMenu = this.entry == null && args.getBoolean("is_overflow_menu", false);
        this.contextMenuFix = args.containsKey("context_menu_fix");
        this.showQuitOption = !args.getBoolean("dont_show_quit", false);
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        if (args.containsKey("x") && args.containsKey("y")) {
            U.applyDisplayCutoutModeTo(params);
        }
        DisplayInfo display = U.getDisplayInfo((Context)this);
        int statusBarHeight = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
        }
        int contextMenuWidth = this.getResources().getDimensionPixelSize(R.dimen.tb_context_menu_width);
        if (this.showStartMenu || this.desktopIcon != null) {
            x = args.getInt("x", 0);
            int y = args.getInt("y", 0);
            int offsetResourceId = this.isOverflowMenu ? R.dimen.tb_context_menu_offset_overflow : R.dimen.tb_context_menu_offset;
            int offset = this.getResources().getDimensionPixelSize(offsetResourceId);
            switch (TaskbarPosition.getTaskbarPosition((Context)this)) {
                case "bottom_left": 
                case "bottom_vertical_left": {
                    params.gravity = 83;
                    params.x = x;
                    params.y = display.height - y - offset;
                    break;
                }
                case "bottom_right": 
                case "bottom_vertical_right": {
                    params.gravity = 83;
                    params.x = x - contextMenuWidth + offset + offset;
                    params.y = display.height - y - offset;
                    break;
                }
                case "top_left": 
                case "top_vertical_left": {
                    params.gravity = 51;
                    params.x = x;
                    params.y = y - offset + statusBarHeight;
                    break;
                }
                case "top_right": 
                case "top_vertical_right": {
                    params.gravity = 51;
                    params.x = x - contextMenuWidth + offset + offset;
                    params.y = y - offset + statusBarHeight;
                }
            }
        } else {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_START_MENU");
            x = args.getInt("x", display.width);
            int y = args.getInt("y", display.height);
            int offset = this.getResources().getDimensionPixelSize(R.dimen.tb_icon_size);
            switch (TaskbarPosition.getTaskbarPosition((Context)this)) {
                case "bottom_left": {
                    params.gravity = 83;
                    params.x = this.isStartButton ? 0 : x;
                    params.y = offset;
                    break;
                }
                case "bottom_vertical_left": {
                    params.gravity = 83;
                    params.x = offset;
                    params.y = display.height - y - (this.isStartButton ? 0 : offset);
                    break;
                }
                case "bottom_right": {
                    params.gravity = 85;
                    params.x = display.width - x;
                    params.y = offset;
                    break;
                }
                case "bottom_vertical_right": {
                    params.gravity = 85;
                    params.x = offset;
                    params.y = display.height - y - (this.isStartButton ? 0 : offset);
                    break;
                }
                case "top_left": {
                    params.gravity = 51;
                    params.x = this.isStartButton ? 0 : x;
                    params.y = offset;
                    break;
                }
                case "top_vertical_left": {
                    params.gravity = 51;
                    params.x = offset;
                    params.y = this.isStartButton ? 0 : y - statusBarHeight;
                    break;
                }
                case "top_right": {
                    params.gravity = 53;
                    params.x = display.width - x;
                    params.y = offset;
                    break;
                }
                case "top_vertical_right": {
                    params.gravity = 53;
                    params.x = offset;
                    int n = params.y = this.isStartButton ? 0 : y - statusBarHeight;
                }
            }
            if (!TaskbarPosition.isVertical((Context)this) && params.x > display.width / 2) {
                params.x = params.x - contextMenuWidth + offset;
            }
        }
        params.width = this.getResources().getDimensionPixelSize(R.dimen.tb_context_menu_width);
        params.dimAmount = 0.0f;
        if (U.isChromeOs((Context)this) && TaskbarPosition.isBottom((Context)this) && (pref = U.getSharedPreferences((Context)this)).getBoolean("chrome_os_context_menu_fix", true) && !pref.getBoolean("has_caption", false)) {
            params.y -= this.getResources().getDimensionPixelSize(R.dimen.tb_caption_offset);
        }
        this.getWindow().setAttributes(params);
        if (U.isChromeOs((Context)this) && Build.VERSION.SDK_INT >= 22) {
            this.getWindow().setElevation(0.0f);
        }
        if ((view = this.findViewById(16908298)) != null) {
            view.setPadding(0, 0, 0, 0);
        }
        this.generateMenu();
        U.registerReceiver((Context)this, this.dashboardOrStartMenuAppearingReceiver, "com.farmerbb.taskbar.START_MENU_APPEARING", "com.farmerbb.taskbar.DASHBOARD_APPEARING");
        U.registerReceiver((Context)this, this.finishReceiver, "com.farmerbb.taskbar.HIDE_CONTEXT_MENU");
    }

    private void generateMenu() {
        if (this.isStartButton) {
            this.addPreferencesFromResource(R.xml.tb_pref_context_menu_open_settings);
            this.findPreference("open_taskbar_settings").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("start_menu_apps").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            if (U.isFreeformModeEnabled((Context)this) && !U.isDesktopIconsEnabled((Context)this) && (U.launcherIsDefault((Context)this) && !U.isOverridingFreeformHack((Context)this, false) && FreeformHackHelper.getInstance().isInFreeformWorkspace() || U.isOverridingFreeformHack((Context)this, false) && LauncherHelper.getInstance().isOnHomeScreen((Context)this))) {
                this.addPreferencesFromResource(R.xml.tb_pref_context_menu_change_wallpaper);
                this.findPreference("change_wallpaper").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if (this.showQuitOption) {
                this.addPreferencesFromResource(R.xml.tb_pref_context_menu_quit);
                this.findPreference("quit_taskbar").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
        } else if (this.isOverflowMenu) {
            if (this.getResources().getConfiguration().screenWidthDp >= 600 && Build.VERSION.SDK_INT <= 23) {
                this.setTitle(R.string.tb_tools);
            } else {
                this.addPreferencesFromResource(R.xml.tb_pref_context_menu_header);
                this.findPreference("header").setTitle(R.string.tb_tools);
            }
            this.addPreferencesFromResource(R.xml.tb_pref_context_menu_overflow);
            this.findPreference("volume").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("system_settings").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            if (!U.isLibrary((Context)this)) {
                this.findPreference("power_menu").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else {
                this.getPreferenceScreen().removePreference(this.findPreference("power_menu"));
            }
            if (!U.isLibrary((Context)this) && Build.VERSION.SDK_INT >= 28) {
                this.findPreference("lock_device").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else {
                this.getPreferenceScreen().removePreference(this.findPreference("lock_device"));
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.findPreference("file_manager").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else {
                this.getPreferenceScreen().removePreference(this.findPreference("file_manager"));
            }
        } else if (this.desktopIcon != null && this.entry == null) {
            this.addPreferencesFromResource(R.xml.tb_pref_context_menu_desktop_icons);
            this.findPreference("add_icon_to_desktop").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("arrange_icons").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("sort_by_name").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("change_wallpaper").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        } else {
            if (this.getResources().getConfiguration().screenWidthDp >= 600 && Build.VERSION.SDK_INT <= 23) {
                this.setTitle(this.entry.getLabel());
            } else {
                this.addPreferencesFromResource(R.xml.tb_pref_context_menu_header);
                this.findPreference("header").setTitle((CharSequence)this.entry.getLabel());
            }
            if (U.hasFreeformSupport((Context)this) && U.isFreeformModeEnabled((Context)this) && !U.isGame((Context)this, this.entry.getPackageName())) {
                this.addPreferencesFromResource(R.xml.tb_pref_context_menu_show_window_sizes);
                this.findPreference("show_window_sizes").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if (Build.VERSION.SDK_INT >= 25) {
                int shortcutCount = this.getLauncherShortcuts();
                if (shortcutCount > 1) {
                    this.addPreferencesFromResource(R.xml.tb_pref_context_menu_shortcuts);
                    this.findPreference("app_shortcuts").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                } else if (shortcutCount == 1) {
                    this.generateShortcuts();
                }
            }
            PackageManager pm = this.getPackageManager();
            Intent homeIntent = new Intent("android.intent.action.MAIN");
            homeIntent.addCategory("android.intent.category.HOME");
            ResolveInfo defaultLauncher = pm.resolveActivity(homeIntent, 65536);
            if (this.desktopIcon != null) {
                this.addPreferencesFromResource(R.xml.tb_pref_context_menu_remove_desktop_icon);
                this.findPreference("arrange_icons").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                this.findPreference("remove_desktop_icon").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else if (!this.entry.getPackageName().contains("com.farmerbb.taskbar") && !this.entry.getPackageName().equals(defaultLauncher.activityInfo.packageName)) {
                PinnedBlockedApps pba = PinnedBlockedApps.getInstance((Context)this);
                if (pba.isPinned(this.entry.getComponentName())) {
                    this.addPreferencesFromResource(R.xml.tb_pref_context_menu_pin);
                    this.findPreference("pin_app").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                    this.findPreference("pin_app").setTitle(R.string.tb_unpin_app);
                } else if (pba.isBlocked(this.entry.getComponentName())) {
                    this.addPreferencesFromResource(R.xml.tb_pref_context_menu_block);
                    this.findPreference("block_app").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                    this.findPreference("block_app").setTitle(R.string.tb_unblock_app);
                } else {
                    int MAX_NUM_OF_COLUMNS = U.getMaxNumOfEntries((Context)this);
                    if (pba.getPinnedApps().size() < MAX_NUM_OF_COLUMNS) {
                        this.addPreferencesFromResource(R.xml.tb_pref_context_menu_pin);
                        this.findPreference("pin_app").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                        this.findPreference("pin_app").setTitle(R.string.tb_pin_app);
                    }
                    this.addPreferencesFromResource(R.xml.tb_pref_context_menu_block);
                    this.findPreference("block_app").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                    this.findPreference("block_app").setTitle(R.string.tb_block_app);
                }
            }
            this.addPreferencesFromResource(R.xml.tb_pref_context_menu);
            this.findPreference("app_info").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("uninstall").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        }
    }

    private void generateShortcuts() {
        this.addPreferencesFromResource(R.xml.tb_pref_context_menu_shortcut_list);
        switch (this.shortcuts.size()) {
            case 5: {
                this.findPreference("shortcut_5").setTitle(this.getShortcutTitle(this.shortcuts.get(4)));
                this.findPreference("shortcut_5").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            case 4: {
                this.findPreference("shortcut_4").setTitle(this.getShortcutTitle(this.shortcuts.get(3)));
                this.findPreference("shortcut_4").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            case 3: {
                this.findPreference("shortcut_3").setTitle(this.getShortcutTitle(this.shortcuts.get(2)));
                this.findPreference("shortcut_3").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            case 2: {
                this.findPreference("shortcut_2").setTitle(this.getShortcutTitle(this.shortcuts.get(1)));
                this.findPreference("shortcut_2").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            case 1: {
                this.findPreference("shortcut_1").setTitle(this.getShortcutTitle(this.shortcuts.get(0)));
                this.findPreference("shortcut_1").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
        }
        switch (this.shortcuts.size()) {
            case 1: {
                this.getPreferenceScreen().removePreference(this.findPreference("shortcut_2"));
            }
            case 2: {
                this.getPreferenceScreen().removePreference(this.findPreference("shortcut_3"));
            }
            case 3: {
                this.getPreferenceScreen().removePreference(this.findPreference("shortcut_4"));
            }
            case 4: {
                this.getPreferenceScreen().removePreference(this.findPreference("shortcut_5"));
            }
        }
    }

    private void generateWindowSizes() {
        this.getPreferenceScreen().removeAll();
        this.addPreferencesFromResource(R.xml.tb_pref_context_menu_window_size_list);
        this.findPreference("window_size_standard").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("window_size_large").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("window_size_fullscreen").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("window_size_half_left").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("window_size_half_right").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("window_size_phone_size").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        String windowSizePref = SavedWindowSizes.getInstance((Context)this).getWindowSize((Context)this, this.entry.getPackageName());
        CharSequence title = this.findPreference("window_size_" + windowSizePref).getTitle();
        this.findPreference("window_size_" + windowSizePref).setTitle((CharSequence)("\u2713 " + title));
    }

    private void generateWallpaperOptions() {
        this.getPreferenceScreen().removeAll();
        this.addPreferencesFromResource(R.xml.tb_pref_context_menu_change_wallpaper_secondary);
        this.findPreference("change_wallpaper_global").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("change_wallpaper_desktop").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        File file = new File(this.getFilesDir() + "/tb_images", "desktop_wallpaper");
        if (!file.exists()) {
            return;
        }
        this.addPreferencesFromResource(R.xml.tb_pref_remove_desktop_wallpaper);
        this.findPreference("remove_desktop_wallpaper").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
    }

    @TargetApi(value=25)
    public boolean onPreferenceClick(Preference p) {
        UserManager userManager = (UserManager)this.getSystemService("user");
        LauncherApps launcherApps = (LauncherApps)this.getSystemService("launcherapps");
        boolean appIsValid = this.isStartButton || this.isOverflowMenu || this.desktopIcon != null || this.entry != null && !launcherApps.getActivityList(this.entry.getPackageName(), userManager.getUserForSerialNumber(this.entry.getUserId((Context)this))).isEmpty();
        this.secondaryMenu = false;
        if (appIsValid) {
            switch (p.getKey()) {
                case "app_info": {
                    U.launchApp((Context)this, () -> launcherApps.startAppDetailsActivity(ComponentName.unflattenFromString((String)this.entry.getComponentName()), userManager.getUserForSerialNumber(this.entry.getUserId((Context)this)), null, U.getActivityOptionsBundle((Context)this, ApplicationType.APP_PORTRAIT, this.getListView().getChildAt(p.getOrder()))));
                    this.prepareToClose();
                    break;
                }
                case "uninstall": {
                    if (U.hasFreeformSupport((Context)this) && this.isInMultiWindowMode()) {
                        Intent intent2 = new Intent((Context)this, DummyActivity.class);
                        intent2.putExtra("uninstall", this.entry.getPackageName());
                        intent2.putExtra("user_id", this.entry.getUserId((Context)this));
                        try {
                            this.startActivity(intent2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else {
                        Intent intent2 = new Intent("android.intent.action.DELETE", Uri.parse((String)("package:" + this.entry.getPackageName())));
                        intent2.putExtra("android.intent.extra.USER", (Parcelable)userManager.getUserForSerialNumber(this.entry.getUserId((Context)this)));
                        try {
                            this.startActivity(intent2);
                        }
                        catch (ActivityNotFoundException | IllegalArgumentException throwable) {
                            // empty catch block
                        }
                    }
                    this.prepareToClose();
                    break;
                }
                case "open_taskbar_settings": {
                    U.launchApp((Context)this, () -> {
                        Intent intent2 = new Intent((Context)this, MainActivity.class);
                        intent2.setFlags(0x10008000);
                        LauncherHelper helper = LauncherHelper.getInstance();
                        if (helper.isOnHomeScreen((Context)this) || helper.isOnSecondaryHomeScreen((Context)this)) {
                            U.applyOpenInNewWindow((Context)this, intent2);
                        }
                        try {
                            this.startActivity(intent2, U.getActivityOptionsBundle((Context)this, ApplicationType.APP_PORTRAIT, this.getListView().getChildAt(p.getOrder())));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    });
                    this.prepareToClose();
                    break;
                }
                case "quit_taskbar": {
                    Intent quitIntent = new Intent("com.farmerbb.taskbar.QUIT");
                    quitIntent.setPackage(this.getPackageName());
                    this.sendBroadcast(quitIntent);
                    this.prepareToClose();
                    break;
                }
                case "pin_app": {
                    PinnedBlockedApps pba = PinnedBlockedApps.getInstance((Context)this);
                    if (pba.isPinned(this.entry.getComponentName())) {
                        pba.removePinnedApp((Context)this, this.entry.getComponentName());
                        break;
                    }
                    Intent intent = new Intent();
                    intent.setComponent(ComponentName.unflattenFromString((String)this.entry.getComponentName()));
                    LauncherActivityInfo appInfo = launcherApps.resolveActivity(intent, userManager.getUserForSerialNumber(this.entry.getUserId((Context)this)));
                    if (appInfo == null) break;
                    AppEntry newEntry = new AppEntry(this.entry.getPackageName(), this.entry.getComponentName(), this.entry.getLabel(), (Drawable)IconCache.getInstance((Context)this).getIcon((Context)this, appInfo), true);
                    newEntry.setUserId(this.entry.getUserId((Context)this));
                    pba.addPinnedApp((Context)this, newEntry);
                    break;
                }
                case "block_app": {
                    PinnedBlockedApps pba2 = PinnedBlockedApps.getInstance((Context)this);
                    if (pba2.isBlocked(this.entry.getComponentName())) {
                        pba2.removeBlockedApp((Context)this, this.entry.getComponentName());
                        break;
                    }
                    pba2.addBlockedApp((Context)this, this.entry);
                    break;
                }
                case "show_window_sizes": {
                    this.generateWindowSizes();
                    if (U.hasBrokenSetLaunchBoundsApi()) {
                        U.showToastLong((Context)this, R.string.tb_window_sizes_not_available);
                    }
                    this.getListView().setOnItemLongClickListener((parent, view, position, id2) -> {
                        String[] windowSizes = this.getResources().getStringArray(R.array.tb_pref_window_size_list_values);
                        SavedWindowSizes.getInstance((Context)this).setWindowSize((Context)this, this.entry.getPackageName(), windowSizes[position]);
                        this.generateWindowSizes();
                        return true;
                    });
                    this.secondaryMenu = true;
                    break;
                }
                case "window_size_standard": 
                case "window_size_large": 
                case "window_size_fullscreen": 
                case "window_size_half_left": 
                case "window_size_half_right": 
                case "window_size_phone_size": {
                    String windowSize = p.getKey().replace("window_size_", "");
                    SharedPreferences pref2 = U.getSharedPreferences((Context)this);
                    if (pref2.getBoolean("save_window_sizes", true)) {
                        SavedWindowSizes.getInstance((Context)this).setWindowSize((Context)this, this.entry.getPackageName(), windowSize);
                    }
                    U.launchApp(U.getDisplayContext((Context)this), this.entry, windowSize, false, true, this.getListView().getChildAt(p.getOrder()));
                    if (U.hasBrokenSetLaunchBoundsApi()) {
                        U.cancelToast();
                    }
                    this.prepareToClose();
                    break;
                }
                case "app_shortcuts": {
                    this.getPreferenceScreen().removeAll();
                    this.generateShortcuts();
                    this.secondaryMenu = true;
                    break;
                }
                case "shortcut_1": 
                case "shortcut_2": 
                case "shortcut_3": 
                case "shortcut_4": 
                case "shortcut_5": {
                    U.startShortcut(U.getDisplayContext((Context)this), this.entry, this.shortcuts.get(Integer.parseInt(p.getKey().replace("shortcut_", "")) - 1), this.getListView().getChildAt(p.getOrder()));
                    this.prepareToClose();
                    break;
                }
                case "start_menu_apps": {
                    Intent intent = U.getThemedIntent((Context)this, SelectAppActivity.class);
                    if (U.hasFreeformSupport((Context)this) && U.isFreeformModeEnabled((Context)this) && this.isInMultiWindowMode()) {
                        intent.putExtra("no_shadow", true);
                        intent.addFlags(0x10001000);
                        U.startActivityMaximized(U.getDisplayContext((Context)this), intent);
                    } else {
                        try {
                            this.startActivity(intent);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    this.prepareToClose();
                    break;
                }
                case "volume": {
                    AudioManager audio = (AudioManager)this.getSystemService("audio");
                    audio.adjustSuggestedStreamVolume(0, Integer.MIN_VALUE, 1);
                    if (LauncherHelper.getInstance().isOnSecondaryHomeScreen((Context)this)) {
                        U.showToast((Context)this, R.string.tb_opening_volume_control);
                        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.ACTION_UNDIM_SCREEN");
                    }
                    this.prepareToClose();
                    break;
                }
                case "file_manager": {
                    U.launchApp((Context)this, () -> {
                        Intent fileManagerIntent;
                        if (Build.VERSION.SDK_INT > 25) {
                            fileManagerIntent = new Intent("android.intent.action.VIEW");
                        } else if (Build.VERSION.SDK_INT >= 24) {
                            fileManagerIntent = new Intent("android.provider.action.BROWSE");
                        } else {
                            fileManagerIntent = new Intent("android.provider.action.BROWSE_DOCUMENT_ROOT");
                            fileManagerIntent.setComponent(ComponentName.unflattenFromString((String)"com.android.documentsui/.DocumentsActivity"));
                        }
                        fileManagerIntent.addCategory("android.intent.category.DEFAULT");
                        fileManagerIntent.setFlags(0x10000000);
                        fileManagerIntent.setData(Uri.parse((String)"content://com.android.externalstorage.documents/root/primary"));
                        try {
                            this.startActivity(fileManagerIntent, U.getActivityOptionsBundle((Context)this, ApplicationType.APP_PORTRAIT, this.getListView().getChildAt(p.getOrder())));
                        }
                        catch (ActivityNotFoundException e) {
                            U.showToast((Context)this, R.string.tb_lock_device_not_supported);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    });
                    this.prepareToClose();
                    break;
                }
                case "system_settings": {
                    U.launchApp((Context)this, () -> {
                        Intent settingsIntent = new Intent("android.settings.SETTINGS");
                        settingsIntent.setFlags(0x10000000);
                        try {
                            this.startActivity(settingsIntent, U.getActivityOptionsBundle((Context)this, ApplicationType.APP_PORTRAIT, this.getListView().getChildAt(p.getOrder())));
                        }
                        catch (ActivityNotFoundException e) {
                            U.showToast((Context)this, R.string.tb_lock_device_not_supported);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    });
                    this.prepareToClose();
                    break;
                }
                case "lock_device": {
                    U.lockDevice((Context)this);
                    this.prepareToClose();
                    break;
                }
                case "power_menu": {
                    U.sendAccessibilityAction((Context)this, 6, () -> {
                        if (LauncherHelper.getInstance().isOnSecondaryHomeScreen((Context)this)) {
                            U.showToast((Context)this, R.string.tb_opening_power_menu);
                            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.ACTION_UNDIM_SCREEN");
                        }
                    });
                    this.prepareToClose();
                    break;
                }
                case "add_icon_to_desktop": {
                    Intent intent2 = U.getThemedIntent((Context)this, DesktopIconSelectAppActivity.class);
                    intent2.putExtra("desktop_icon", (Serializable)this.desktopIcon);
                    if (U.hasFreeformSupport((Context)this) && U.isFreeformModeEnabled((Context)this) && this.isInMultiWindowMode()) {
                        intent2.putExtra("no_shadow", true);
                        intent2.addFlags(0x10001000);
                        U.startActivityMaximized(U.getDisplayContext((Context)this), intent2);
                    } else {
                        try {
                            this.startActivity(intent2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    this.prepareToClose();
                    break;
                }
                case "arrange_icons": {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.ENTER_ICON_ARRANGE_MODE");
                    break;
                }
                case "sort_by_name": {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.SORT_DESKTOP_ICONS");
                    break;
                }
                case "change_wallpaper": {
                    if (LauncherHelper.getInstance().isOnSecondaryHomeScreen((Context)this)) {
                        this.generateWallpaperOptions();
                        this.secondaryMenu = true;
                        break;
                    }
                    if (U.isChromeOs((Context)this)) {
                        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.WALLPAPER_CHANGE_REQUESTED");
                        break;
                    }
                    this.changeWallpaper();
                    this.prepareToClose();
                    break;
                }
                case "remove_desktop_icon": {
                    try {
                        SharedPreferences pref5 = U.getSharedPreferences((Context)this);
                        JSONArray jsonIcons = new JSONArray(pref5.getString("desktop_icons", "[]"));
                        int iconToRemove = -1;
                        for (int i = 0; i < jsonIcons.length(); ++i) {
                            DesktopIconInfo info = DesktopIconInfo.fromJson(jsonIcons.getJSONObject(i));
                            if (info == null || info.column != this.desktopIcon.column || info.row != this.desktopIcon.row) continue;
                            iconToRemove = i;
                            break;
                        }
                        if (iconToRemove <= -1) break;
                        jsonIcons.remove(iconToRemove);
                        pref5.edit().putString("desktop_icons", jsonIcons.toString()).apply();
                        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.REFRESH_DESKTOP_ICONS");
                    }
                    catch (JSONException jSONException) {}
                    break;
                }
                case "change_wallpaper_global": {
                    this.changeWallpaper();
                    this.prepareToClose();
                    break;
                }
                case "change_wallpaper_desktop": {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.WALLPAPER_CHANGE_REQUESTED");
                    break;
                }
                case "remove_desktop_wallpaper": {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.REMOVE_DESKTOP_WALLPAPER");
                }
            }
        }
        if (!this.secondaryMenu) {
            this.finish();
        }
        return true;
    }

    protected void onPause() {
        super.onPause();
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    public void finish() {
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.CONTEXT_MENU_DISAPPEARING");
        MenuHelper.getInstance().setContextMenuOpen(false);
        if (!this.dashboardOrStartMenuAppearing) {
            if (this.showStartMenu) {
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TOGGLE_START_MENU");
            } else {
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.RESET_START_MENU");
                if (this.shouldHideTaskbar && U.shouldCollapse((Context)this, true)) {
                    U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_TASKBAR");
                }
            }
        }
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        super.finish();
        if (this.showStartMenu || pref.getBoolean("disable_animations", false)) {
            this.overridePendingTransition(0, 0);
        }
    }

    @TargetApi(value=25)
    private int getLauncherShortcuts() {
        LauncherApps launcherApps = (LauncherApps)this.getSystemService("launcherapps");
        if (launcherApps.hasShortcutHostPermission()) {
            UserManager userManager = (UserManager)this.getSystemService("user");
            LauncherApps.ShortcutQuery query = new LauncherApps.ShortcutQuery();
            query.setActivity(ComponentName.unflattenFromString((String)this.entry.getComponentName()));
            query.setQueryFlags(11);
            this.shortcuts = launcherApps.getShortcuts(query, userManager.getUserForSerialNumber(this.entry.getUserId((Context)this)));
            if (this.shortcuts != null) {
                return this.shortcuts.size();
            }
        }
        return 0;
    }

    @TargetApi(value=25)
    private CharSequence getShortcutTitle(ShortcutInfo shortcut) {
        CharSequence longLabel = shortcut.getLongLabel();
        if (longLabel != null && longLabel.length() > 0 && longLabel.length() <= 20) {
            return longLabel;
        }
        return shortcut.getShortLabel();
    }

    public void onBackPressed() {
        if (this.secondaryMenu) {
            this.secondaryMenu = false;
            this.getPreferenceScreen().removeAll();
            this.generateMenu();
            this.getListView().setOnItemLongClickListener(null);
            if (U.hasBrokenSetLaunchBoundsApi()) {
                U.cancelToast();
            }
        } else {
            if (this.contextMenuFix && !this.showStartMenu) {
                U.startFreeformHack((Context)this);
            }
            super.onBackPressed();
            if (FreeformHackHelper.getInstance().isInFreeformWorkspace()) {
                this.overridePendingTransition(0, 0);
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        U.unregisterReceiver((Context)this, this.dashboardOrStartMenuAppearingReceiver);
        U.unregisterReceiver((Context)this, this.finishReceiver);
    }

    private void changeWallpaper() {
        if (LauncherHelper.getInstance().isOnHomeScreen((Context)this)) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TEMP_HIDE_TASKBAR");
        }
        Intent intent = Intent.createChooser((Intent)new Intent("android.intent.action.SET_WALLPAPER"), (CharSequence)this.getString(R.string.tb_set_wallpaper));
        intent.setFlags(0x10000000);
        U.startActivityMaximized(U.getDisplayContext((Context)this), intent);
    }

    private void prepareToClose() {
        this.showStartMenu = false;
        this.shouldHideTaskbar = true;
        this.contextMenuFix = false;
    }
}

