/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.util.Blacklist;
import com.farmerbb.taskbar.util.PinnedBlockedApps;
import com.farmerbb.taskbar.util.SavedWindowSizes;
import com.farmerbb.taskbar.util.ShortcutUtils;
import com.farmerbb.taskbar.util.TopApps;
import com.farmerbb.taskbar.util.U;

public class ClearDataActivity
extends AppCompatActivity {
    CheckBox pba;
    CheckBox hiddenApps;
    CheckBox topApps;
    CheckBox savedWindowSizes;
    CheckBox desktopIcons;
    CheckBox qsShortcuts;
    Button button;
    CompoundButton.OnCheckedChangeListener listener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (ClearDataActivity.this.pba.isChecked() || ClearDataActivity.this.hiddenApps.isChecked() || ClearDataActivity.this.topApps.isChecked() || ClearDataActivity.this.savedWindowSizes.isChecked() || ClearDataActivity.this.desktopIcons.isChecked() || ClearDataActivity.this.qsShortcuts.isChecked()) {
                ClearDataActivity.this.button.setText((CharSequence)ClearDataActivity.this.getResources().getString(R.string.tb_action_reset).toUpperCase());
            } else {
                ClearDataActivity.this.button.setText((CharSequence)ClearDataActivity.this.getResources().getString(R.string.tb_action_close).toUpperCase());
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tb_clear_data);
        this.setTitle(R.string.tb_clear_pinned_apps);
        this.pba = (CheckBox)this.findViewById(R.id.clear_pba);
        this.pba.setOnCheckedChangeListener(this.listener);
        this.hiddenApps = (CheckBox)this.findViewById(R.id.clear_hidden_apps);
        this.hiddenApps.setOnCheckedChangeListener(this.listener);
        this.topApps = (CheckBox)this.findViewById(R.id.clear_top_apps);
        this.topApps.setOnCheckedChangeListener(this.listener);
        this.savedWindowSizes = (CheckBox)this.findViewById(R.id.clear_window_sizes);
        if (U.canEnableFreeform()) {
            this.savedWindowSizes.setOnCheckedChangeListener(this.listener);
        } else {
            this.savedWindowSizes.setVisibility(8);
        }
        this.desktopIcons = (CheckBox)this.findViewById(R.id.clear_desktop_icons);
        if (U.isDesktopIconsEnabled((Context)this)) {
            this.desktopIcons.setOnCheckedChangeListener(this.listener);
        } else {
            this.desktopIcons.setVisibility(8);
        }
        this.qsShortcuts = (CheckBox)this.findViewById(R.id.clear_qs_shortcuts);
        if (U.isFavoriteAppTilesEnabled((Context)this)) {
            this.qsShortcuts.setOnCheckedChangeListener(this.listener);
        } else {
            this.qsShortcuts.setVisibility(8);
        }
        this.button = (Button)this.findViewById(R.id.button);
        this.button.setText((CharSequence)this.getResources().getString(R.string.tb_action_close).toUpperCase());
        this.button.setOnClickListener(view -> {
            SharedPreferences pref;
            if (this.pba.isChecked()) {
                PinnedBlockedApps.getInstance((Context)this).clear((Context)this);
            }
            if (this.hiddenApps.isChecked()) {
                Blacklist.getInstance((Context)this).clear((Context)this);
            }
            if (this.topApps.isChecked()) {
                TopApps.getInstance((Context)this).clear((Context)this);
            }
            if (this.savedWindowSizes.isChecked()) {
                SavedWindowSizes.getInstance((Context)this).clear((Context)this);
            }
            if (this.desktopIcons.isChecked()) {
                pref = U.getSharedPreferences((Context)this);
                pref.edit().remove("desktop_icons").apply();
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.REFRESH_DESKTOP_ICONS");
            }
            if (this.qsShortcuts.isChecked()) {
                pref = U.getSharedPreferences((Context)this);
                pref.edit().remove("qs_tile_1_added").remove("qs_tile_2_added").remove("qs_tile_3_added").remove("qs_tile_4_added").remove("qs_tile_5_added").apply();
                ShortcutUtils.initFavoriteAppTiles((Context)this);
            }
            this.finish();
        });
    }
}

