/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.widget.TextView;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.AbstractProgressActivity;
import com.farmerbb.taskbar.backup.BackupUtils;
import com.farmerbb.taskbar.backup.JSONBackupAgent;
import com.farmerbb.taskbar.util.U;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.json.JSONObject;

public class BackupRestoreActivity
extends AbstractProgressActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int enter = this.getResources().getIdentifier("activity_close_enter", "anim", "android");
        int exit = this.getResources().getIdentifier("activity_close_exit", "anim", "android");
        this.overridePendingTransition(enter, exit);
        int requestCode = this.getIntent().getIntExtra("request_code", -1);
        Uri uri = (Uri)this.getIntent().getParcelableExtra("uri");
        boolean isExport = requestCode == 123;
        boolean isImport = requestCode == 456;
        TextView textView = (TextView)this.findViewById(R.id.progress_message);
        if (isExport) {
            textView.setText(R.string.tb_backing_up_settings);
        }
        if (isImport) {
            textView.setText(R.string.tb_restoring_settings);
        }
        if (savedInstanceState != null) {
            return;
        }
        new Thread(() -> {
            if (isExport) {
                this.exportData(uri);
            }
            if (isImport) {
                this.importData(uri);
            }
            this.finish();
            this.overridePendingTransition(enter, exit);
        }).start();
    }

    private void exportData(Uri uri) {
        try {
            ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(this.getContentResolver().openOutputStream(uri)));
            output.putNextEntry(new ZipEntry("backup.json"));
            JSONObject json = new JSONObject();
            BackupUtils.backup((Context)this, new JSONBackupAgent(json));
            output.write(json.toString().getBytes());
            output.closeEntry();
            File imagesDir = new File(this.getFilesDir(), "tb_images");
            imagesDir.mkdirs();
            for (String filename : U.getImageFilenames()) {
                File customImage = new File(imagesDir, filename);
                if (!customImage.exists()) continue;
                output.putNextEntry(new ZipEntry("tb_images/" + filename));
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(customImage));
                byte[] data = new byte[input.available()];
                if (data.length > 0) {
                    input.read(data);
                    input.close();
                }
                output.write(data);
                output.closeEntry();
            }
            output.close();
            this.setResult(R.string.tb_backup_successful);
        }
        catch (Throwable e) {
            this.setResult(R.string.tb_backup_failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData(Uri uri) {
        File importedFile = new File(this.getFilesDir(), "temp.zip");
        File statusFile = new File(this.getFilesDir(), "restore_in_progress");
        boolean pointOfNoReturn = false;
        try {
            ZipFile zipFile;
            ZipEntry backupJsonEntry;
            BufferedInputStream is = new BufferedInputStream(this.getContentResolver().openInputStream(uri));
            byte[] zipData = new byte[((InputStream)is).available()];
            if (zipData.length > 0) {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(importedFile));
                ((InputStream)is).read(zipData);
                ((OutputStream)os).write(zipData);
                ((InputStream)is).close();
                ((OutputStream)os).close();
            }
            if ((backupJsonEntry = (zipFile = new ZipFile(importedFile)).getEntry("backup.json")) == null) {
                throw new Exception();
            }
            byte[] data = new byte[(int)backupJsonEntry.getSize()];
            BufferedInputStream input = new BufferedInputStream(zipFile.getInputStream(backupJsonEntry));
            ((InputStream)input).read(data);
            ((InputStream)input).close();
            JSONObject json = new JSONObject(new String(data));
            pointOfNoReturn = true;
            statusFile.createNewFile();
            BackupUtils.restore((Context)this, new JSONBackupAgent(json));
            File imagesDir = new File(this.getFilesDir(), "tb_images");
            imagesDir.mkdirs();
            for (String filename : U.getImageFilenames()) {
                ZipEntry customImageEntry;
                File customImage = new File(imagesDir, filename);
                if (customImage.exists()) {
                    customImage.delete();
                }
                if ((customImageEntry = zipFile.getEntry("tb_images/" + filename)) == null) continue;
                data = new byte[(int)customImageEntry.getSize()];
                input = new BufferedInputStream(zipFile.getInputStream(customImageEntry));
                ((InputStream)input).read(data);
                ((InputStream)input).close();
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(customImage));
                if (data.length <= 0) continue;
                output.write(data);
                output.close();
            }
            statusFile.renameTo(new File(this.getFilesDir(), "restore_successful"));
        }
        catch (Throwable e) {
            if (!pointOfNoReturn) {
                this.setResult(R.string.tb_backup_file_invalid);
            }
        }
        finally {
            importedFile.delete();
            if (pointOfNoReturn) {
                U.restartApp(this, false);
            }
        }
    }
}

