/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.ComponentName;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.UserHandle;
import android.os.UserManager;
import android.view.WindowManager;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.adapter.DesktopIconAppListAdapter;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.U;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSelectAppActivity
extends AppCompatActivity {
    private DesktopIconAppListGenerator appListGenerator;
    private ProgressBar progressBar;
    private ListView appList;
    private boolean isCollapsed;

    protected void onCreate(Bundle savedInstanceState) {
        SharedPreferences pref;
        super.onCreate(savedInstanceState);
        boolean noShadow = this.getIntent().hasExtra("no_shadow");
        this.setContentView(R.layout.tb_desktop_icon_select_app);
        this.setFinishOnTouchOutside(false);
        this.setTitle(this.getString(R.string.tb_select_an_app));
        if (noShadow) {
            WindowManager.LayoutParams params = this.getWindow().getAttributes();
            params.dimAmount = 0.0f;
            this.getWindow().setAttributes(params);
            if (U.isChromeOs((Context)this) && Build.VERSION.SDK_INT >= 22) {
                this.getWindow().setElevation(0.0f);
            }
        }
        boolean bl = this.isCollapsed = !(pref = U.getSharedPreferences((Context)this)).getBoolean("collapsed", false);
        if (!this.isCollapsed) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_TASKBAR");
        }
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.appList = (ListView)this.findViewById(R.id.list);
        this.appListGenerator = new DesktopIconAppListGenerator();
        this.appListGenerator.execute(new Void[0]);
    }

    public void finish() {
        if (this.appListGenerator != null && this.appListGenerator.getStatus() == AsyncTask.Status.RUNNING) {
            this.appListGenerator.cancel(true);
        }
        if (!this.isCollapsed) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.SHOW_TASKBAR");
        }
        super.finish();
    }

    public abstract void selectApp(AppEntry var1);

    private final class DesktopIconAppListGenerator
    extends AsyncTask<Void, Void, DesktopIconAppListAdapter> {
        private DesktopIconAppListGenerator() {
        }

        protected DesktopIconAppListAdapter doInBackground(Void ... params) {
            UserManager userManager = (UserManager)AbstractSelectAppActivity.this.getSystemService("user");
            LauncherApps launcherApps = (LauncherApps)AbstractSelectAppActivity.this.getSystemService("launcherapps");
            List userHandles = userManager.getUserProfiles();
            ArrayList info = new ArrayList();
            for (UserHandle handle : userHandles) {
                info.addAll(launcherApps.getActivityList(null, handle));
            }
            Collections.sort(info, (ai1, ai2) -> {
                String label2;
                String label1;
                try {
                    label1 = ai1.getLabel().toString();
                    label2 = ai2.getLabel().toString();
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    label1 = ai1.getApplicationInfo().packageName;
                    label2 = ai2.getApplicationInfo().packageName;
                }
                return Collator.getInstance().compare(label1, label2);
            });
            ArrayList<AppEntry> entries = new ArrayList<AppEntry>();
            for (LauncherActivityInfo appInfo : info) {
                AppEntry entry = new AppEntry(appInfo.getApplicationInfo().packageName, new ComponentName(appInfo.getApplicationInfo().packageName, appInfo.getName()).flattenToString(), appInfo.getLabel().toString(), (Drawable)IconCache.getInstance((Context)AbstractSelectAppActivity.this).getIcon((Context)AbstractSelectAppActivity.this, appInfo), false);
                entry.setUserId(userManager.getSerialNumberForUser(appInfo.getUser()));
                entries.add(entry);
            }
            return new DesktopIconAppListAdapter((Context)AbstractSelectAppActivity.this, R.layout.tb_desktop_icon_row, entries);
        }

        protected void onPostExecute(DesktopIconAppListAdapter adapter) {
            AbstractSelectAppActivity.this.progressBar.setVisibility(8);
            AbstractSelectAppActivity.this.appList.setAdapter((ListAdapter)adapter);
            AbstractSelectAppActivity.this.setFinishOnTouchOutside(true);
        }
    }
}

