/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.cse.runner.starter;

import com.farao_community.farao.cse.runner.api.JsonApiConverter;
import com.farao_community.farao.cse.runner.api.exception.CseInternalException;
import com.farao_community.farao.cse.runner.starter.CseClientProperties;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;

public class CseMessageHandler {
    private static final String CONTENT_ENCODING = "UTF-8";
    private static final String CONTENT_TYPE = "application/vnd.api+json";
    private final CseClientProperties clientProperties;
    private final JsonApiConverter jsonConverter;

    public CseMessageHandler(CseClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.jsonConverter = new JsonApiConverter();
    }

    public <I> Message buildMessage(I request, Class<I> requestClass, int priority) {
        return MessageBuilder.withBody((byte[])this.jsonConverter.toJsonMessage(request, requestClass)).andProperties(this.buildMessageProperties(priority)).build();
    }

    private MessageProperties buildMessageProperties(int priority) {
        return (MessageProperties)MessagePropertiesBuilder.newInstance().setAppId(this.clientProperties.getBinding().getApplicationId()).setContentEncoding(CONTENT_ENCODING).setContentType(CONTENT_TYPE).setDeliveryMode(MessageDeliveryMode.NON_PERSISTENT).setExpiration(this.clientProperties.getBinding().getExpiration()).setPriority(Integer.valueOf(priority)).build();
    }

    public <J> J readMessage(Message message, Class<J> clazz) {
        if (message != null) {
            return (J)this.jsonConverter.fromJsonMessage(message.getBody(), clazz);
        }
        throw new CseInternalException("Cse server did not respond");
    }
}

