/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.cse.runner.starter;

import com.farao_community.farao.cse.runner.starter.CseClientProperties;
import com.farao_community.farao.cse.runner.starter.CseMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;

public class CseClient {
    private static final int DEFAULT_PRIORITY = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(CseClient.class);
    private final AmqpTemplate amqpTemplate;
    private final CseClientProperties cseClientProperties;
    private final CseMessageHandler cseMessageHandler;

    public CseClient(AmqpTemplate amqpTemplate, CseClientProperties cseClientProperties) {
        this.amqpTemplate = amqpTemplate;
        this.cseClientProperties = cseClientProperties;
        this.cseMessageHandler = new CseMessageHandler(cseClientProperties);
    }

    public <I, J> J run(I request, Class<I> requestClass, Class<J> responseClass, int priority) {
        LOGGER.info("Request sent: {}", request);
        Message responseMessage = this.amqpTemplate.sendAndReceive(this.cseClientProperties.getBinding().getDestination(), this.cseClientProperties.getBinding().getRoutingKey(), this.cseMessageHandler.buildMessage(request, requestClass, priority));
        J response = this.cseMessageHandler.readMessage(responseMessage, responseClass);
        LOGGER.info("Response received: {}", response);
        return response;
    }

    public <I, J> J run(I request, Class<I> requestClass, Class<J> responseClass) {
        return this.run(request, requestClass, responseClass, 1);
    }
}

