/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.testing.screenshot.layouthierarchy.litho;

import android.graphics.Point;
import android.view.View;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.LithoView;
import com.facebook.testing.screenshot.layouthierarchy.HierarchyPlugin;
import com.facebook.testing.screenshot.layouthierarchy.LayoutHierarchyDumper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LithoHierarchyPlugin
implements HierarchyPlugin {
    private static final LithoHierarchyPlugin INSTANCE = new LithoHierarchyPlugin();

    public static LithoHierarchyPlugin getInstance() {
        return INSTANCE;
    }

    private LithoHierarchyPlugin() {
    }

    public boolean accept(Object obj) {
        return obj instanceof LithoView || obj instanceof DebugComponent;
    }

    public void putHierarchy(LayoutHierarchyDumper dumper, JSONObject root, Object obj, Point offset) throws JSONException {
        if (!this.accept(obj)) {
            return;
        }
        if (obj instanceof LithoView) {
            LithoView lithoView = (LithoView)obj;
            DebugComponent debugComponent = DebugComponent.getRootInstance((LithoView)lithoView);
            if (debugComponent == null) {
                return;
            }
            int offsetLeft = LayoutHierarchyDumper.getViewLeft((View)lithoView);
            int offsetTop = LayoutHierarchyDumper.getViewTop((View)lithoView);
            offset.offset(offsetLeft, offsetTop);
            this.dumpHierarchy(dumper, root, debugComponent, offset);
            offset.offset(-offsetLeft, -offsetTop);
        } else {
            this.dumpHierarchy(dumper, root, (DebugComponent)obj, offset);
        }
    }

    private void dumpHierarchy(LayoutHierarchyDumper dumper, JSONObject root, DebugComponent component, Point offset) throws JSONException {
        JSONArray children = new JSONArray();
        for (DebugComponent child : component.getChildComponents()) {
            children.put((Object)dumper.dumpHierarchy((Object)child, offset));
        }
        root.put("children", (Object)children);
    }
}

