/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.testing.screenshot.layouthierarchy.litho;

import android.graphics.Point;
import android.graphics.Rect;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.LithoView;
import com.facebook.testing.screenshot.layouthierarchy.AbstractAttributePlugin;
import org.json.JSONException;
import org.json.JSONObject;

public class LithoAttributePlugin
extends AbstractAttributePlugin {
    private static final LithoAttributePlugin INSTANCE = new LithoAttributePlugin();

    public static LithoAttributePlugin getInstance() {
        return INSTANCE;
    }

    private LithoAttributePlugin() {
    }

    public boolean accept(Object obj) {
        return obj instanceof LithoView || obj instanceof DebugComponent;
    }

    public String namespace() {
        return "Litho";
    }

    public void putAttributes(JSONObject node, Object obj, Point offset) throws JSONException {
        if (obj instanceof LithoView) {
            ((LithoView)obj).rebind();
            DebugComponent debugComponent = DebugComponent.getRootInstance((LithoView)((LithoView)obj));
            if (debugComponent == null) {
                return;
            }
        } else {
            DebugComponent debugComponent = (DebugComponent)obj;
            Rect bounds = debugComponent.getBoundsInLithoView();
            this.putRequired(node, debugComponent.getComponent().getClass().getName(), offset.x + bounds.left, offset.y + bounds.top, bounds.width(), bounds.height());
        }
    }
}

