/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftStructMetadata<T> {
    private final String structName;
    private final Class<T> structClass;
    private final Class<?> builderClass;
    private final ThriftMethodInjection builderMethod;
    private final SortedMap<Short, ThriftFieldMetadata> fields;
    private final ThriftConstructorInjection constructor;
    private final List<ThriftMethodInjection> methodInjections;

    public ThriftStructMetadata(String structName, Class<T> structClass, Class<?> builderClass, ThriftMethodInjection builderMethod, List<ThriftFieldMetadata> fields, ThriftConstructorInjection constructor, List<ThriftMethodInjection> methodInjections) {
        this.builderClass = builderClass;
        this.builderMethod = builderMethod;
        this.structName = (String)Preconditions.checkNotNull((Object)structName, (Object)"structName is null");
        this.structClass = (Class)Preconditions.checkNotNull(structClass, (Object)"structClass is null");
        this.constructor = (ThriftConstructorInjection)Preconditions.checkNotNull((Object)constructor, (Object)"constructor is null");
        this.fields = ImmutableSortedMap.copyOf((Map)Maps.uniqueIndex((Iterable)((Iterable)Preconditions.checkNotNull(fields, (Object)"fields is null")), (Function)new Function<ThriftFieldMetadata, Short>(){

            public Short apply(ThriftFieldMetadata input) {
                return input.getId();
            }
        }));
        this.methodInjections = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(methodInjections, (Object)"methodInjections is null")));
    }

    public String getStructName() {
        return this.structName;
    }

    public Class<T> getStructClass() {
        return this.structClass;
    }

    public Class<?> getBuilderClass() {
        return this.builderClass;
    }

    public ThriftMethodInjection getBuilderMethod() {
        return this.builderMethod;
    }

    public ThriftFieldMetadata getField(int id) {
        return (ThriftFieldMetadata)this.fields.get((short)id);
    }

    public Collection<ThriftFieldMetadata> getFields() {
        return this.fields.values();
    }

    public ThriftConstructorInjection getConstructor() {
        return this.constructor;
    }

    public List<ThriftMethodInjection> getMethodInjections() {
        return this.methodInjections;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftStructMetadata");
        sb.append("{structName='").append(this.structName).append('\'');
        sb.append(", structClass=").append(this.structClass);
        sb.append(", builderClass=").append(this.builderClass);
        sb.append(", builderMethod=").append(this.builderMethod);
        sb.append(", fields=").append(this.fields);
        sb.append(", constructor=").append(this.constructor);
        sb.append(", methodInjections=").append(this.methodInjections);
        sb.append('}');
        return sb.toString();
    }
}

