/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftMethodInjection {
    private final Method method;
    private final List<ThriftParameterInjection> parameters;

    public ThriftMethodInjection(Method method, List<ThriftParameterInjection> parameters) {
        Preconditions.checkNotNull((Object)method, (Object)"method is null");
        Preconditions.checkNotNull(parameters, (Object)"parameters is null");
        this.method = method;
        this.parameters = parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ThriftParameterInjection> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.getName());
        sb.append('(');
        Joiner.on((String)", ").appendTo(sb, this.parameters);
        sb.append(')');
        return sb.toString();
    }
}

