/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftFieldMetadata {
    private final short id;
    private final ThriftType type;
    private final String name;
    private final List<ThriftInjection> injections;
    private final ThriftExtraction extraction;
    private final TypeCoercion coercion;

    public ThriftFieldMetadata(short id, ThriftType type, String name, List<ThriftInjection> injections, ThriftExtraction extraction, TypeCoercion coercion) {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(injections, (Object)"injections is null");
        Preconditions.checkArgument((!injections.isEmpty() || extraction != null ? 1 : 0) != 0, (Object)"A thrift field must have an injection or extraction point");
        this.id = id;
        this.type = type;
        this.name = name;
        this.injections = ImmutableList.copyOf(injections);
        this.extraction = extraction;
        this.coercion = coercion;
    }

    public short getId() {
        return this.id;
    }

    public ThriftType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.extraction != null;
    }

    public boolean isWritable() {
        return !this.injections.isEmpty();
    }

    public boolean isReadOnly() {
        return this.injections.isEmpty();
    }

    public boolean isWriteOnly() {
        return this.extraction == null;
    }

    public List<ThriftInjection> getInjections() {
        return this.injections;
    }

    public ThriftExtraction getExtraction() {
        return this.extraction;
    }

    public TypeCoercion getCoercion() {
        return this.coercion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftFieldMetadata");
        sb.append("{id=").append(this.id);
        sb.append(", type=").append(this.type);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", injections=").append(this.injections);
        sb.append(", extraction=").append(this.extraction);
        sb.append(", coercion=").append(this.coercion);
        sb.append('}');
        return sb.toString();
    }
}

