/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftIdlAnnotation;
import com.facebook.swift.codec.metadata.FieldKind;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nullable;

abstract class FieldMetadata {
    private Short id;
    private Boolean isLegacyId;
    private Boolean isRecursiveReference;
    private String name;
    private ThriftField.Requiredness requiredness;
    private Map<String, String> idlAnnotations;
    private final FieldKind type;

    protected FieldMetadata(ThriftField annotation, FieldKind type) {
        this.type = type;
        block0 : switch (type) {
            case THRIFT_FIELD: {
                if (annotation == null) break;
                if (annotation.value() != Short.MIN_VALUE) {
                    this.id = annotation.value();
                }
                this.isLegacyId = annotation.isLegacyId();
                if (!annotation.name().isEmpty()) {
                    this.name = annotation.name();
                }
                this.requiredness = (ThriftField.Requiredness)Preconditions.checkNotNull((Object)annotation.requiredness());
                ImmutableMap.Builder annotationMapBuilder = ImmutableMap.builder();
                for (ThriftIdlAnnotation idlAnnotation : annotation.idlAnnotations()) {
                    annotationMapBuilder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
                }
                this.idlAnnotations = annotationMapBuilder.build();
                if (annotation.isRecursive() != ThriftField.Recursiveness.UNSPECIFIED) {
                    switch (annotation.isRecursive()) {
                        case TRUE: {
                            this.isRecursiveReference = true;
                            break block0;
                        }
                        case FALSE: {
                            this.isRecursiveReference = false;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected get for isRecursive field");
                }
                if (!this.idlAnnotations.containsKey("swift.recursive_reference")) break;
                this.isRecursiveReference = "true".equalsIgnoreCase(this.idlAnnotations.getOrDefault("swift.recursive_reference", "false"));
                break;
            }
            case THRIFT_UNION_ID: {
                assert (annotation == null) : "ThriftStruct annotation shouldn't be present for THRIFT_UNION_ID";
                this.id = Short.MIN_VALUE;
                this.isLegacyId = true;
                this.name = "_union_id";
                break;
            }
            default: {
                throw new IllegalArgumentException("Encountered field metadata type " + (Object)((Object)type));
            }
        }
    }

    public Short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    @Nullable
    public Boolean isLegacyId() {
        return this.isLegacyId;
    }

    public void setIsLegacyId(Boolean isLegacyId) {
        this.isLegacyId = isLegacyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getIdlAnnotations() {
        return this.idlAnnotations;
    }

    public void setIdlAnnotations(Map<String, String> idlAnnotations) {
        this.idlAnnotations = idlAnnotations;
    }

    public FieldKind getType() {
        return this.type;
    }

    public abstract Type getJavaType();

    public abstract String extractName();

    static <T extends FieldMetadata> Function<T, Optional<Short>> getThriftFieldId() {
        return new Function<T, Optional<Short>>(){

            public Optional<Short> apply(@Nullable T input) {
                if (input == null) {
                    return Optional.absent();
                }
                Short value = ((FieldMetadata)input).getId();
                return Optional.fromNullable((Object)value);
            }
        };
    }

    static <T extends FieldMetadata> Function<T, Optional<Boolean>> getThriftFieldIsLegacyId() {
        return new Function<T, Optional<Boolean>>(){

            public Optional<Boolean> apply(@Nullable T input) {
                if (input == null) {
                    return Optional.absent();
                }
                Boolean value = ((FieldMetadata)input).isLegacyId();
                if (!(((FieldMetadata)input).getId() != null && ((FieldMetadata)input).getId() != Short.MIN_VALUE || value == null || value.booleanValue())) {
                    return Optional.absent();
                }
                return Optional.fromNullable((Object)value);
            }
        };
    }

    static <T extends FieldMetadata> Function<T, String> getThriftFieldName() {
        return new Function<T, String>(){

            public String apply(@Nullable T input) {
                if (input == null) {
                    return null;
                }
                return ((FieldMetadata)input).getName();
            }
        };
    }

    static <T extends FieldMetadata> Function<T, String> getOrExtractThriftFieldName() {
        return new Function<T, String>(){

            public String apply(@Nullable T input) {
                if (input == null) {
                    return null;
                }
                String name = ((FieldMetadata)input).getName();
                if (name == null) {
                    name = ((FieldMetadata)input).extractName();
                }
                if (name == null) {
                    throw new NullPointerException(String.valueOf("name is null"));
                }
                return name;
            }
        };
    }

    static <T extends FieldMetadata> Function<T, String> extractThriftFieldName() {
        return new Function<T, String>(){

            public String apply(@Nullable T input) {
                if (input == null) {
                    return null;
                }
                return ((FieldMetadata)input).extractName();
            }
        };
    }

    static <T extends FieldMetadata> Function<T, ThriftField.Requiredness> getThriftFieldRequiredness() {
        return new Function<T, ThriftField.Requiredness>(){

            @Nullable
            public ThriftField.Requiredness apply(@Nullable T input) {
                return ((FieldMetadata)input).getRequiredness();
            }
        };
    }

    public ThriftField.Requiredness getRequiredness() {
        return this.requiredness;
    }

    public void setRequiredness(ThriftField.Requiredness requiredness) {
        this.requiredness = requiredness;
    }

    @Nullable
    public Boolean isRecursiveReference() {
        return this.isRecursiveReference;
    }

    public void setIsRecursiveReference(Boolean isRecursiveReference) {
        this.isRecursiveReference = isRecursiveReference;
    }
}

