/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.textinput.ReactTextInputLocalData;
import com.facebook.react.views.view.MeasureUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;

@VisibleForTesting
@TargetApi(value=23)
public class ReactTextInputShadowNode
extends ReactBaseTextShadowNode
implements YogaMeasureFunction {
    private int mMostRecentEventCount = -1;
    @Nullable
    private EditText mInternalEditText;
    @Nullable
    private ReactTextInputLocalData mLocalData;
    @VisibleForTesting
    public static final String PROP_TEXT = "text";
    @VisibleForTesting
    public static final String PROP_PLACEHOLDER = "placeholder";
    @VisibleForTesting
    public static final String PROP_SELECTION = "selection";
    @Nullable
    private String mText = null;
    @Nullable
    private String mPlaceholder = null;
    private int mSelectionStart = -1;
    private int mSelectionEnd = -1;

    public ReactTextInputShadowNode(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        super(reactTextViewManagerCallback);
        this.mTextBreakStrategy = Build.VERSION.SDK_INT < 23 ? 0 : 1;
        this.initMeasureFunction();
    }

    public ReactTextInputShadowNode() {
        this(null);
    }

    private void initMeasureFunction() {
        this.setMeasureFunction(this);
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        EditText editText = this.createInternalEditText();
        this.setDefaultPadding(4, ViewCompat.getPaddingStart((View)editText));
        this.setDefaultPadding(1, editText.getPaddingTop());
        this.setDefaultPadding(5, ViewCompat.getPaddingEnd((View)editText));
        this.setDefaultPadding(3, editText.getPaddingBottom());
        this.mInternalEditText = editText;
        this.mInternalEditText.setPadding(0, 0, 0, 0);
        this.mInternalEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
    }

    @Override
    public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mInternalEditText);
        if (this.mLocalData != null) {
            this.mLocalData.apply(editText);
        } else {
            editText.setTextSize(0, (float)this.mTextAttributes.getEffectiveFontSize());
            if (this.mNumberOfLines != -1) {
                editText.setLines(this.mNumberOfLines);
            }
            if (Build.VERSION.SDK_INT >= 23 && editText.getBreakStrategy() != this.mTextBreakStrategy) {
                editText.setBreakStrategy(this.mTextBreakStrategy);
            }
        }
        editText.setHint((CharSequence)this.getPlaceholder());
        editText.measure(MeasureUtil.getMeasureSpec(width, widthMode), MeasureUtil.getMeasureSpec(height, heightMode));
        return YogaMeasureOutput.make(editText.getMeasuredWidth(), editText.getMeasuredHeight());
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public boolean isYogaLeafNode() {
        return true;
    }

    @Override
    public void setLocalData(Object data) {
        Assertions.assertCondition((boolean)(data instanceof ReactTextInputLocalData));
        this.mLocalData = (ReactTextInputLocalData)data;
        this.dirty();
    }

    @ReactProp(name="mostRecentEventCount")
    public void setMostRecentEventCount(int mostRecentEventCount) {
        this.mMostRecentEventCount = mostRecentEventCount;
    }

    @ReactProp(name="text")
    public void setText(@Nullable String text) {
        this.mText = text;
        if (text != null) {
            if (this.mSelectionStart > text.length()) {
                this.mSelectionStart = text.length();
            }
            if (this.mSelectionEnd > text.length()) {
                this.mSelectionEnd = text.length();
            }
        } else {
            this.mSelectionStart = -1;
            this.mSelectionEnd = -1;
        }
        this.markUpdated();
    }

    @Nullable
    public String getText() {
        return this.mText;
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(@Nullable String placeholder) {
        this.mPlaceholder = placeholder;
        this.markUpdated();
    }

    @Nullable
    public String getPlaceholder() {
        return this.mPlaceholder;
    }

    @ReactProp(name="selection")
    public void setSelection(@Nullable ReadableMap selection) {
        this.mSelectionEnd = -1;
        this.mSelectionStart = -1;
        if (selection == null) {
            return;
        }
        if (selection.hasKey("start") && selection.hasKey("end")) {
            this.mSelectionStart = selection.getInt("start");
            this.mSelectionEnd = selection.getInt("end");
            this.markUpdated();
        }
    }

    @Override
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (textBreakStrategy == null || "simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textBreakStrategy: " + textBreakStrategy);
        }
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mMostRecentEventCount != -1) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(this.spannedFromShadowNode(this, this.getText(), false, null), this.mMostRecentEventCount, this.mContainsImages, this.getPadding(0), this.getPadding(1), this.getPadding(2), this.getPadding(3), this.mTextAlign, this.mTextBreakStrategy, this.mJustificationMode, this.mSelectionStart, this.mSelectionEnd);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.markUpdated();
    }

    protected EditText createInternalEditText() {
        return new EditText((Context)this.getThemedContext());
    }
}

