/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityNodeProviderCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.facebook.react.R;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.util.ReactFindViewUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReactAccessibilityDelegate
extends ExploreByTouchHelper {
    private static final String TAG = "ReactAccessibilityDelegate";
    public static final String TOP_ACCESSIBILITY_ACTION_EVENT = "topAccessibilityAction";
    private static int sCounter = 0x3F000000;
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private static final int SEND_EVENT = 1;
    public static final HashMap<String, Integer> sActionIdMap = new HashMap();
    private final View mView;
    private final AccessibilityLinks mAccessibilityLinks;
    private Handler mHandler;
    private final HashMap<Integer, String> mAccessibilityActionsMap;
    private static final String STATE_DISABLED = "disabled";
    private static final String STATE_SELECTED = "selected";
    private static final String STATE_CHECKED = "checked";
    @Nullable
    View mAccessibilityLabelledBy;

    private void scheduleAccessibilityEventSender(View host) {
        if (this.mHandler.hasMessages(1, (Object)host)) {
            this.mHandler.removeMessages(1, (Object)host);
        }
        Message msg = this.mHandler.obtainMessage(1, (Object)host);
        this.mHandler.sendMessageDelayed(msg, 200L);
    }

    public ReactAccessibilityDelegate(View view, boolean originalFocus, int originalImportantForAccessibility) {
        super(view);
        this.mView = view;
        this.mAccessibilityActionsMap = new HashMap();
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                View host = (View)msg.obj;
                host.sendAccessibilityEvent(4);
            }
        };
        this.mView.setFocusable(originalFocus);
        ViewCompat.setImportantForAccessibility((View)this.mView, (int)originalImportantForAccessibility);
        this.mAccessibilityLinks = (AccessibilityLinks)this.mView.getTag(R.id.accessibility_links);
    }

    public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
        String testId;
        ReadableMap accessibilityValue;
        ReadableMap accessibilityState;
        Object accessibilityLabelledBy;
        super.onInitializeAccessibilityNodeInfo(host, info);
        AccessibilityRole accessibilityRole = (AccessibilityRole)((Object)host.getTag(R.id.accessibility_role));
        String accessibilityHint = (String)host.getTag(R.id.accessibility_hint);
        if (accessibilityRole != null) {
            ReactAccessibilityDelegate.setRole(info, accessibilityRole, host.getContext());
        }
        if (accessibilityHint != null) {
            info.setTooltipText((CharSequence)accessibilityHint);
        }
        if ((accessibilityLabelledBy = host.getTag(R.id.labelled_by)) != null) {
            this.mAccessibilityLabelledBy = ReactFindViewUtil.findView(host.getRootView(), (String)accessibilityLabelledBy);
            if (this.mAccessibilityLabelledBy != null) {
                info.setLabeledBy(this.mAccessibilityLabelledBy);
            }
        }
        if ((accessibilityState = (ReadableMap)host.getTag(R.id.accessibility_state)) != null) {
            ReactAccessibilityDelegate.setState(info, accessibilityState, host.getContext());
        }
        ReadableArray accessibilityActions = (ReadableArray)host.getTag(R.id.accessibility_actions);
        ReadableMap accessibilityCollectionItem = (ReadableMap)host.getTag(R.id.accessibility_collection_item);
        if (accessibilityCollectionItem != null) {
            int rowIndex = accessibilityCollectionItem.getInt("rowIndex");
            int columnIndex = accessibilityCollectionItem.getInt("columnIndex");
            int rowSpan = accessibilityCollectionItem.getInt("rowSpan");
            int columnSpan = accessibilityCollectionItem.getInt("columnSpan");
            boolean heading = accessibilityCollectionItem.getBoolean("heading");
            AccessibilityNodeInfoCompat.CollectionItemInfoCompat collectionItemCompat = AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)rowIndex, (int)rowSpan, (int)columnIndex, (int)columnSpan, (boolean)heading);
            info.setCollectionItemInfo((Object)collectionItemCompat);
        }
        if (accessibilityActions != null) {
            for (int i = 0; i < accessibilityActions.size(); ++i) {
                String actionLabel;
                ReadableMap action = accessibilityActions.getMap(i);
                if (!action.hasKey("name")) {
                    throw new IllegalArgumentException("Unknown accessibility action.");
                }
                int actionId = sCounter;
                String string2 = actionLabel = action.hasKey("label") ? action.getString("label") : null;
                if (sActionIdMap.containsKey(action.getString("name"))) {
                    actionId = sActionIdMap.get(action.getString("name"));
                } else {
                    ++sCounter;
                }
                this.mAccessibilityActionsMap.put(actionId, action.getString("name"));
                AccessibilityNodeInfoCompat.AccessibilityActionCompat accessibilityAction = new AccessibilityNodeInfoCompat.AccessibilityActionCompat(actionId, (CharSequence)actionLabel);
                info.addAction(accessibilityAction);
            }
        }
        if ((accessibilityValue = (ReadableMap)host.getTag(R.id.accessibility_value)) != null && accessibilityValue.hasKey("min") && accessibilityValue.hasKey("now") && accessibilityValue.hasKey("max")) {
            Dynamic minDynamic = accessibilityValue.getDynamic("min");
            Dynamic nowDynamic = accessibilityValue.getDynamic("now");
            Dynamic maxDynamic = accessibilityValue.getDynamic("max");
            if (minDynamic != null && minDynamic.getType() == ReadableType.Number && nowDynamic != null && nowDynamic.getType() == ReadableType.Number && maxDynamic != null && maxDynamic.getType() == ReadableType.Number) {
                int min = minDynamic.asInt();
                int now = nowDynamic.asInt();
                int max = maxDynamic.asInt();
                if (max > min && now >= min && max >= now) {
                    info.setRangeInfo(AccessibilityNodeInfoCompat.RangeInfoCompat.obtain((int)0, (float)min, (float)max, (float)now));
                }
            }
        }
        if ((testId = (String)host.getTag(R.id.react_test_id)) != null) {
            info.setViewIdResourceName(testId);
        }
    }

    public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(host, event);
        ReadableMap accessibilityValue = (ReadableMap)host.getTag(R.id.accessibility_value);
        if (accessibilityValue != null && accessibilityValue.hasKey("min") && accessibilityValue.hasKey("now") && accessibilityValue.hasKey("max")) {
            Dynamic minDynamic = accessibilityValue.getDynamic("min");
            Dynamic nowDynamic = accessibilityValue.getDynamic("now");
            Dynamic maxDynamic = accessibilityValue.getDynamic("max");
            if (minDynamic != null && minDynamic.getType() == ReadableType.Number && nowDynamic != null && nowDynamic.getType() == ReadableType.Number && maxDynamic != null && maxDynamic.getType() == ReadableType.Number) {
                int min = minDynamic.asInt();
                int now = nowDynamic.asInt();
                int max = maxDynamic.asInt();
                if (max > min && now >= min && max >= now) {
                    event.setItemCount(max - min);
                    event.setCurrentItemIndex(now);
                }
            }
        }
    }

    public boolean performAccessibilityAction(View host, int action, Bundle args) {
        if (this.mAccessibilityActionsMap.containsKey(action)) {
            final WritableMap event = Arguments.createMap();
            event.putString("actionName", this.mAccessibilityActionsMap.get(action));
            ReactContext reactContext = (ReactContext)host.getContext();
            if (reactContext.hasActiveReactInstance()) {
                int reactTag = host.getId();
                int surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
                UIManager uiManager = UIManagerHelper.getUIManager(reactContext, reactTag);
                if (uiManager != null) {
                    ((EventDispatcher)uiManager.getEventDispatcher()).dispatchEvent(new Event(surfaceId, reactTag){

                        @Override
                        public String getEventName() {
                            return ReactAccessibilityDelegate.TOP_ACCESSIBILITY_ACTION_EVENT;
                        }

                        @Override
                        protected WritableMap getEventData() {
                            return event;
                        }
                    });
                }
            } else {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get RCTEventEmitter, no CatalystInstance"));
            }
            AccessibilityRole accessibilityRole = (AccessibilityRole)((Object)host.getTag(R.id.accessibility_role));
            ReadableMap accessibilityValue = (ReadableMap)host.getTag(R.id.accessibility_value);
            if (accessibilityRole == AccessibilityRole.ADJUSTABLE && (action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId() || action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId())) {
                if (accessibilityValue != null && !accessibilityValue.hasKey("text")) {
                    this.scheduleAccessibilityEventSender(host);
                }
                return super.performAccessibilityAction(host, action, args);
            }
            return true;
        }
        return super.performAccessibilityAction(host, action, args);
    }

    private static void setState(AccessibilityNodeInfoCompat info, ReadableMap accessibilityState, Context context) {
        ReadableMapKeySetIterator i = accessibilityState.keySetIterator();
        while (i.hasNextKey()) {
            String state = i.nextKey();
            Dynamic value = accessibilityState.getDynamic(state);
            if (state.equals(STATE_SELECTED) && value.getType() == ReadableType.Boolean) {
                info.setSelected(value.asBoolean());
                continue;
            }
            if (state.equals(STATE_DISABLED) && value.getType() == ReadableType.Boolean) {
                info.setEnabled(!value.asBoolean());
                continue;
            }
            if (!state.equals(STATE_CHECKED) || value.getType() != ReadableType.Boolean) continue;
            boolean boolValue = value.asBoolean();
            info.setCheckable(true);
            info.setChecked(boolValue);
            if (!info.getClassName().equals(AccessibilityRole.getValue(AccessibilityRole.SWITCH))) continue;
            info.setText((CharSequence)context.getString(boolValue ? R.string.state_on_description : R.string.state_off_description));
        }
    }

    public static void setRole(AccessibilityNodeInfoCompat nodeInfo, AccessibilityRole role, Context context) {
        if (role == null) {
            role = AccessibilityRole.NONE;
        }
        nodeInfo.setClassName((CharSequence)AccessibilityRole.getValue(role));
        if (role.equals((Object)AccessibilityRole.LINK)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.link_description));
        } else if (role.equals((Object)AccessibilityRole.IMAGE)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.image_description));
        } else if (role.equals((Object)AccessibilityRole.IMAGEBUTTON)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.imagebutton_description));
            nodeInfo.setClickable(true);
        } else if (role.equals((Object)AccessibilityRole.BUTTON)) {
            nodeInfo.setClickable(true);
        } else if (role.equals((Object)AccessibilityRole.TOGGLEBUTTON)) {
            nodeInfo.setClickable(true);
            nodeInfo.setCheckable(true);
        } else if (role.equals((Object)AccessibilityRole.SUMMARY)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.summary_description));
        } else if (role.equals((Object)AccessibilityRole.HEADER)) {
            nodeInfo.setHeading(true);
        } else if (role.equals((Object)AccessibilityRole.ALERT)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.alert_description));
        } else if (role.equals((Object)AccessibilityRole.COMBOBOX)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.combobox_description));
        } else if (role.equals((Object)AccessibilityRole.MENU)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.menu_description));
        } else if (role.equals((Object)AccessibilityRole.MENUBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.menubar_description));
        } else if (role.equals((Object)AccessibilityRole.MENUITEM)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.menuitem_description));
        } else if (role.equals((Object)AccessibilityRole.PROGRESSBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.progressbar_description));
        } else if (role.equals((Object)AccessibilityRole.RADIOGROUP)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.radiogroup_description));
        } else if (role.equals((Object)AccessibilityRole.SCROLLBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.scrollbar_description));
        } else if (role.equals((Object)AccessibilityRole.SPINBUTTON)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.spinbutton_description));
        } else if (role.equals((Object)AccessibilityRole.TAB)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.rn_tab_description));
        } else if (role.equals((Object)AccessibilityRole.TABLIST)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.tablist_description));
        } else if (role.equals((Object)AccessibilityRole.TIMER)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.timer_description));
        } else if (role.equals((Object)AccessibilityRole.TOOLBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.toolbar_description));
        }
    }

    public static void setDelegate(View view, boolean originalFocus, int originalImportantForAccessibility) {
        if (!(ViewCompat.hasAccessibilityDelegate((View)view) || view.getTag(R.id.accessibility_role) == null && view.getTag(R.id.accessibility_state) == null && view.getTag(R.id.accessibility_actions) == null && view.getTag(R.id.react_test_id) == null && view.getTag(R.id.accessibility_collection_item) == null && view.getTag(R.id.accessibility_links) == null)) {
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new ReactAccessibilityDelegate(view, originalFocus, originalImportantForAccessibility));
        }
    }

    public static void resetDelegate(View view, boolean originalFocus, int originalImportantForAccessibility) {
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new ReactAccessibilityDelegate(view, originalFocus, originalImportantForAccessibility));
    }

    protected int getVirtualViewAt(float x, float y) {
        int end;
        if (this.mAccessibilityLinks == null || this.mAccessibilityLinks.size() == 0 || !(this.mView instanceof TextView)) {
            return Integer.MIN_VALUE;
        }
        TextView textView = (TextView)this.mView;
        if (!(textView.getText() instanceof Spanned)) {
            return Integer.MIN_VALUE;
        }
        Layout layout2 = textView.getLayout();
        if (layout2 == null) {
            return Integer.MIN_VALUE;
        }
        x -= (float)textView.getTotalPaddingLeft();
        y -= (float)textView.getTotalPaddingTop();
        int line = layout2.getLineForVertical((int)(y += (float)textView.getScrollY()));
        int charOffset = layout2.getOffsetForHorizontal(line, x += (float)textView.getScrollX());
        ClickableSpan clickableSpan = this.getFirstSpan(charOffset, charOffset, ClickableSpan.class);
        if (clickableSpan == null) {
            return Integer.MIN_VALUE;
        }
        Spanned spanned = (Spanned)textView.getText();
        int start = spanned.getSpanStart((Object)clickableSpan);
        AccessibilityLinks.AccessibleLink link = this.mAccessibilityLinks.getLinkBySpanPos(start, end = spanned.getSpanEnd((Object)clickableSpan));
        return link != null ? link.id : Integer.MIN_VALUE;
    }

    protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
        if (this.mAccessibilityLinks == null) {
            return;
        }
        for (int i = 0; i < this.mAccessibilityLinks.size(); ++i) {
            virtualViewIds.add(i);
        }
    }

    protected void onPopulateNodeForVirtualView(int virtualViewId, @NonNull AccessibilityNodeInfoCompat node) {
        if (this.mAccessibilityLinks == null) {
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(new Rect(0, 0, 1, 1));
            return;
        }
        AccessibilityLinks.AccessibleLink accessibleTextSpan = this.mAccessibilityLinks.getLinkById(virtualViewId);
        if (accessibleTextSpan == null) {
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(new Rect(0, 0, 1, 1));
            return;
        }
        node.setContentDescription((CharSequence)accessibleTextSpan.description);
        node.addAction(16);
        node.setBoundsInParent(this.getBoundsInParent(accessibleTextSpan));
        node.setRoleDescription((CharSequence)this.mView.getResources().getString(R.string.link_description));
        node.setClassName((CharSequence)AccessibilityRole.getValue(AccessibilityRole.BUTTON));
    }

    private Rect getBoundsInParent(AccessibilityLinks.AccessibleLink accessibleLink) {
        if (!(this.mView instanceof TextView)) {
            return new Rect(0, 0, this.mView.getWidth(), this.mView.getHeight());
        }
        TextView textView = (TextView)this.mView;
        Layout textViewLayout = textView.getLayout();
        if (textViewLayout == null) {
            return new Rect(0, 0, textView.getWidth(), textView.getHeight());
        }
        Rect rootRect = new Rect();
        double startOffset = accessibleLink.start;
        double endOffset = accessibleLink.end;
        double startXCoordinates = textViewLayout.getPrimaryHorizontal((int)startOffset);
        Paint paint = new Paint();
        AbsoluteSizeSpan sizeSpan = this.getFirstSpan(accessibleLink.start, accessibleLink.end, AbsoluteSizeSpan.class);
        float textSize = sizeSpan != null ? (float)sizeSpan.getSize() : textView.getTextSize();
        paint.setTextSize(textSize);
        int textWidth = (int)Math.ceil(paint.measureText(accessibleLink.description));
        int startOffsetLineNumber = textViewLayout.getLineForOffset((int)startOffset);
        int endOffsetLineNumber = textViewLayout.getLineForOffset((int)endOffset);
        boolean isMultiline = startOffsetLineNumber != endOffsetLineNumber;
        textViewLayout.getLineBounds(startOffsetLineNumber, rootRect);
        int verticalOffset = textView.getScrollY() + textView.getTotalPaddingTop();
        rootRect.top += verticalOffset;
        rootRect.bottom += verticalOffset;
        rootRect.left = (int)((double)rootRect.left + (startXCoordinates + (double)textView.getTotalPaddingLeft() - (double)textView.getScrollX()));
        if (isMultiline) {
            return new Rect(rootRect.left, rootRect.top, rootRect.right, rootRect.bottom);
        }
        return new Rect(rootRect.left, rootRect.top, rootRect.left + textWidth, rootRect.bottom);
    }

    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, @Nullable Bundle arguments) {
        return false;
    }

    @Nullable
    protected <T> T getFirstSpan(int start, int end, Class<T> classType) {
        if (!(this.mView instanceof TextView) || !(((TextView)this.mView).getText() instanceof Spanned)) {
            return null;
        }
        Spanned spanned = (Spanned)((TextView)this.mView).getText();
        Object[] spans = spanned.getSpans(start, end, classType);
        return (T)(spans.length > 0 ? spans[0] : null);
    }

    @Nullable
    public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View host) {
        if (this.mAccessibilityLinks != null) {
            return super.getAccessibilityNodeProvider(host);
        }
        return null;
    }

    static {
        sActionIdMap.put("activate", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK.getId());
        sActionIdMap.put("longpress", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_LONG_CLICK.getId());
        sActionIdMap.put("increment", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId());
        sActionIdMap.put("decrement", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId());
    }

    public static class AccessibilityLinks {
        private final List<AccessibleLink> mLinks;

        public AccessibilityLinks(ClickableSpan[] spans, Spannable text) {
            ArrayList<AccessibleLink> links = new ArrayList<AccessibleLink>();
            for (int i = 0; i < spans.length; ++i) {
                int end;
                ClickableSpan span = spans[i];
                int start = text.getSpanStart((Object)span);
                if (start == (end = text.getSpanEnd((Object)span)) || start < 0 || end < 0 || start > text.length() || end > text.length()) continue;
                AccessibleLink link = new AccessibleLink();
                link.description = text.subSequence(start, end).toString();
                link.start = start;
                link.end = end;
                link.id = spans.length - 1 - i;
                links.add(link);
            }
            this.mLinks = links;
        }

        @Nullable
        public AccessibleLink getLinkById(int id2) {
            for (AccessibleLink link : this.mLinks) {
                if (link.id != id2) continue;
                return link;
            }
            return null;
        }

        @Nullable
        public AccessibleLink getLinkBySpanPos(int start, int end) {
            for (AccessibleLink link : this.mLinks) {
                if (link.start != start || link.end != end) continue;
                return link;
            }
            return null;
        }

        public int size() {
            return this.mLinks.size();
        }

        private static class AccessibleLink {
            public String description;
            public int start;
            public int end;
            public int id;

            private AccessibleLink() {
            }
        }
    }

    public static enum AccessibilityRole {
        NONE,
        BUTTON,
        TOGGLEBUTTON,
        LINK,
        SEARCH,
        IMAGE,
        IMAGEBUTTON,
        KEYBOARDKEY,
        TEXT,
        ADJUSTABLE,
        SUMMARY,
        HEADER,
        ALERT,
        CHECKBOX,
        COMBOBOX,
        MENU,
        MENUBAR,
        MENUITEM,
        PROGRESSBAR,
        RADIO,
        RADIOGROUP,
        SCROLLBAR,
        SPINBUTTON,
        SWITCH,
        TAB,
        TABLIST,
        TIMER,
        LIST,
        GRID,
        TOOLBAR;


        public static String getValue(AccessibilityRole role) {
            switch (role) {
                case BUTTON: {
                    return "android.widget.Button";
                }
                case TOGGLEBUTTON: {
                    return "android.widget.ToggleButton";
                }
                case SEARCH: {
                    return "android.widget.EditText";
                }
                case IMAGE: {
                    return "android.widget.ImageView";
                }
                case IMAGEBUTTON: {
                    return "android.widget.ImageButon";
                }
                case KEYBOARDKEY: {
                    return "android.inputmethodservice.Keyboard$Key";
                }
                case TEXT: {
                    return "android.widget.TextView";
                }
                case ADJUSTABLE: {
                    return "android.widget.SeekBar";
                }
                case CHECKBOX: {
                    return "android.widget.CheckBox";
                }
                case RADIO: {
                    return "android.widget.RadioButton";
                }
                case SPINBUTTON: {
                    return "android.widget.SpinButton";
                }
                case SWITCH: {
                    return "android.widget.Switch";
                }
                case LIST: {
                    return "android.widget.AbsListView";
                }
                case GRID: {
                    return "android.widget.GridView";
                }
                case NONE: 
                case LINK: 
                case SUMMARY: 
                case HEADER: 
                case ALERT: 
                case COMBOBOX: 
                case MENU: 
                case MENUBAR: 
                case MENUITEM: 
                case PROGRESSBAR: 
                case RADIOGROUP: 
                case SCROLLBAR: 
                case TAB: 
                case TABLIST: 
                case TIMER: 
                case TOOLBAR: {
                    return "android.view.View";
                }
            }
            throw new IllegalArgumentException("Invalid accessibility role value: " + (Object)((Object)role));
        }

        public static AccessibilityRole fromValue(@Nullable String value) {
            for (AccessibilityRole role : AccessibilityRole.values()) {
                if (!role.name().equalsIgnoreCase(value)) continue;
                return role;
            }
            throw new IllegalArgumentException("Invalid accessibility role value: " + value);
        }
    }
}

