/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.i18nmanager;

import android.content.Context;
import android.os.Build;
import com.facebook.fbreact.specs.NativeI18nManagerSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@ReactModule(name="I18nManager")
public class I18nManagerModule
extends NativeI18nManagerSpec {
    public static final String NAME = "I18nManager";
    private final I18nUtil sharedI18nUtilInstance = I18nUtil.getInstance();

    public I18nManagerModule(ReactApplicationContext context) {
        super(context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getTypedExportedConstants() {
        ReactApplicationContext context = this.getReactApplicationContext();
        Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        HashMap<String, Object> constants = MapBuilder.newHashMap();
        constants.put("isRTL", this.sharedI18nUtilInstance.isRTL((Context)context));
        constants.put("doLeftAndRightSwapInRTL", this.sharedI18nUtilInstance.doLeftAndRightSwapInRTL((Context)context));
        constants.put("localeIdentifier", locale.toString());
        return constants;
    }

    @Override
    public void allowRTL(boolean value) {
        this.sharedI18nUtilInstance.allowRTL((Context)this.getReactApplicationContext(), value);
    }

    @Override
    public void forceRTL(boolean value) {
        this.sharedI18nUtilInstance.forceRTL((Context)this.getReactApplicationContext(), value);
    }

    @Override
    public void swapLeftAndRightInRTL(boolean value) {
        this.sharedI18nUtilInstance.swapLeftAndRightInRTL((Context)this.getReactApplicationContext(), value);
    }
}

