/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.fabric.GuardedFrameCallback;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.events.EventCategoryDef;
import com.facebook.react.views.view.ReactMapBufferViewManager;
import com.facebook.react.views.view.ReactViewManagerWrapper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;

public class SurfaceMountingManager {
    public static final String TAG = SurfaceMountingManager.class.getSimpleName();
    private static final boolean SHOW_CHANGED_VIEW_HIERARCHIES = false;
    private volatile boolean mIsStopped = false;
    private volatile boolean mRootViewAttached = false;
    @Nullable
    private ThemedReactContext mThemedReactContext;
    private ConcurrentHashMap<Integer, ViewState> mTagToViewState = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<MountItem> mOnViewAttachItems = new ConcurrentLinkedQueue();
    private JSResponderHandler mJSResponderHandler;
    private ViewManagerRegistry mViewManagerRegistry;
    private RootViewManager mRootViewManager;
    private MountingManager.MountItemExecutor mMountItemExecutor;
    @ThreadConfined(value="UI")
    private final Stack<Integer> mReactTagsToRemove = new Stack();
    @ThreadConfined(value="UI")
    private final Set<Integer> mErroneouslyReaddedReactTags = new HashSet<Integer>();
    @ThreadConfined(value="UI")
    private RemoveDeleteTreeUIFrameCallback mRemoveDeleteTreeUIFrameCallback;
    private Set<Integer> mTagSetForStoppedSurface;
    private final int mSurfaceId;

    public SurfaceMountingManager(int surfaceId, @NonNull JSResponderHandler jsResponderHandler, @NonNull ViewManagerRegistry viewManagerRegistry, @NonNull RootViewManager rootViewManager, @NonNull MountingManager.MountItemExecutor mountItemExecutor, @NonNull ThemedReactContext reactContext) {
        this.mSurfaceId = surfaceId;
        this.mJSResponderHandler = jsResponderHandler;
        this.mViewManagerRegistry = viewManagerRegistry;
        this.mRootViewManager = rootViewManager;
        this.mMountItemExecutor = mountItemExecutor;
        this.mThemedReactContext = reactContext;
    }

    public boolean isStopped() {
        return this.mIsStopped;
    }

    public void attachRootView(View rootView, ThemedReactContext themedReactContext) {
        this.mThemedReactContext = themedReactContext;
        this.addRootView(rootView);
    }

    public int getSurfaceId() {
        return this.mSurfaceId;
    }

    public boolean isRootViewAttached() {
        return this.mRootViewAttached;
    }

    @Nullable
    public ThemedReactContext getContext() {
        return this.mThemedReactContext;
    }

    private static void logViewHierarchy(ViewGroup parent, boolean recurse) {
        int parentTag = parent.getId();
        FLog.e((String)TAG, (String)("  <ViewGroup tag=" + parentTag + " class=" + parent.getClass().toString() + ">"));
        for (int i = 0; i < parent.getChildCount(); ++i) {
            FLog.e((String)TAG, (String)("     <View idx=" + i + " tag=" + parent.getChildAt(i).getId() + " class=" + parent.getChildAt(i).getClass().toString() + ">"));
        }
        FLog.e((String)TAG, (String)("  </ViewGroup tag=" + parentTag + ">"));
        if (recurse) {
            FLog.e((String)TAG, (String)"Displaying Ancestors:");
            for (ViewParent ancestor = parent.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                ViewGroup ancestorViewGroup = ancestor instanceof ViewGroup ? (ViewGroup)ancestor : null;
                int ancestorId = ancestorViewGroup == null ? -1 : ancestorViewGroup.getId();
                FLog.e((String)TAG, (String)("<ViewParent tag=" + ancestorId + " class=" + ancestor.getClass().toString() + ">"));
            }
        }
    }

    public boolean getViewExists(int tag) {
        if (this.mTagSetForStoppedSurface != null && this.mTagSetForStoppedSurface.contains(tag)) {
            return true;
        }
        if (this.mTagToViewState == null) {
            return false;
        }
        return this.mTagToViewState.containsKey(tag);
    }

    @AnyThread
    public void executeOnViewAttach(MountItem item) {
        this.mOnViewAttachItems.add(item);
    }

    @AnyThread
    private void addRootView(final @NonNull View rootView) {
        if (this.isStopped()) {
            return;
        }
        this.mTagToViewState.put(this.mSurfaceId, new ViewState(this.mSurfaceId, rootView, new ReactViewManagerWrapper.DefaultViewManager(this.mRootViewManager), true));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SurfaceMountingManager.this.isStopped()) {
                    return;
                }
                if (rootView.getId() == SurfaceMountingManager.this.mSurfaceId) {
                    ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Race condition in addRootView detected. Trying to set an id of [" + SurfaceMountingManager.this.mSurfaceId + "] on the RootView, but that id has already been set. "));
                } else if (rootView.getId() != -1) {
                    FLog.e((String)TAG, (String)"Trying to add RootTag to RootView that already has a tag: existing tag: [%d] new tag: [%d]", (Object[])new Object[]{rootView.getId(), SurfaceMountingManager.this.mSurfaceId});
                    throw new IllegalViewOperationException("Trying to add a root view with an explicit id already set. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID before calling addRootView.");
                }
                rootView.setId(SurfaceMountingManager.this.mSurfaceId);
                if (rootView instanceof ReactRoot) {
                    ((ReactRoot)rootView).setRootViewTag(SurfaceMountingManager.this.mSurfaceId);
                }
                SurfaceMountingManager.this.mRootViewAttached = true;
                SurfaceMountingManager.this.executeViewAttachMountItems();
            }
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    @UiThread
    @ThreadConfined(value="UI")
    private void executeViewAttachMountItems() {
        this.mMountItemExecutor.executeItems(this.mOnViewAttachItems);
    }

    @AnyThread
    public void stopSurface() {
        if (this.isStopped()) {
            return;
        }
        this.mIsStopped = true;
        for (ViewState viewState : this.mTagToViewState.values()) {
            if (viewState.mStateWrapper != null) {
                viewState.mStateWrapper.destroyState();
                viewState.mStateWrapper = null;
            }
            if (viewState.mEventEmitter == null) continue;
            viewState.mEventEmitter.destroy();
            viewState.mEventEmitter = null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (ViewState viewState : SurfaceMountingManager.this.mTagToViewState.values()) {
                    SurfaceMountingManager.this.onViewStateDeleted(viewState);
                }
                SurfaceMountingManager.this.mTagSetForStoppedSurface = SurfaceMountingManager.this.mTagToViewState.keySet();
                SurfaceMountingManager.this.mTagToViewState = null;
                SurfaceMountingManager.this.mJSResponderHandler = null;
                SurfaceMountingManager.this.mRootViewManager = null;
                SurfaceMountingManager.this.mMountItemExecutor = null;
                SurfaceMountingManager.this.mOnViewAttachItems.clear();
                if (ReactFeatureFlags.enableViewRecycling) {
                    SurfaceMountingManager.this.mViewManagerRegistry.onSurfaceStopped(SurfaceMountingManager.this.mSurfaceId);
                }
            }
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    @UiThread
    public void addViewAt(int parentTag, int tag, int index) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState parentViewState = this.getViewState(parentTag);
        if (!(parentViewState.mView instanceof ViewGroup)) {
            String message = "Unable to add a view into a view that is not a ViewGroup. ParentTag: " + parentTag + " - Tag: " + tag + " - Index: " + index;
            FLog.e((String)TAG, (String)message);
            throw new IllegalStateException(message);
        }
        ViewGroup parentView = (ViewGroup)parentViewState.mView;
        ViewState viewState = this.getViewState(tag);
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for viewState " + viewState + " and tag " + tag);
        }
        ViewParent viewParent = view.getParent();
        if (viewParent != null) {
            int actualParentId = viewParent instanceof ViewGroup ? ((ViewGroup)viewParent).getId() : -1;
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("addViewAt: cannot insert view [" + tag + "] into parent [" + parentTag + "]: View already has a parent: [" + actualParentId + "]  Parent: " + viewParent.getClass().getSimpleName() + " View: " + view.getClass().getSimpleName()));
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            this.mErroneouslyReaddedReactTags.add(tag);
        }
        try {
            SurfaceMountingManager.getViewGroupManager(parentViewState).addView(parentView, view, index);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("addViewAt: failed to insert view [" + tag + "] into parent [" + parentTag + "] at index " + index, e);
        }
    }

    @UiThread
    public void removeViewAt(int tag, int parentTag, int index) {
        int actualTag;
        if (this.isStopped()) {
            return;
        }
        if (this.mErroneouslyReaddedReactTags.contains(tag)) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("removeViewAt tried to remove a React View that was actually reused. This indicates a bug in the Differ (specifically instruction ordering). [" + tag + "]"));
            return;
        }
        UiThreadUtil.assertOnUiThread();
        ViewState parentViewState = this.getNullableViewState(parentTag);
        if (parentViewState == null) {
            ReactSoftExceptionLogger.logSoftException(MountingManager.TAG, new IllegalStateException("Unable to find viewState for tag: [" + parentTag + "] for removeViewAt"));
            return;
        }
        if (!(parentViewState.mView instanceof ViewGroup)) {
            String message = "Unable to remove a view from a view that is not a ViewGroup. ParentTag: " + parentTag + " - Tag: " + tag + " - Index: " + index;
            FLog.e((String)TAG, (String)message);
            throw new IllegalStateException(message);
        }
        ViewGroup parentView = (ViewGroup)parentViewState.mView;
        if (parentView == null) {
            throw new IllegalStateException("Unable to find view for tag [" + parentTag + "]");
        }
        ViewGroupManager<ViewGroup> viewGroupManager = SurfaceMountingManager.getViewGroupManager(parentViewState);
        View view = viewGroupManager.getChildAt(parentView, index);
        int n = actualTag = view != null ? view.getId() : -1;
        if (actualTag != tag) {
            int tagActualIndex = -1;
            int parentChildrenCount = parentView.getChildCount();
            for (int i = 0; i < parentChildrenCount; ++i) {
                if (parentView.getChildAt(i).getId() != tag) continue;
                tagActualIndex = i;
                break;
            }
            if (tagActualIndex == -1) {
                FLog.e((String)TAG, (String)("removeViewAt: [" + tag + "] -> [" + parentTag + "] @" + index + ": view already removed from parent! Children in parent: " + parentChildrenCount));
                return;
            }
            SurfaceMountingManager.logViewHierarchy(parentView, true);
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Tried to remove view [" + tag + "] of parent [" + parentTag + "] at index " + index + ", but got view tag " + actualTag + " - actual index of view: " + tagActualIndex));
            index = tagActualIndex;
        }
        try {
            viewGroupManager.removeViewAt(parentView, index);
        }
        catch (RuntimeException e) {
            int childCount = viewGroupManager.getChildCount(parentView);
            SurfaceMountingManager.logViewHierarchy(parentView, true);
            throw new IllegalStateException("Cannot remove child at index " + index + " from parent ViewGroup [" + parentView.getId() + "], only " + childCount + " children in parent. Warning: childCount may be incorrect!", e);
        }
    }

    @UiThread
    public void removeDeleteTreeAt(int tag, int parentTag, int index) {
        int actualTag;
        if (this.isStopped()) {
            return;
        }
        UiThreadUtil.assertOnUiThread();
        ViewState parentViewState = this.getNullableViewState(parentTag);
        if (parentViewState == null) {
            ReactSoftExceptionLogger.logSoftException(MountingManager.TAG, new IllegalStateException("Unable to find viewState for tag: [" + parentTag + "] for removeDeleteTreeAt"));
            return;
        }
        if (!(parentViewState.mView instanceof ViewGroup)) {
            String message = "Unable to remove+delete a view from a view that is not a ViewGroup. ParentTag: " + parentTag + " - Tag: " + tag + " - Index: " + index;
            FLog.e((String)TAG, (String)message);
            throw new IllegalStateException(message);
        }
        ViewGroup parentView = (ViewGroup)parentViewState.mView;
        if (parentView == null) {
            throw new IllegalStateException("Unable to find view for tag [" + parentTag + "]");
        }
        ViewGroupManager<ViewGroup> viewGroupManager = SurfaceMountingManager.getViewGroupManager(parentViewState);
        View view = viewGroupManager.getChildAt(parentView, index);
        int n = actualTag = view != null ? view.getId() : -1;
        if (actualTag != tag) {
            int tagActualIndex = -1;
            int parentChildrenCount = parentView.getChildCount();
            for (int i = 0; i < parentChildrenCount; ++i) {
                if (parentView.getChildAt(i).getId() != tag) continue;
                tagActualIndex = i;
                break;
            }
            if (tagActualIndex == -1) {
                FLog.e((String)TAG, (String)("removeDeleteTreeAt: [" + tag + "] -> [" + parentTag + "] @" + index + ": view already removed from parent! Children in parent: " + parentChildrenCount));
                return;
            }
            SurfaceMountingManager.logViewHierarchy(parentView, true);
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Tried to remove+delete view [" + tag + "] of parent [" + parentTag + "] at index " + index + ", but got view tag " + actualTag + " - actual index of view: " + tagActualIndex));
            index = tagActualIndex;
        }
        try {
            viewGroupManager.removeViewAt(parentView, index);
        }
        catch (RuntimeException e) {
            int childCount = viewGroupManager.getChildCount(parentView);
            SurfaceMountingManager.logViewHierarchy(parentView, true);
            throw new IllegalStateException("Cannot remove child at index " + index + " from parent ViewGroup [" + parentView.getId() + "], only " + childCount + " children in parent. Warning: childCount may be incorrect!", e);
        }
        this.runDeferredTagRemovalAndDeletion();
        this.mReactTagsToRemove.push(tag);
    }

    @UiThread
    private void runDeferredTagRemovalAndDeletion() {
        if (this.mReactTagsToRemove.empty()) {
            if (this.mRemoveDeleteTreeUIFrameCallback == null) {
                this.mRemoveDeleteTreeUIFrameCallback = new RemoveDeleteTreeUIFrameCallback(this.mThemedReactContext);
            }
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mRemoveDeleteTreeUIFrameCallback);
        }
    }

    @UiThread
    public void createView(@NonNull String componentName, int reactTag, @Nullable Object props, @Nullable StateWrapper stateWrapper, @Nullable EventEmitterWrapper eventEmitterWrapper, boolean isLayoutable) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState != null && viewState.mView != null) {
            return;
        }
        this.createViewUnsafe(componentName, reactTag, props, stateWrapper, eventEmitterWrapper, isLayoutable);
    }

    @UiThread
    public void createViewUnsafe(@NonNull String componentName, int reactTag, @Nullable Object props, @Nullable StateWrapper stateWrapper, @Nullable EventEmitterWrapper eventEmitterWrapper, boolean isLayoutable) {
        View view = null;
        ReactViewManagerWrapper viewManager = null;
        Object propMap = props instanceof ReadableMap ? new ReactStylesDiffMap((ReadableMap)props) : props;
        if (isLayoutable) {
            viewManager = props instanceof ReadableMapBuffer ? ReactMapBufferViewManager.INSTANCE : new ReactViewManagerWrapper.DefaultViewManager(this.mViewManagerRegistry.get(componentName));
            view = viewManager.createView(reactTag, this.mThemedReactContext, propMap, stateWrapper, this.mJSResponderHandler);
        }
        ViewState viewState = new ViewState(reactTag, view, viewManager);
        viewState.mCurrentProps = propMap;
        viewState.mStateWrapper = stateWrapper;
        viewState.mEventEmitter = eventEmitterWrapper;
        this.mTagToViewState.put(reactTag, viewState);
    }

    public void updateProps(int reactTag, Object props) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        viewState.mCurrentProps = props instanceof ReadableMap ? new ReactStylesDiffMap((ReadableMap)props) : props;
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for tag [" + reactTag + "]");
        }
        ((ReactViewManagerWrapper)Assertions.assertNotNull((Object)viewState.mViewManager)).updateProperties(view, viewState.mCurrentProps);
    }

    @Deprecated
    public void receiveCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            throw new RetryableMountingLayerException("Unable to find viewState for tag: [" + reactTag + "] for commandId: " + commandId);
        }
        if (viewState.mViewManager == null) {
            throw new RetryableMountingLayerException("Unable to find viewManager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new RetryableMountingLayerException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    public void receiveCommand(int reactTag, @NonNull String commandId, @Nullable ReadableArray commandArgs) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            throw new RetryableMountingLayerException("Unable to find viewState for tag: " + reactTag + " for commandId: " + commandId);
        }
        if (viewState.mViewManager == null) {
            throw new RetryableMountingLayerException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new RetryableMountingLayerException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    public void sendAccessibilityEvent(int reactTag, int eventType) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mViewManager == null) {
            throw new RetryableMountingLayerException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new RetryableMountingLayerException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mView.sendAccessibilityEvent(eventType);
    }

    @UiThread
    public void updateLayout(int reactTag, int parentTag, int x, int y, int width, int height, int displayType) {
        int visibility;
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        viewToUpdate.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        ViewParent parent = viewToUpdate.getParent();
        if (parent instanceof RootView) {
            parent.requestLayout();
        }
        ViewState parentViewState = this.getViewState(parentTag);
        ViewGroupManager<?> parentViewManager = null;
        if (parentViewState.mViewManager != null) {
            parentViewManager = parentViewState.mViewManager.getViewGroupManager();
        }
        if (parentViewManager == null || !parentViewManager.needsCustomLayoutForChildren()) {
            viewToUpdate.layout(x, y, x + width, y + height);
        }
        int n = visibility = displayType == 0 ? 4 : 0;
        if (viewToUpdate.getVisibility() != visibility) {
            viewToUpdate.setVisibility(visibility);
        }
    }

    @UiThread
    public void updatePadding(int reactTag, int left, int top, int right, int bottom) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        ReactViewManagerWrapper viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        viewManager.setPadding(viewToUpdate, left, top, right, bottom);
    }

    @UiThread
    public void updateOverflowInset(int reactTag, int overflowInsetLeft, int overflowInsetTop, int overflowInsetRight, int overflowInsetBottom) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        if (viewToUpdate instanceof ReactOverflowViewWithInset) {
            ((ReactOverflowViewWithInset)viewToUpdate).setOverflowInset(overflowInsetLeft, overflowInsetTop, overflowInsetRight, overflowInsetBottom);
        }
    }

    @UiThread
    public void updateState(int reactTag, @Nullable StateWrapper stateWrapper) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        StateWrapper prevStateWrapper = viewState.mStateWrapper;
        viewState.mStateWrapper = stateWrapper;
        ReactViewManagerWrapper viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for tag: " + reactTag);
        }
        Object extraData = viewManager.updateState(viewState.mView, viewState.mCurrentProps, stateWrapper);
        if (extraData != null) {
            viewManager.updateExtraData(viewState.mView, extraData);
        }
        if (prevStateWrapper != null) {
            prevStateWrapper.destroyState();
        }
    }

    @UiThread
    public void updateEventEmitter(int reactTag, @NonNull EventEmitterWrapper eventEmitter) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.mTagToViewState.get(reactTag);
        if (viewState == null) {
            viewState = new ViewState(reactTag, null, null);
            this.mTagToViewState.put(reactTag, viewState);
        }
        EventEmitterWrapper previousEventEmitterWrapper = viewState.mEventEmitter;
        viewState.mEventEmitter = eventEmitter;
        if (previousEventEmitterWrapper != eventEmitter && previousEventEmitterWrapper != null) {
            previousEventEmitterWrapper.destroy();
        }
        if (viewState.mPendingEventQueue != null) {
            for (ViewEvent viewEvent : viewState.mPendingEventQueue) {
                if (viewEvent.canCoalesceEvent()) {
                    eventEmitter.invokeUnique(viewEvent.getEventName(), viewEvent.getParams(), viewEvent.getCustomCoalesceKey());
                    continue;
                }
                eventEmitter.invoke(viewEvent.getEventName(), viewEvent.getParams(), viewEvent.getEventCategory());
            }
            viewState.mPendingEventQueue = null;
        }
    }

    @UiThread
    public synchronized void setJSResponder(int reactTag, int initialReactTag, boolean blockNativeResponder) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        if (!blockNativeResponder) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, null);
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        View view = viewState.mView;
        if (initialReactTag != reactTag && view instanceof ViewParent) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, (ViewParent)view);
            return;
        }
        if (view == null) {
            SoftAssertions.assertUnreachable("Cannot find view for tag [" + reactTag + "].");
            return;
        }
        if (viewState.mIsRoot) {
            SoftAssertions.assertUnreachable("Cannot block native responder on [" + reactTag + "] that is a root view");
        }
        this.mJSResponderHandler.setJSResponder(initialReactTag, view.getParent());
    }

    @UiThread
    private void onViewStateDeleted(ViewState viewState) {
        if (viewState.mStateWrapper != null) {
            viewState.mStateWrapper.destroyState();
            viewState.mStateWrapper = null;
        }
        if (viewState.mEventEmitter != null) {
            viewState.mEventEmitter.destroy();
            viewState.mEventEmitter = null;
        }
        ReactViewManagerWrapper viewManager = viewState.mViewManager;
        if (!viewState.mIsRoot && viewManager != null) {
            viewManager.onDropViewInstance(viewState.mView);
        }
    }

    @UiThread
    public void deleteView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            ReactSoftExceptionLogger.logSoftException(MountingManager.TAG, new IllegalStateException("Unable to find viewState for tag: " + reactTag + " for deleteView"));
            return;
        }
        this.mTagToViewState.remove(reactTag);
        this.onViewStateDeleted(viewState);
    }

    @UiThread
    public void preallocateView(String componentName, int reactTag, @Nullable Object props, @Nullable StateWrapper stateWrapper, @Nullable EventEmitterWrapper eventEmitterWrapper, boolean isLayoutable) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        if (this.getNullableViewState(reactTag) != null) {
            return;
        }
        this.createViewUnsafe(componentName, reactTag, props, stateWrapper, eventEmitterWrapper, isLayoutable);
    }

    @Nullable
    @AnyThread
    @ThreadConfined(value="ANY")
    public EventEmitterWrapper getEventEmitter(int reactTag) {
        ViewState viewState = this.getNullableViewState(reactTag);
        return viewState == null ? null : viewState.mEventEmitter;
    }

    @UiThread
    public View getView(int reactTag) {
        View view;
        ViewState state = this.getNullableViewState(reactTag);
        View view2 = view = state == null ? null : state.mView;
        if (view == null) {
            throw new IllegalViewOperationException("Trying to resolve view with tag " + reactTag + " which doesn't exist");
        }
        return view;
    }

    @NonNull
    private ViewState getViewState(int tag) {
        ViewState viewState = this.mTagToViewState.get(tag);
        if (viewState == null) {
            throw new RetryableMountingLayerException("Unable to find viewState for tag " + tag + ". Surface stopped: " + this.isStopped());
        }
        return viewState;
    }

    @Nullable
    private ViewState getNullableViewState(int tag) {
        ConcurrentHashMap<Integer, ViewState> viewStates = this.mTagToViewState;
        if (viewStates == null) {
            return null;
        }
        return viewStates.get(tag);
    }

    @NonNull
    private static ViewGroupManager<ViewGroup> getViewGroupManager(@NonNull ViewState viewState) {
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        return viewState.mViewManager.getViewGroupManager();
    }

    public void printSurfaceState() {
        FLog.e((String)TAG, (String)"Views created for surface {%d}:", (Object[])new Object[]{this.getSurfaceId()});
        for (ViewState viewState : this.mTagToViewState.values()) {
            String viewManagerName = viewState.mViewManager != null ? viewState.mViewManager.getName() : null;
            View view = viewState.mView;
            View parent = view != null ? (View)view.getParent() : null;
            Integer parentTag = parent != null ? Integer.valueOf(parent.getId()) : null;
            FLog.e((String)TAG, (String)"<%s id=%d parentTag=%s isRoot=%b />", (Object[])new Object[]{viewManagerName, viewState.mReactTag, parentTag, viewState.mIsRoot});
        }
    }

    @UiThread
    public void enqueuePendingEvent(int reactTag, ViewEvent viewEvent) {
        UiThreadUtil.assertOnUiThread();
        if (this.mTagToViewState == null) {
            return;
        }
        ViewState viewState = this.mTagToViewState.get(reactTag);
        if (viewState == null) {
            return;
        }
        Assertions.assertCondition((viewState.mEventEmitter == null ? 1 : 0) != 0, (String)"Only queue pending events when event emitter is null for the given view state");
        if (viewState.mPendingEventQueue == null) {
            viewState.mPendingEventQueue = new LinkedList<ViewEvent>();
        }
        viewState.mPendingEventQueue.add(viewEvent);
    }

    private class RemoveDeleteTreeUIFrameCallback
    extends GuardedFrameCallback {
        private static final long FRAME_TIME_MS = 16L;
        private static final long MAX_TIME_IN_FRAME = 9L;

        private RemoveDeleteTreeUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
        }

        private boolean haveExceededNonBatchedFrameTime(long frameTimeNanos) {
            long timeLeftInFrame = 16L - (System.nanoTime() - frameTimeNanos) / 1000000L;
            return timeLeftInFrame < 9L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void doFrameGuarded(long frameTimeNanos) {
            int deletedViews = 0;
            Stack<Integer> localChildren = new Stack<Integer>();
            try {
                while (!SurfaceMountingManager.this.mReactTagsToRemove.empty()) {
                    int reactTag = (Integer)SurfaceMountingManager.this.mReactTagsToRemove.pop();
                    ++deletedViews;
                    if (SurfaceMountingManager.this.mErroneouslyReaddedReactTags.contains(reactTag)) {
                        ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("RemoveDeleteTree recursively tried to remove a React View that was actually reused. This indicates a bug in the Differ. [" + reactTag + "]"));
                        continue;
                    }
                    localChildren.clear();
                    ViewState thisViewState = SurfaceMountingManager.this.getNullableViewState(reactTag);
                    if (thisViewState == null) continue;
                    View thisView = thisViewState.mView;
                    int numChildren = 0;
                    boolean childrenAreManaged = false;
                    if (thisView instanceof ViewGroup) {
                        View nextChild = null;
                        while ((nextChild = ((ViewGroup)thisView).getChildAt(numChildren)) != null) {
                            int childId = nextChild.getId();
                            childrenAreManaged = childrenAreManaged || SurfaceMountingManager.this.getNullableViewState(childId) != null;
                            localChildren.push(nextChild.getId());
                            ++numChildren;
                        }
                        if (childrenAreManaged) {
                            try {
                                ((ViewGroup)thisView).removeAllViews();
                            }
                            catch (RuntimeException e) {
                                childrenAreManaged = false;
                                ReactSoftExceptionLogger.logSoftException(TAG, e);
                            }
                        }
                    }
                    if (childrenAreManaged) {
                        SurfaceMountingManager.this.mReactTagsToRemove.addAll(localChildren);
                    }
                    SurfaceMountingManager.this.mTagToViewState.remove(reactTag);
                    SurfaceMountingManager.this.onViewStateDeleted(thisViewState);
                    if (deletedViews % 20 != 0 || !this.haveExceededNonBatchedFrameTime(frameTimeNanos)) continue;
                    break;
                }
            }
            finally {
                if (!SurfaceMountingManager.this.mReactTagsToRemove.empty()) {
                    ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
                } else {
                    SurfaceMountingManager.this.mErroneouslyReaddedReactTags.clear();
                    SurfaceMountingManager.this.mReactTagsToRemove.clear();
                }
            }
        }
    }

    public static class ViewEvent {
        private final String mEventName;
        private final boolean mCanCoalesceEvent;
        private final int mCustomCoalesceKey;
        @EventCategoryDef
        private final int mEventCategory;
        @Nullable
        private WritableMap mParams;

        public ViewEvent(String eventName, @Nullable WritableMap params, @EventCategoryDef int eventCategory, boolean canCoalesceEvent, int customCoalesceKey) {
            this.mEventName = eventName;
            this.mParams = params;
            this.mEventCategory = eventCategory;
            this.mCanCoalesceEvent = canCoalesceEvent;
            this.mCustomCoalesceKey = customCoalesceKey;
        }

        public String getEventName() {
            return this.mEventName;
        }

        public boolean canCoalesceEvent() {
            return this.mCanCoalesceEvent;
        }

        public int getCustomCoalesceKey() {
            return this.mCustomCoalesceKey;
        }

        @EventCategoryDef
        public int getEventCategory() {
            return this.mEventCategory;
        }

        @Nullable
        public WritableMap getParams() {
            return this.mParams;
        }
    }

    private static class ViewState {
        @Nullable
        final View mView;
        final int mReactTag;
        final boolean mIsRoot;
        @Nullable
        final ReactViewManagerWrapper mViewManager;
        @Nullable
        public Object mCurrentProps = null;
        @Nullable
        public ReadableMap mCurrentLocalData = null;
        @Nullable
        public StateWrapper mStateWrapper = null;
        @Nullable
        public EventEmitterWrapper mEventEmitter = null;
        @Nullable
        public Queue<ViewEvent> mPendingEventQueue = null;

        private ViewState(int reactTag, @Nullable View view, @Nullable ReactViewManagerWrapper viewManager) {
            this(reactTag, view, viewManager, false);
        }

        private ViewState(int reactTag, @Nullable View view, @Nullable ReactViewManagerWrapper viewManager, boolean isRoot) {
            this.mReactTag = reactTag;
            this.mView = view;
            this.mIsRoot = isRoot;
            this.mViewManager = viewManager;
        }

        public String toString() {
            boolean isLayoutOnly = this.mViewManager == null;
            return "ViewState [" + this.mReactTag + "] - isRoot: " + this.mIsRoot + " - props: " + this.mCurrentProps + " - localData: " + this.mCurrentLocalData + " - viewManager: " + this.mViewManager + " - isLayoutOnly: " + isLayoutOnly;
        }
    }
}

