/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.events;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.uimanager.events.EventCategoryDef;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchesHelper;
import com.facebook.systrace.Systrace;

public class FabricEventEmitter
implements RCTModernEventEmitter {
    private static final String TAG = "FabricEventEmitter";
    @NonNull
    private final FabricUIManager mUIManager;

    public FabricEventEmitter(@NonNull FabricUIManager uiManager) {
        this.mUIManager = uiManager;
    }

    @Override
    public void receiveEvent(int reactTag, @NonNull String eventName, @Nullable WritableMap params) {
        this.receiveEvent(-1, reactTag, eventName, params);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(surfaceId, reactTag, eventName, false, 0, params, 2);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap params, @EventCategoryDef int category) {
        Systrace.beginSection(0L, "FabricEventEmitter.receiveEvent('" + eventName + "')");
        this.mUIManager.receiveEvent(surfaceId, reactTag, eventName, canCoalesceEvent, customCoalesceKey, params, category);
        Systrace.endSection(0L);
    }

    @Override
    public void receiveTouches(@NonNull String eventName, @NonNull WritableArray touches, @NonNull WritableArray changedIndices) {
        throw new IllegalStateException("EventEmitter#receiveTouches is not supported by Fabric");
    }

    @Override
    public void receiveTouches(TouchEvent event) {
        TouchesHelper.sendTouchEvent(this, event);
    }
}

