/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.view.ReactViewGroup;

public class ReactHorizontalScrollContainerView
extends ReactViewGroup {
    private int mLayoutDirection;
    private int mCurrentWidth;

    public ReactHorizontalScrollContainerView(Context context) {
        super(context);
        this.mLayoutDirection = I18nUtil.getInstance().isRTL(context) ? 1 : 0;
        this.mCurrentWidth = 0;
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (this.mLayoutDirection == 1) {
            super.setRemoveClippedSubviews(false);
            return;
        }
        super.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mLayoutDirection == 1) {
            int newLeft = 0;
            int width = right - left;
            int newRight = newLeft + width;
            this.setLeft(newLeft);
            this.setRight(newRight);
            if (this.mCurrentWidth != this.getWidth()) {
                ReactHorizontalScrollView parent = (ReactHorizontalScrollView)this.getParent();
                int offsetX = parent.getScrollX() + this.getWidth() - this.mCurrentWidth - parent.getWidth();
                parent.scrollTo(offsetX, parent.getScrollY());
            }
        }
        this.mCurrentWidth = this.getWidth();
    }
}

