/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.ReactCompoundViewGroup;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.common.ViewUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public class TouchTargetHelper {
    private static final float[] mEventCoords = new float[2];
    private static final PointF mTempPoint = new PointF();
    private static final float[] mMatrixTransformCoords = new float[2];
    private static final Matrix mInverseMatrix = new Matrix();

    public static int findTargetTagForTouch(float eventX, float eventY, ViewGroup viewGroup) {
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(eventX, eventY, viewGroup, mEventCoords, null);
    }

    public static int findTargetTagForTouch(float eventX, float eventY, ViewGroup viewGroup, @Nullable int[] nativeViewId) {
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(eventX, eventY, viewGroup, mEventCoords, nativeViewId);
    }

    public static int findTargetTagAndCoordinatesForTouch(float eventX, float eventY, ViewGroup viewGroup, float[] viewCoords, @Nullable int[] nativeViewTag) {
        View reactTargetView;
        UiThreadUtil.assertOnUiThread();
        int targetTag = viewGroup.getId();
        viewCoords[0] = eventX;
        viewCoords[1] = eventY;
        View nativeTargetView = TouchTargetHelper.findTouchTargetViewWithPointerEvents(viewCoords, (View)viewGroup, null);
        if (nativeTargetView != null && (reactTargetView = TouchTargetHelper.findClosestReactAncestor(nativeTargetView)) != null) {
            if (nativeViewTag != null) {
                nativeViewTag[0] = reactTargetView.getId();
            }
            targetTag = TouchTargetHelper.getTouchTargetForView(reactTargetView, viewCoords[0], viewCoords[1]);
        }
        return targetTag;
    }

    @SuppressLint(value={"ResourceType"})
    public static List<ViewTarget> findTargetPathAndCoordinatesForTouch(float eventX, float eventY, ViewGroup viewGroup, float[] viewCoords) {
        UiThreadUtil.assertOnUiThread();
        viewCoords[0] = eventX;
        viewCoords[1] = eventY;
        List<ViewTarget> pathAccumulator = new ArrayList<ViewTarget>();
        View targetView = TouchTargetHelper.findTouchTargetViewWithPointerEvents(viewCoords, (View)viewGroup, pathAccumulator);
        if (targetView != null) {
            int targetTag;
            View reactTargetView = targetView;
            int firstReactAncestor = 0;
            while (reactTargetView != null && reactTargetView.getId() <= 0) {
                reactTargetView = (View)reactTargetView.getParent();
                ++firstReactAncestor;
            }
            if (firstReactAncestor > 0) {
                pathAccumulator = pathAccumulator.subList(firstReactAncestor, pathAccumulator.size());
            }
            if ((targetTag = TouchTargetHelper.getTouchTargetForView(reactTargetView, eventX, eventY)) != reactTargetView.getId()) {
                pathAccumulator.add(0, new ViewTarget(targetTag, null));
            }
        }
        return pathAccumulator;
    }

    @SuppressLint(value={"ResourceType"})
    private static View findClosestReactAncestor(View view) {
        while (view != null && view.getId() <= 0) {
            view = (View)view.getParent();
        }
        return view;
    }

    private static View findTouchTargetView(float[] eventCoords, View view, EnumSet<TouchTargetReturnType> allowReturnTouchTargetTypes, List<ViewTarget> pathAccumulator) {
        if (allowReturnTouchTargetTypes.contains((Object)TouchTargetReturnType.CHILD) && view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            if (!TouchTargetHelper.isTouchPointInView(eventCoords[0], eventCoords[1], view)) {
                if (view instanceof ReactOverflowViewWithInset) {
                    if (ViewUtil.getUIManagerType(view.getId()) == 2 && ReactFeatureFlags.useOverflowInset && !TouchTargetHelper.isTouchPointInViewWithOverflowInset(eventCoords[0], eventCoords[1], view)) {
                        return null;
                    }
                    String overflow = ((ReactOverflowViewWithInset)view).getOverflow();
                    if ("hidden".equals(overflow) || "scroll".equals(overflow)) {
                        return null;
                    }
                }
                if (viewGroup.getClipChildren()) {
                    return null;
                }
            }
            int childrenCount = viewGroup.getChildCount();
            ReactZIndexedViewGroup zIndexedViewGroup = viewGroup instanceof ReactZIndexedViewGroup ? (ReactZIndexedViewGroup)viewGroup : null;
            for (int i = childrenCount - 1; i >= 0; --i) {
                int childIndex = zIndexedViewGroup != null ? zIndexedViewGroup.getZIndexMappedChildIndex(i) : i;
                View child = viewGroup.getChildAt(childIndex);
                PointF childPoint = mTempPoint;
                TouchTargetHelper.getChildPoint(eventCoords[0], eventCoords[1], viewGroup, child, childPoint);
                float restoreX = eventCoords[0];
                float restoreY = eventCoords[1];
                eventCoords[0] = childPoint.x;
                eventCoords[1] = childPoint.y;
                View targetView = TouchTargetHelper.findTouchTargetViewWithPointerEvents(eventCoords, child, pathAccumulator);
                if (targetView != null) {
                    return targetView;
                }
                eventCoords[0] = restoreX;
                eventCoords[1] = restoreY;
            }
        }
        if (allowReturnTouchTargetTypes.contains((Object)TouchTargetReturnType.SELF) && TouchTargetHelper.isTouchPointInView(eventCoords[0], eventCoords[1], view)) {
            return view;
        }
        return null;
    }

    private static boolean isTouchPointInView(float x, float y, View view) {
        if (view instanceof ReactHitSlopView && ((ReactHitSlopView)view).getHitSlopRect() != null) {
            Rect hitSlopRect = ((ReactHitSlopView)view).getHitSlopRect();
            return x >= (float)(-hitSlopRect.left) && x < (float)(view.getWidth() + hitSlopRect.right) && y >= (float)(-hitSlopRect.top) && y < (float)(view.getHeight() + hitSlopRect.bottom);
        }
        return x >= 0.0f && x < (float)view.getWidth() && y >= 0.0f && y < (float)view.getHeight();
    }

    private static boolean isTouchPointInViewWithOverflowInset(float x, float y, View view) {
        if (!(view instanceof ReactOverflowViewWithInset)) {
            return false;
        }
        Rect overflowInset = ((ReactOverflowViewWithInset)view).getOverflowInset();
        return x >= (float)overflowInset.left && x < (float)(view.getWidth() - overflowInset.right) && y >= (float)overflowInset.top && y < (float)(view.getHeight() - overflowInset.bottom);
    }

    private static void getChildPoint(float x, float y, ViewGroup parent, View child, PointF outLocalPoint) {
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        Matrix matrix = child.getMatrix();
        if (!matrix.isIdentity()) {
            float[] localXY = mMatrixTransformCoords;
            localXY[0] = localX;
            localXY[1] = localY;
            Matrix inverseMatrix = mInverseMatrix;
            matrix.invert(inverseMatrix);
            inverseMatrix.mapPoints(localXY);
            localX = localXY[0];
            localY = localXY[1];
        }
        outLocalPoint.set(localX, localY);
    }

    @Nullable
    private static View findTouchTargetViewWithPointerEvents(float[] eventCoords, View view, @Nullable List<ViewTarget> pathAccumulator) {
        PointerEvents pointerEvents;
        PointerEvents pointerEvents2 = pointerEvents = view instanceof ReactPointerEventsView ? ((ReactPointerEventsView)view).getPointerEvents() : PointerEvents.AUTO;
        if (!view.isEnabled()) {
            if (pointerEvents == PointerEvents.AUTO) {
                pointerEvents = PointerEvents.BOX_NONE;
            } else if (pointerEvents == PointerEvents.BOX_ONLY) {
                pointerEvents = PointerEvents.NONE;
            }
        }
        if (pointerEvents == PointerEvents.NONE) {
            return null;
        }
        if (pointerEvents == PointerEvents.BOX_ONLY) {
            View targetView = TouchTargetHelper.findTouchTargetView(eventCoords, view, EnumSet.of(TouchTargetReturnType.SELF), pathAccumulator);
            if (targetView != null && pathAccumulator != null) {
                pathAccumulator.add(new ViewTarget(view.getId(), view));
            }
            return targetView;
        }
        if (pointerEvents == PointerEvents.BOX_NONE) {
            int reactTag;
            View targetView = TouchTargetHelper.findTouchTargetView(eventCoords, view, EnumSet.of(TouchTargetReturnType.CHILD), pathAccumulator);
            if (targetView != null) {
                if (pathAccumulator != null) {
                    pathAccumulator.add(new ViewTarget(view.getId(), view));
                }
                return targetView;
            }
            if (view instanceof ReactCompoundView && TouchTargetHelper.isTouchPointInView(eventCoords[0], eventCoords[1], view) && (reactTag = ((ReactCompoundView)view).reactTagForTouch(eventCoords[0], eventCoords[1])) != view.getId()) {
                if (pathAccumulator != null) {
                    pathAccumulator.add(new ViewTarget(view.getId(), view));
                }
                return view;
            }
            return null;
        }
        if (pointerEvents == PointerEvents.AUTO) {
            if (view instanceof ReactCompoundViewGroup && TouchTargetHelper.isTouchPointInView(eventCoords[0], eventCoords[1], view) && ((ReactCompoundViewGroup)view).interceptsTouchEvent(eventCoords[0], eventCoords[1])) {
                if (pathAccumulator != null) {
                    pathAccumulator.add(new ViewTarget(view.getId(), view));
                }
                return view;
            }
            View result = TouchTargetHelper.findTouchTargetView(eventCoords, view, EnumSet.of(TouchTargetReturnType.SELF, TouchTargetReturnType.CHILD), pathAccumulator);
            if (result != null && pathAccumulator != null) {
                pathAccumulator.add(new ViewTarget(view.getId(), view));
            }
            return result;
        }
        throw new JSApplicationIllegalArgumentException("Unknown pointer event type: " + pointerEvents.toString());
    }

    private static int getTouchTargetForView(View targetView, float eventX, float eventY) {
        if (targetView instanceof ReactCompoundView) {
            return ((ReactCompoundView)targetView).reactTagForTouch(eventX, eventY);
        }
        return targetView.getId();
    }

    public static class ViewTarget {
        private final int mViewId;
        @Nullable
        private final View mView;

        private ViewTarget(int viewId, @Nullable View view) {
            this.mViewId = viewId;
            this.mView = view;
        }

        public int getViewId() {
            return this.mViewId;
        }

        @Nullable
        public View getView() {
            return this.mView;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ViewTarget)) {
                return false;
            }
            ViewTarget other = (ViewTarget)o;
            return other.getViewId() == this.mViewId;
        }

        public int hashCode() {
            return Objects.hashCode(this.mViewId);
        }
    }

    private static enum TouchTargetReturnType {
        SELF,
        CHILD;

    }
}

