/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.mapbuffer;

import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.MapBufferSoLoader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0002?@B\u000f\b\u0013\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010)\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020\tH\u0016J\t\u0010,\u001a\u00020\u0006H\u0082 J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140.H\u0096\u0002J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\tH\u0002J\u0010\u00101\u001a\u00020(2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\tH\u0002J\b\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00000$2\u0006\u00107\u001a\u00020\tH\u0002J\u0010\u00108\u001a\u00020\u00002\u0006\u00107\u001a\u00020\tH\u0002J\u0010\u00109\u001a\u00020&2\u0006\u00100\u001a\u00020\tH\u0002J \u0010:\u001a\u00020;2\u0006\u00100\u001a\u00020\tH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b<\u0010=J\b\u0010>\u001a\u00020&H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006A"}, d2={"Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer;", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "hybridData", "Lcom/facebook/jni/HybridData;", "(Lcom/facebook/jni/HybridData;)V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "<set-?>", "", "count", "getCount", "()I", "mHybridData", "offsetForDynamicData", "getOffsetForDynamicData", "contains", "", "key", "entryAt", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "offset", "equals", "other", "", "getBoolean", "getBucketIndexForKey", "intKey", "getDouble", "", "getInt", "getKeyOffset", "getKeyOffsetForBucketIndex", "bucketIndex", "getMapBuffer", "getMapBufferList", "", "getString", "", "getType", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "getTypedValueOffsetForKey", "expected", "hashCode", "importByteBuffer", "iterator", "", "readBooleanValue", "bufferPosition", "readDataType", "readDoubleValue", "readHeader", "", "readIntValue", "readMapBufferListValue", "position", "readMapBufferValue", "readStringValue", "readUnsignedShort", "Lkotlin/UShort;", "readUnsignedShort-BwKQO78", "(I)S", "toString", "Companion", "MapBufferEntry", "ReactAndroid_debug"})
@NotThreadSafe
@DoNotStrip
public final class ReadableMapBuffer
implements MapBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @DoNotStrip
    @Nullable
    private final HybridData mHybridData;
    @NotNull
    private final ByteBuffer buffer;
    private int count;
    private static final int ALIGNMENT = 254;
    private static final int HEADER_SIZE = 8;
    private static final int BUCKET_SIZE = 12;
    private static final int TYPE_OFFSET = 2;
    private static final int VALUE_OFFSET = 4;

    @Override
    public int getCount() {
        return this.count;
    }

    @DoNotStrip
    private ReadableMapBuffer(HybridData hybridData) {
        this.mHybridData = hybridData;
        this.buffer = this.importByteBuffer();
        this.readHeader();
    }

    private ReadableMapBuffer(ByteBuffer buffer) {
        this.mHybridData = null;
        this.buffer = buffer;
        this.readHeader();
    }

    private final native ByteBuffer importByteBuffer();

    private final void readHeader() {
        short storedAlignment = this.buffer.getShort();
        if (storedAlignment != 254) {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.count = this.readUnsignedShort-BwKQO78(this.buffer.position()) & 0xFFFF;
    }

    private final int getOffsetForDynamicData() {
        return this.getKeyOffsetForBucketIndex(this.getCount());
    }

    private final int getBucketIndexForKey(int intKey) {
        IntRange intRange = MapBuffer.Companion.getKEY_RANGE$ReactAndroid_debug();
        int n = intRange.getFirst();
        if (!(intKey <= intRange.getLast() ? n <= intKey : false)) {
            return -1;
        }
        short key = UShort.constructor-impl((short)((short)intKey));
        int lo = 0;
        int hi = this.getCount() - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            short midVal = this.readUnsignedShort-BwKQO78(this.getKeyOffsetForBucketIndex(mid));
            if (Intrinsics.compare((int)(midVal & 0xFFFF), (int)(key & 0xFFFF)) < 0) {
                lo = mid + 1;
                continue;
            }
            if (Intrinsics.compare((int)(midVal & 0xFFFF), (int)(key & 0xFFFF)) > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private final MapBuffer.DataType readDataType(int bucketIndex) {
        int value = this.readUnsignedShort-BwKQO78(this.getKeyOffsetForBucketIndex(bucketIndex) + 2) & 0xFFFF;
        return MapBuffer.DataType.values()[value];
    }

    private final int getTypedValueOffsetForKey(int key, MapBuffer.DataType expected) {
        int bucketIndex = this.getBucketIndexForKey(key);
        if (!(bucketIndex != -1)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Key not found: ", (Object)key);
            throw new IllegalArgumentException(string.toString());
        }
        MapBuffer.DataType dataType = this.readDataType(bucketIndex);
        if (!(dataType == expected)) {
            boolean bl = false;
            String string = "Expected " + (Object)((Object)expected) + " for key: " + key + ", found " + (Object)((Object)dataType) + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return this.getKeyOffsetForBucketIndex(bucketIndex) + 4;
    }

    private final short readUnsignedShort-BwKQO78(int bufferPosition) {
        return UShort.constructor-impl((short)this.buffer.getShort(bufferPosition));
    }

    private final double readDoubleValue(int bufferPosition) {
        return this.buffer.getDouble(bufferPosition);
    }

    private final int readIntValue(int bufferPosition) {
        return this.buffer.getInt(bufferPosition);
    }

    private final boolean readBooleanValue(int bufferPosition) {
        return this.readIntValue(bufferPosition) == 1;
    }

    private final String readStringValue(int bufferPosition) {
        int offset = this.getOffsetForDynamicData() + this.buffer.getInt(bufferPosition);
        int sizeOfString = this.buffer.getInt(offset);
        byte[] result = new byte[sizeOfString];
        int stringOffset = offset + 4;
        this.buffer.position(stringOffset);
        this.buffer.get(result, 0, sizeOfString);
        return new String(result, Charsets.UTF_8);
    }

    private final ReadableMapBuffer readMapBufferValue(int position) {
        int offset = this.getOffsetForDynamicData() + this.buffer.getInt(position);
        int sizeMapBuffer = this.buffer.getInt(offset);
        byte[] newBuffer = new byte[sizeMapBuffer];
        int bufferOffset = offset + 4;
        this.buffer.position(bufferOffset);
        this.buffer.get(newBuffer, 0, sizeMapBuffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(newBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(newBuffer)");
        return new ReadableMapBuffer(byteBuffer);
    }

    private final List<ReadableMapBuffer> readMapBufferListValue(int position) {
        int sizeMapBuffer;
        ArrayList<ReadableMapBuffer> readMapBufferList = new ArrayList<ReadableMapBuffer>();
        int offset = this.getOffsetForDynamicData() + this.buffer.getInt(position);
        int sizeMapBufferList = this.buffer.getInt(offset);
        offset += 4;
        for (int curLen = 0; curLen < sizeMapBufferList; curLen += sizeMapBuffer) {
            sizeMapBuffer = this.buffer.getInt(offset + curLen);
            byte[] newMapBuffer = new byte[sizeMapBuffer];
            this.buffer.position(offset + (curLen += 4));
            this.buffer.get(newMapBuffer, 0, sizeMapBuffer);
            ByteBuffer byteBuffer = ByteBuffer.wrap(newMapBuffer);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(newMapBuffer)");
            readMapBufferList.add(new ReadableMapBuffer(byteBuffer));
        }
        return readMapBufferList;
    }

    private final int getKeyOffsetForBucketIndex(int bucketIndex) {
        return 8 + 12 * bucketIndex;
    }

    @Override
    public boolean contains(int key) {
        return this.getBucketIndexForKey(key) != -1;
    }

    @Override
    public int getKeyOffset(int key) {
        return this.getBucketIndexForKey(key);
    }

    @Override
    @NotNull
    public MapBuffer.Entry entryAt(int offset) {
        return new MapBufferEntry(this.getKeyOffsetForBucketIndex(offset));
    }

    @Override
    @NotNull
    public MapBuffer.DataType getType(int key) {
        int bucketIndex = this.getBucketIndexForKey(key);
        if (!(bucketIndex != -1)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Key not found: ", (Object)key);
            throw new IllegalArgumentException(string.toString());
        }
        return this.readDataType(bucketIndex);
    }

    @Override
    public int getInt(int key) {
        return this.readIntValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.INT));
    }

    @Override
    public double getDouble(int key) {
        return this.readDoubleValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.DOUBLE));
    }

    @Override
    @NotNull
    public String getString(int key) {
        return this.readStringValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.STRING));
    }

    @Override
    public boolean getBoolean(int key) {
        return this.readBooleanValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.BOOL));
    }

    @Override
    @NotNull
    public ReadableMapBuffer getMapBuffer(int key) {
        return this.readMapBufferValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.MAP));
    }

    @NotNull
    public List<ReadableMapBuffer> getMapBufferList(int key) {
        return this.readMapBufferListValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.MAP));
    }

    public int hashCode() {
        this.buffer.rewind();
        return this.buffer.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ReadableMapBuffer)) {
            return false;
        }
        ByteBuffer thisByteBuffer = this.buffer;
        ByteBuffer otherByteBuffer = ((ReadableMapBuffer)other).buffer;
        if (thisByteBuffer == otherByteBuffer) {
            return true;
        }
        thisByteBuffer.rewind();
        otherByteBuffer.rewind();
        return Intrinsics.areEqual((Object)thisByteBuffer, (Object)otherByteBuffer);
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (MapBuffer.Entry entry : this) {
            int key = entry.getKey();
            builder.append(key);
            builder.append('=');
            switch (WhenMappings.$EnumSwitchMapping$0[entry.getType().ordinal()]) {
                case 1: {
                    builder.append(entry.getBooleanValue());
                    break;
                }
                case 2: {
                    builder.append(entry.getIntValue());
                    break;
                }
                case 3: {
                    builder.append(entry.getDoubleValue());
                    break;
                }
                case 4: {
                    builder.append(entry.getStringValue());
                    break;
                }
                case 5: {
                    builder.append(entry.getMapBufferValue().toString());
                }
            }
            builder.append(',');
        }
        builder.append('}');
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @Override
    @NotNull
    public Iterator<MapBuffer.Entry> iterator() {
        return new Iterator<MapBuffer.Entry>(this){
            private int current;
            private final int last;
            final /* synthetic */ ReadableMapBuffer this$0;
            {
                this.this$0 = $receiver;
                this.last = this.this$0.getCount() - 1;
            }

            public final int getCurrent() {
                return this.current;
            }

            public final void setCurrent(int n) {
                this.current = n;
            }

            public final int getLast() {
                return this.last;
            }

            public boolean hasNext() {
                return this.current <= this.last;
            }

            @NotNull
            public MapBuffer.Entry next() {
                int n = this.current;
                this.current = n + 1;
                return this.this$0.new MapBufferEntry(ReadableMapBuffer.access$getKeyOffsetForBucketIndex(this.this$0, n));
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public static final /* synthetic */ int access$getKeyOffsetForBucketIndex(ReadableMapBuffer $this, int bucketIndex) {
        return $this.getKeyOffsetForBucketIndex(bucketIndex);
    }

    static {
        MapBufferSoLoader.staticInit();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer$MapBufferEntry;", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "bucketOffset", "", "(Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer;I)V", "booleanValue", "", "getBooleanValue", "()Z", "doubleValue", "", "getDoubleValue", "()D", "intValue", "getIntValue", "()I", "key", "getKey", "mapBufferValue", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "getMapBufferValue", "()Lcom/facebook/react/common/mapbuffer/MapBuffer;", "stringValue", "", "getStringValue", "()Ljava/lang/String;", "type", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "getType", "()Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "assertType", "", "expected", "ReactAndroid_debug"})
    private final class MapBufferEntry
    implements MapBuffer.Entry {
        private final int bucketOffset;

        public MapBufferEntry(int bucketOffset) {
            Intrinsics.checkNotNullParameter((Object)ReadableMapBuffer.this, (String)"this$0");
            this.bucketOffset = bucketOffset;
        }

        private final void assertType(MapBuffer.DataType expected) {
            MapBuffer.DataType dataType = this.getType();
            if (!(expected == dataType)) {
                boolean bl = false;
                String string = "Expected " + (Object)((Object)expected) + " for key: " + this.getKey() + " found " + (Object)((Object)dataType) + " instead.";
                throw new IllegalStateException(string.toString());
            }
        }

        @Override
        public int getKey() {
            return ReadableMapBuffer.this.readUnsignedShort-BwKQO78(this.bucketOffset) & 0xFFFF;
        }

        @Override
        @NotNull
        public MapBuffer.DataType getType() {
            return MapBuffer.DataType.values()[ReadableMapBuffer.this.readUnsignedShort-BwKQO78(this.bucketOffset + 2) & 0xFFFF];
        }

        @Override
        public double getDoubleValue() {
            this.assertType(MapBuffer.DataType.DOUBLE);
            return ReadableMapBuffer.this.readDoubleValue(this.bucketOffset + 4);
        }

        @Override
        public int getIntValue() {
            this.assertType(MapBuffer.DataType.INT);
            return ReadableMapBuffer.this.readIntValue(this.bucketOffset + 4);
        }

        @Override
        public boolean getBooleanValue() {
            this.assertType(MapBuffer.DataType.BOOL);
            return ReadableMapBuffer.this.readBooleanValue(this.bucketOffset + 4);
        }

        @Override
        @NotNull
        public String getStringValue() {
            this.assertType(MapBuffer.DataType.STRING);
            return ReadableMapBuffer.this.readStringValue(this.bucketOffset + 4);
        }

        @Override
        @NotNull
        public MapBuffer getMapBufferValue() {
            this.assertType(MapBuffer.DataType.MAP);
            return ReadableMapBuffer.this.readMapBufferValue(this.bucketOffset + 4);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer$Companion;", "", "()V", "ALIGNMENT", "", "BUCKET_SIZE", "HEADER_SIZE", "TYPE_OFFSET", "VALUE_OFFSET", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MapBuffer.DataType.values().length];
            nArray[MapBuffer.DataType.BOOL.ordinal()] = 1;
            nArray[MapBuffer.DataType.INT.ordinal()] = 2;
            nArray[MapBuffer.DataType.DOUBLE.ordinal()] = 3;
            nArray[MapBuffer.DataType.STRING.ordinal()] = 4;
            nArray[MapBuffer.DataType.MAP.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

