/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.support.v4.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.views.scroll.ScrollEventType;
import javax.annotation.Nullable;

public class ScrollEvent
extends Event<ScrollEvent> {
    private static final Pools.SynchronizedPool<ScrollEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);
    private int mScrollX;
    private int mScrollY;
    private int mContentWidth;
    private int mContentHeight;
    private int mScrollViewWidth;
    private int mScrollViewHeight;
    @Nullable
    private ScrollEventType mScrollEventType;

    public static ScrollEvent obtain(int viewTag, ScrollEventType scrollEventType, int scrollX, int scrollY, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        ScrollEvent event = (ScrollEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new ScrollEvent();
        }
        event.init(viewTag, scrollEventType, scrollX, scrollY, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
        return event;
    }

    @Override
    public void onDispose() {
        EVENTS_POOL.release((Object)this);
    }

    private ScrollEvent() {
    }

    private void init(int viewTag, ScrollEventType scrollEventType, int scrollX, int scrollY, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        super.init(viewTag);
        this.mScrollEventType = scrollEventType;
        this.mScrollX = scrollX;
        this.mScrollY = scrollY;
        this.mContentWidth = contentWidth;
        this.mContentHeight = contentHeight;
        this.mScrollViewWidth = scrollViewWidth;
        this.mScrollViewHeight = scrollViewHeight;
    }

    @Override
    public String getEventName() {
        return ((ScrollEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mScrollEventType)))).getJSEventName();
    }

    @Override
    public short getCoalescingKey() {
        return 0;
    }

    @Override
    public boolean canCoalesce() {
        return this.mScrollEventType == ScrollEventType.SCROLL;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        WritableMap contentInset = Arguments.createMap();
        contentInset.putDouble("top", 0.0);
        contentInset.putDouble("bottom", 0.0);
        contentInset.putDouble("left", 0.0);
        contentInset.putDouble("right", 0.0);
        WritableMap contentOffset = Arguments.createMap();
        contentOffset.putDouble("x", PixelUtil.toDIPFromPixel(this.mScrollX));
        contentOffset.putDouble("y", PixelUtil.toDIPFromPixel(this.mScrollY));
        WritableMap contentSize = Arguments.createMap();
        contentSize.putDouble("width", PixelUtil.toDIPFromPixel(this.mContentWidth));
        contentSize.putDouble("height", PixelUtil.toDIPFromPixel(this.mContentHeight));
        WritableMap layoutMeasurement = Arguments.createMap();
        layoutMeasurement.putDouble("width", PixelUtil.toDIPFromPixel(this.mScrollViewWidth));
        layoutMeasurement.putDouble("height", PixelUtil.toDIPFromPixel(this.mScrollViewHeight));
        WritableMap event = Arguments.createMap();
        event.putMap("contentInset", contentInset);
        event.putMap("contentOffset", contentOffset);
        event.putMap("contentSize", contentSize);
        event.putMap("layoutMeasurement", layoutMeasurement);
        event.putInt("target", this.getViewTag());
        event.putBoolean("responderIgnoreScroll", true);
        return event;
    }
}

