/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.flat.AbstractDrawCommand;
import com.facebook.react.flat.DrawImage;
import com.facebook.react.flat.DraweeRequestHelper;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.imagehelper.ImageSource;
import com.facebook.react.views.imagehelper.MultiSourceHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

final class DrawImageWithDrawee
extends AbstractDrawCommand
implements DrawImage,
ControllerListener {
    private static final String LOCAL_FILE_SCHEME = "file";
    private static final String LOCAL_CONTENT_SCHEME = "content";
    private final List<ImageSource> mSources = new LinkedList<ImageSource>();
    @Nullable
    private DraweeRequestHelper mRequestHelper;
    @Nullable
    private PorterDuffColorFilter mColorFilter;
    private ScalingUtils.ScaleType mScaleType = ImageResizeMode.defaultValue();
    private float mBorderWidth;
    private float mBorderRadius;
    private int mBorderColor;
    private int mReactTag;
    private boolean mProgressiveRenderingEnabled;
    private int mFadeDuration = 300;
    @Nullable
    private FlatViewGroup.InvalidateCallback mCallback;

    DrawImageWithDrawee() {
    }

    @Override
    public boolean hasImageRequest() {
        return !this.mSources.isEmpty();
    }

    @Override
    public void setSource(Context context, @Nullable ReadableArray sources) {
        this.mSources.clear();
        if (sources != null && sources.size() != 0) {
            if (sources.size() == 1) {
                ReadableMap source = sources.getMap(0);
                this.mSources.add(new ImageSource(context, source.getString("uri")));
            } else {
                for (int idx = 0; idx < sources.size(); ++idx) {
                    ReadableMap source = sources.getMap(idx);
                    this.mSources.add(new ImageSource(context, source.getString("uri"), source.getDouble("width"), source.getDouble("height")));
                }
            }
        }
    }

    @Override
    public void setTintColor(int tintColor) {
        this.mColorFilter = tintColor == 0 ? null : new PorterDuffColorFilter(tintColor, PorterDuff.Mode.SRC_ATOP);
    }

    @Override
    public void setScaleType(ScalingUtils.ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    @Override
    public ScalingUtils.ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    @Override
    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public void setBorderRadius(float borderRadius) {
        this.mBorderRadius = borderRadius;
    }

    @Override
    public float getBorderRadius() {
        return this.mBorderRadius;
    }

    @Override
    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    @Override
    public int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public void setFadeDuration(int fadeDuration) {
        this.mFadeDuration = fadeDuration;
    }

    @Override
    public void setProgressiveRenderingEnabled(boolean enabled) {
        this.mProgressiveRenderingEnabled = enabled;
    }

    @Override
    public void setReactTag(int reactTag) {
        this.mReactTag = reactTag;
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (this.mRequestHelper != null) {
            this.mRequestHelper.getDrawable().draw(canvas);
        }
    }

    @Override
    public void onAttached(FlatViewGroup.InvalidateCallback callback) {
        this.mCallback = callback;
        if (this.mRequestHelper == null) {
            throw new RuntimeException("No DraweeRequestHelper - width: " + (this.getRight() - this.getLeft()) + " - height: " + (this.getBottom() - this.getTop()) + " - number of sources: " + this.mSources.size());
        }
        GenericDraweeHierarchy hierarchy = this.mRequestHelper.getHierarchy();
        RoundingParams roundingParams = hierarchy.getRoundingParams();
        if (this.shouldDisplayBorder()) {
            if (roundingParams == null) {
                roundingParams = new RoundingParams();
            }
            roundingParams.setBorder(this.mBorderColor, this.mBorderWidth);
            roundingParams.setCornersRadius(this.mBorderRadius);
            hierarchy.setRoundingParams(roundingParams);
        } else if (roundingParams != null) {
            hierarchy.setRoundingParams(null);
        }
        hierarchy.setActualImageScaleType(this.mScaleType);
        hierarchy.setActualImageColorFilter((ColorFilter)this.mColorFilter);
        hierarchy.setFadeDuration(this.mFadeDuration);
        hierarchy.getTopLevelDrawable().setBounds(Math.round(this.getLeft()), Math.round(this.getTop()), Math.round(this.getRight()), Math.round(this.getBottom()));
        this.mRequestHelper.attach(callback);
    }

    @Override
    public void onDetached() {
        if (this.mRequestHelper != null) {
            this.mRequestHelper.detach();
        }
    }

    public void onSubmit(String id2, Object callerContext) {
        if (this.mCallback != null && this.mReactTag != 0) {
            this.mCallback.dispatchImageLoadEvent(this.mReactTag, 4);
        }
    }

    public void onFinalImageSet(String id2, @Nullable Object imageInfo, @Nullable Animatable animatable) {
        if (this.mCallback != null && this.mReactTag != 0) {
            this.mCallback.dispatchImageLoadEvent(this.mReactTag, 2);
            this.mCallback.dispatchImageLoadEvent(this.mReactTag, 3);
        }
    }

    public void onIntermediateImageSet(String id2, @Nullable Object imageInfo) {
    }

    public void onIntermediateImageFailed(String id2, Throwable throwable) {
    }

    public void onFailure(String id2, Throwable throwable) {
        if (this.mCallback != null && this.mReactTag != 0) {
            this.mCallback.dispatchImageLoadEvent(this.mReactTag, 1);
            this.mCallback.dispatchImageLoadEvent(this.mReactTag, 3);
        }
    }

    public void onRelease(String id2) {
    }

    @Override
    protected void onBoundsChanged() {
        super.onBoundsChanged();
        this.computeRequestHelper();
    }

    private void computeRequestHelper() {
        MultiSourceHelper.MultiSourceResult multiSource = MultiSourceHelper.getBestSourceForSize(Math.round(this.getRight() - this.getLeft()), Math.round(this.getBottom() - this.getTop()), this.mSources);
        ImageSource source = multiSource.getBestResult();
        ImageSource cachedSource = multiSource.getBestResultInCache();
        if (source == null) {
            this.mRequestHelper = null;
            return;
        }
        ResizeOptions resizeOptions = null;
        if (DrawImageWithDrawee.shouldResize(source)) {
            int width = (int)(this.getRight() - this.getLeft());
            int height = (int)(this.getBottom() - this.getTop());
            resizeOptions = new ResizeOptions(width, height);
        }
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)source.getUri()).setResizeOptions(resizeOptions).setProgressiveRenderingEnabled(this.mProgressiveRenderingEnabled).build();
        ImageRequest cachedImageRequest = null;
        if (cachedSource != null) {
            cachedImageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)cachedSource.getUri()).setResizeOptions(resizeOptions).setProgressiveRenderingEnabled(this.mProgressiveRenderingEnabled).build();
        }
        this.mRequestHelper = new DraweeRequestHelper((ImageRequest)Assertions.assertNotNull((Object)imageRequest), cachedImageRequest, this);
    }

    private boolean shouldDisplayBorder() {
        return this.mBorderColor != 0 || this.mBorderRadius >= 0.5f;
    }

    private static boolean shouldResize(ImageSource imageSource) {
        Uri uri = imageSource.getUri();
        String type = uri == null ? null : uri.getScheme();
        return LOCAL_FILE_SCHEME.equals(type) || LOCAL_CONTENT_SCHEME.equals(type);
    }

    @Override
    protected void onDebugDrawHighlight(Canvas canvas) {
        if (this.mCallback != null) {
            this.debugDrawCautionHighlight(canvas, "Invalidate Drawee");
        }
    }
}

