/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.webview;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.facebook.catalyst.views.webview.events.TopLoadingErrorEvent;
import com.facebook.catalyst.views.webview.events.TopLoadingFinishEvent;
import com.facebook.catalyst.views.webview.events.TopLoadingStartEvent;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.webview.WebViewConfig;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactWebViewManager
extends SimpleViewManager<WebView> {
    private static final String REACT_CLASS = "RCTWebView";
    private static final String HTML_ENCODING = "UTF-8";
    private static final String HTML_MIME_TYPE = "text/html; charset=utf-8";
    public static final int COMMAND_GO_BACK = 1;
    public static final int COMMAND_GO_FORWARD = 2;
    public static final int COMMAND_RELOAD = 3;
    private static final String BLANK_URL = "about:blank";
    private WebViewConfig mWebViewConfig;

    public ReactWebViewManager() {
        this.mWebViewConfig = new WebViewConfig(){

            @Override
            public void configWebView(WebView webView) {
            }
        };
    }

    public ReactWebViewManager(WebViewConfig webViewConfig) {
        this.mWebViewConfig = webViewConfig;
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected WebView createViewInstance(ThemedReactContext reactContext) {
        ReactWebView webView = new ReactWebView(reactContext);
        reactContext.addLifecycleEventListener(webView);
        this.mWebViewConfig.configWebView(webView);
        return webView;
    }

    @ReactProp(name="javaScriptEnabledAndroid")
    public void setJavaScriptEnabled(WebView view, boolean enabled) {
        view.getSettings().setJavaScriptEnabled(enabled);
    }

    @ReactProp(name="domStorageEnabledAndroid")
    public void setDomStorageEnabled(WebView view, boolean enabled) {
        view.getSettings().setDomStorageEnabled(enabled);
    }

    @ReactProp(name="userAgent")
    public void setUserAgent(WebView view, @Nullable String userAgent) {
        if (userAgent != null) {
            view.getSettings().setUserAgentString(userAgent);
        }
    }

    @ReactProp(name="injectedJavaScript")
    public void setInjectedJavaScript(WebView view, @Nullable String injectedJavaScript) {
        ((ReactWebView)view).setInjectedJavaScript(injectedJavaScript);
    }

    @ReactProp(name="html")
    public void setHtml(WebView view, @Nullable String html) {
        if (html != null) {
            view.loadData(html, HTML_MIME_TYPE, HTML_ENCODING);
        } else {
            view.loadUrl(BLANK_URL);
        }
    }

    @ReactProp(name="url")
    public void setUrl(WebView view, @Nullable String url) {
        if (url != null) {
            view.loadUrl(url);
        } else {
            view.loadUrl(BLANK_URL);
        }
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, WebView view) {
        view.setWebViewClient((WebViewClient)new ReactWebViewClient());
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("goBack", 1, "goForward", 2, "reload", 3);
    }

    @Override
    public void receiveCommand(WebView root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                root.goBack();
                break;
            }
            case 2: {
                root.goForward();
                break;
            }
            case 3: {
                root.reload();
            }
        }
    }

    @Override
    public void onDropViewInstance(ThemedReactContext reactContext, WebView webView) {
        super.onDropViewInstance(reactContext, webView);
        reactContext.removeLifecycleEventListener((ReactWebView)webView);
        ((ReactWebView)webView).cleanupCallbacksAndDestroy();
    }

    private static class ReactWebView
    extends WebView
    implements LifecycleEventListener {
        @Nullable
        private String injectedJS;

        public ReactWebView(ThemedReactContext reactContext) {
            super((Context)reactContext);
        }

        @Override
        public void onHostResume() {
        }

        @Override
        public void onHostPause() {
        }

        @Override
        public void onHostDestroy() {
            this.cleanupCallbacksAndDestroy();
        }

        public void setInjectedJavaScript(@Nullable String js) {
            this.injectedJS = js;
        }

        public void callInjectedJavaScript() {
            if (this.getSettings().getJavaScriptEnabled() && this.injectedJS != null && !TextUtils.isEmpty((CharSequence)this.injectedJS)) {
                this.loadUrl("javascript:(function() {\n" + this.injectedJS + ";\n})();");
            }
        }

        private void cleanupCallbacksAndDestroy() {
            this.setWebViewClient(null);
            this.destroy();
        }
    }

    private static class ReactWebViewClient
    extends WebViewClient {
        private boolean mLastLoadFailed = false;

        private ReactWebViewClient() {
        }

        public void onPageFinished(WebView webView, String url) {
            super.onPageFinished(webView, url);
            if (!this.mLastLoadFailed) {
                ReactWebView reactWebView = (ReactWebView)webView;
                reactWebView.callInjectedJavaScript();
                this.emitFinishEvent(webView, url);
            }
        }

        public void onPageStarted(WebView webView, String url, Bitmap favicon) {
            super.onPageStarted(webView, url, favicon);
            this.mLastLoadFailed = false;
            ReactContext reactContext = (ReactContext)((ReactWebView)webView).getContext();
            EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            eventDispatcher.dispatchEvent(new TopLoadingStartEvent(webView.getId(), SystemClock.uptimeMillis(), this.createWebViewEvent(webView, url)));
        }

        public void onReceivedError(WebView webView, int errorCode, String description, String failingUrl) {
            super.onReceivedError(webView, errorCode, description, failingUrl);
            this.mLastLoadFailed = true;
            this.emitFinishEvent(webView, failingUrl);
            ReactContext reactContext = (ReactContext)((ReactWebView)webView).getContext();
            WritableMap eventData = this.createWebViewEvent(webView, failingUrl);
            eventData.putDouble("code", errorCode);
            eventData.putString("description", description);
            EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            eventDispatcher.dispatchEvent(new TopLoadingErrorEvent(webView.getId(), SystemClock.uptimeMillis(), eventData));
        }

        public void doUpdateVisitedHistory(WebView webView, String url, boolean isReload) {
            super.doUpdateVisitedHistory(webView, url, isReload);
            ReactContext reactContext = (ReactContext)webView.getContext();
            EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            eventDispatcher.dispatchEvent(new TopLoadingStartEvent(webView.getId(), SystemClock.uptimeMillis(), this.createWebViewEvent(webView, url)));
        }

        private void emitFinishEvent(WebView webView, String url) {
            ReactContext reactContext = (ReactContext)webView.getContext();
            EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            eventDispatcher.dispatchEvent(new TopLoadingFinishEvent(webView.getId(), SystemClock.uptimeMillis(), this.createWebViewEvent(webView, url)));
        }

        private WritableMap createWebViewEvent(WebView webView, String url) {
            WritableMap event = Arguments.createMap();
            event.putDouble("target", webView.getId());
            event.putString("url", url);
            event.putBoolean("loading", !this.mLastLoadFailed && webView.getProgress() != 100);
            event.putString("title", webView.getTitle());
            event.putBoolean("canGoBack", webView.canGoBack());
            event.putBoolean("canGoForward", webView.canGoForward());
            return event;
        }
    }
}

