/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import com.facebook.react.R;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.toolbar.ReactToolbar;
import com.facebook.react.views.toolbar.events.ToolbarClickEvent;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactToolbarManager
extends ViewGroupManager<ReactToolbar> {
    private static final String REACT_CLASS = "ToolbarAndroid";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ReactToolbar createViewInstance(ThemedReactContext reactContext) {
        return new ReactToolbar((Context)reactContext);
    }

    @ReactProp(name="logo")
    public void setLogo(ReactToolbar view, @Nullable ReadableMap logo) {
        view.setLogoSource(logo);
    }

    @ReactProp(name="navIcon")
    public void setNavIcon(ReactToolbar view, @Nullable ReadableMap navIcon) {
        view.setNavIconSource(navIcon);
    }

    @ReactProp(name="overflowIcon")
    public void setOverflowIcon(ReactToolbar view, @Nullable ReadableMap overflowIcon) {
        view.setOverflowIconSource(overflowIcon);
    }

    @ReactProp(name="rtl")
    public void setRtl(ReactToolbar view, boolean rtl) {
        view.setLayoutDirection(rtl ? 0 : 1);
    }

    @ReactProp(name="subtitle")
    public void setSubtitle(ReactToolbar view, @Nullable String subtitle) {
        view.setSubtitle(subtitle);
    }

    @ReactProp(name="subtitleColor", customType="Color")
    public void setSubtitleColor(ReactToolbar view, @Nullable Integer subtitleColor) {
        int[] defaultColors = ReactToolbarManager.getDefaultColors(view.getContext());
        if (subtitleColor != null) {
            view.setSubtitleTextColor(subtitleColor);
        } else {
            view.setSubtitleTextColor(defaultColors[1]);
        }
    }

    @ReactProp(name="title")
    public void setTitle(ReactToolbar view, @Nullable String title) {
        view.setTitle(title);
    }

    @ReactProp(name="titleColor", customType="Color")
    public void setTitleColor(ReactToolbar view, @Nullable Integer titleColor) {
        int[] defaultColors = ReactToolbarManager.getDefaultColors(view.getContext());
        if (titleColor != null) {
            view.setTitleTextColor(titleColor);
        } else {
            view.setTitleTextColor(defaultColors[0]);
        }
    }

    @ReactProp(name="contentInsetStart", defaultFloat=NaNf)
    public void setContentInsetStart(ReactToolbar view, float insetStart) {
        int inset = Float.isNaN(insetStart) ? this.getDefaultContentInsets(view.getContext())[0] : Math.round(PixelUtil.toPixelFromDIP(insetStart));
        view.setContentInsetsRelative(inset, view.getContentInsetEnd());
    }

    @ReactProp(name="contentInsetEnd", defaultFloat=NaNf)
    public void setContentInsetEnd(ReactToolbar view, float insetEnd) {
        int inset = Float.isNaN(insetEnd) ? this.getDefaultContentInsets(view.getContext())[1] : Math.round(PixelUtil.toPixelFromDIP(insetEnd));
        view.setContentInsetsRelative(view.getContentInsetStart(), inset);
    }

    @ReactProp(name="nativeActions")
    public void setActions(ReactToolbar view, @Nullable ReadableArray actions) {
        view.setActions(actions);
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, final ReactToolbar view) {
        final EventDispatcher mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        view.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                mEventDispatcher.dispatchEvent(new ToolbarClickEvent(view.getId(), SystemClock.uptimeMillis(), -1));
            }
        });
        view.setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                mEventDispatcher.dispatchEvent(new ToolbarClickEvent(view.getId(), SystemClock.uptimeMillis(), menuItem.getOrder()));
                return true;
            }
        });
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.of("ShowAsAction", MapBuilder.of("never", 0, "always", 2, "ifRoom", 1));
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getDefaultContentInsets(Context context) {
        int[] nArray;
        Resources.Theme theme = context.getTheme();
        TypedArray toolbarStyle = null;
        TypedArray contentInsets = null;
        try {
            toolbarStyle = theme.obtainStyledAttributes(new int[]{R.attr.toolbarStyle});
            int toolbarStyleResId = toolbarStyle.getResourceId(0, 0);
            contentInsets = theme.obtainStyledAttributes(toolbarStyleResId, new int[]{R.attr.contentInsetStart, R.attr.contentInsetEnd});
            int contentInsetStart = contentInsets.getDimensionPixelSize(0, 0);
            int contentInsetEnd = contentInsets.getDimensionPixelSize(1, 0);
            nArray = new int[]{contentInsetStart, contentInsetEnd};
        }
        catch (Throwable throwable) {
            ReactToolbarManager.recycleQuietly(toolbarStyle);
            ReactToolbarManager.recycleQuietly(contentInsets);
            throw throwable;
        }
        ReactToolbarManager.recycleQuietly(toolbarStyle);
        ReactToolbarManager.recycleQuietly(contentInsets);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getDefaultColors(Context context) {
        int[] nArray;
        Resources.Theme theme = context.getTheme();
        TypedArray toolbarStyle = null;
        TypedArray textAppearances = null;
        TypedArray titleTextAppearance = null;
        TypedArray subtitleTextAppearance = null;
        try {
            toolbarStyle = theme.obtainStyledAttributes(new int[]{R.attr.toolbarStyle});
            int toolbarStyleResId = toolbarStyle.getResourceId(0, 0);
            textAppearances = theme.obtainStyledAttributes(toolbarStyleResId, new int[]{R.attr.titleTextAppearance, R.attr.subtitleTextAppearance});
            int titleTextAppearanceResId = textAppearances.getResourceId(0, 0);
            int subtitleTextAppearanceResId = textAppearances.getResourceId(1, 0);
            titleTextAppearance = theme.obtainStyledAttributes(titleTextAppearanceResId, new int[]{16842904});
            subtitleTextAppearance = theme.obtainStyledAttributes(subtitleTextAppearanceResId, new int[]{16842904});
            int titleTextColor = titleTextAppearance.getColor(0, -16777216);
            int subtitleTextColor = subtitleTextAppearance.getColor(0, -16777216);
            nArray = new int[]{titleTextColor, subtitleTextColor};
        }
        catch (Throwable throwable) {
            ReactToolbarManager.recycleQuietly(toolbarStyle);
            ReactToolbarManager.recycleQuietly(textAppearances);
            ReactToolbarManager.recycleQuietly(titleTextAppearance);
            ReactToolbarManager.recycleQuietly(subtitleTextAppearance);
            throw throwable;
        }
        ReactToolbarManager.recycleQuietly(toolbarStyle);
        ReactToolbarManager.recycleQuietly(textAppearances);
        ReactToolbarManager.recycleQuietly(titleTextAppearance);
        ReactToolbarManager.recycleQuietly(subtitleTextAppearance);
        return nArray;
    }

    private static void recycleQuietly(@Nullable TypedArray style2) {
        if (style2 != null) {
            style2.recycle();
        }
    }
}

