/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.util.LongSparseArray;
import android.view.Choreographer;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ReactChoreographer;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;

public class EventDispatcher
implements LifecycleEventListener {
    private static final Comparator<Event> EVENT_COMPARATOR = new Comparator<Event>(){

        @Override
        public int compare(Event lhs, Event rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            long diff = lhs.getTimestampMs() - rhs.getTimestampMs();
            if (diff == 0L) {
                return 0;
            }
            if (diff < 0L) {
                return -1;
            }
            return 1;
        }
    };
    private final Object mEventsStagingLock = new Object();
    private final Object mEventsToDispatchLock = new Object();
    private final ReactApplicationContext mReactContext;
    private final LongSparseArray<Integer> mEventCookieToLastEventIdx = new LongSparseArray();
    private final Map<String, Short> mEventNameToEventId = MapBuilder.newHashMap();
    private final DispatchEventsRunnable mDispatchEventsRunnable = new DispatchEventsRunnable();
    private final ArrayList<Event> mEventStaging = new ArrayList();
    private Event[] mEventsToDispatch = new Event[16];
    private int mEventsToDispatchSize = 0;
    @Nullable
    private RCTEventEmitter mRCTEventEmitter;
    @Nullable
    private volatile ScheduleDispatchFrameCallback mCurrentFrameCallback;
    private short mNextEventTypeId = 0;
    private volatile boolean mHasDispatchScheduled = false;

    public EventDispatcher(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
        this.mReactContext.addLifecycleEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(Event event) {
        Assertions.assertCondition((boolean)event.isInitialized(), (String)"Dispatched event hasn't been initialized");
        Object object = this.mEventsStagingLock;
        synchronized (object) {
            this.mEventStaging.add(event);
        }
    }

    @Override
    public void onHostResume() {
        UiThreadUtil.assertOnUiThread();
        Assertions.assumeCondition((this.mCurrentFrameCallback == null ? 1 : 0) != 0);
        if (this.mRCTEventEmitter == null) {
            this.mRCTEventEmitter = this.mReactContext.getJSModule(RCTEventEmitter.class);
        }
        this.mCurrentFrameCallback = new ScheduleDispatchFrameCallback();
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mCurrentFrameCallback);
    }

    @Override
    public void onHostPause() {
        this.clearFrameCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
    }

    public void onCatalystInstanceDestroyed() {
        this.clearFrameCallback();
    }

    private void clearFrameCallback() {
        UiThreadUtil.assertOnUiThread();
        if (this.mCurrentFrameCallback != null) {
            this.mCurrentFrameCallback.stop();
            this.mCurrentFrameCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveStagedEventsToDispatchQueue() {
        Object object = this.mEventsStagingLock;
        synchronized (object) {
            Object object2 = this.mEventsToDispatchLock;
            synchronized (object2) {
                for (int i = 0; i < this.mEventStaging.size(); ++i) {
                    Event event = this.mEventStaging.get(i);
                    if (!event.canCoalesce()) {
                        this.addEventToEventsToDispatch(event);
                        continue;
                    }
                    long eventCookie = this.getEventCookie(event.getViewTag(), event.getEventName(), event.getCoalescingKey());
                    Event eventToAdd = null;
                    Event eventToDispose = null;
                    Integer lastEventIdx = (Integer)this.mEventCookieToLastEventIdx.get(eventCookie);
                    if (lastEventIdx == null) {
                        eventToAdd = event;
                        this.mEventCookieToLastEventIdx.put(eventCookie, (Object)this.mEventsToDispatchSize);
                    } else {
                        Event lastEvent = this.mEventsToDispatch[lastEventIdx];
                        Event coalescedEvent = event.coalesce(lastEvent);
                        if (coalescedEvent != lastEvent) {
                            eventToAdd = coalescedEvent;
                            this.mEventCookieToLastEventIdx.put(eventCookie, (Object)this.mEventsToDispatchSize);
                            eventToDispose = lastEvent;
                            this.mEventsToDispatch[lastEventIdx.intValue()] = null;
                        } else {
                            eventToDispose = event;
                        }
                    }
                    if (eventToAdd != null) {
                        this.addEventToEventsToDispatch(eventToAdd);
                    }
                    if (eventToDispose == null) continue;
                    eventToDispose.dispose();
                }
            }
            this.mEventStaging.clear();
        }
    }

    private long getEventCookie(int viewTag, String eventName, short coalescingKey) {
        short eventTypeId;
        Short eventIdObj = this.mEventNameToEventId.get(eventName);
        if (eventIdObj != null) {
            eventTypeId = eventIdObj;
        } else {
            short s = this.mNextEventTypeId;
            this.mNextEventTypeId = (short)(s + 1);
            eventTypeId = s;
            this.mEventNameToEventId.put(eventName, eventTypeId);
        }
        return EventDispatcher.getEventCookie(viewTag, eventTypeId, coalescingKey);
    }

    private static long getEventCookie(int viewTag, short eventTypeId, short coalescingKey) {
        return (long)viewTag | ((long)eventTypeId & 0xFFFFL) << 32 | ((long)coalescingKey & 0xFFFFL) << 48;
    }

    private void addEventToEventsToDispatch(Event event) {
        if (this.mEventsToDispatchSize == this.mEventsToDispatch.length) {
            this.mEventsToDispatch = Arrays.copyOf(this.mEventsToDispatch, 2 * this.mEventsToDispatch.length);
        }
        this.mEventsToDispatch[this.mEventsToDispatchSize++] = event;
    }

    private void clearEventsToDispatch() {
        Arrays.fill(this.mEventsToDispatch, 0, this.mEventsToDispatchSize, null);
        this.mEventsToDispatchSize = 0;
    }

    private class DispatchEventsRunnable
    implements Runnable {
        private DispatchEventsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Systrace.beginSection(0L, "DispatchEventsRunnable");
            try {
                EventDispatcher.this.mHasDispatchScheduled = false;
                Assertions.assertNotNull((Object)EventDispatcher.this.mRCTEventEmitter);
                Object object = EventDispatcher.this.mEventsToDispatchLock;
                synchronized (object) {
                    if (EventDispatcher.this.mEventsToDispatchSize > 1) {
                        Arrays.sort(EventDispatcher.this.mEventsToDispatch, 0, EventDispatcher.this.mEventsToDispatchSize, EVENT_COMPARATOR);
                    }
                    for (int eventIdx = 0; eventIdx < EventDispatcher.this.mEventsToDispatchSize; ++eventIdx) {
                        Event event = EventDispatcher.this.mEventsToDispatch[eventIdx];
                        if (event == null) continue;
                        event.dispatch(EventDispatcher.this.mRCTEventEmitter);
                        event.dispose();
                    }
                    EventDispatcher.this.clearEventsToDispatch();
                    EventDispatcher.this.mEventCookieToLastEventIdx.clear();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    }

    private class ScheduleDispatchFrameCallback
    implements Choreographer.FrameCallback {
        private boolean mShouldStop = false;

        private ScheduleDispatchFrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            UiThreadUtil.assertOnUiThread();
            if (this.mShouldStop) {
                return;
            }
            Systrace.beginSection(0L, "ScheduleDispatchFrameCallback");
            try {
                EventDispatcher.this.moveStagedEventsToDispatchQueue();
                if (!EventDispatcher.this.mHasDispatchScheduled) {
                    EventDispatcher.this.mHasDispatchScheduled = true;
                    EventDispatcher.this.mReactContext.runOnJSQueueThread(EventDispatcher.this.mDispatchEventsRunnable);
                }
                ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        public void stop() {
            this.mShouldStop = true;
        }
    }
}

