/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.cache.disk.DiskCacheConfig;
import com.facebook.common.internal.AndroidPredicates;
import com.facebook.common.soloader.SoLoaderShim;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.soloader.SoLoader;
import com.squareup.okhttp.OkHttpClient;
import java.util.HashSet;

public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable {
    @Nullable
    private RequestListener mRequestListener;
    @Nullable
    private DiskCacheConfig mDiskCacheConfig;

    public FrescoModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public FrescoModule(ReactApplicationContext reactContext, RequestListener listener) {
        super(reactContext);
        this.mRequestListener = listener;
    }

    public FrescoModule(ReactApplicationContext reactContext, RequestListener listener, DiskCacheConfig diskCacheConfig) {
        super(reactContext);
        this.mRequestListener = listener;
        this.mDiskCacheConfig = diskCacheConfig;
    }

    @Override
    public void initialize() {
        super.initialize();
        SoLoaderShim.setHandler((SoLoaderShim.Handler)new SoLoaderShim.Handler(){

            public void loadLibrary(String libraryName) {
                SoLoader.loadLibrary(libraryName);
            }
        });
        HashSet<RequestListener> requestListeners = new HashSet<RequestListener>();
        requestListeners.add(new SystraceRequestListener());
        if (this.mRequestListener != null) {
            requestListeners.add(this.mRequestListener);
        }
        Context context = this.getReactApplicationContext().getApplicationContext();
        OkHttpClient okHttpClient = OkHttpClientProvider.getCookieAwareOkHttpClient(this.getReactApplicationContext());
        ImagePipelineConfig.Builder builder = OkHttpImagePipelineConfigFactory.newBuilder((Context)context, (OkHttpClient)okHttpClient);
        builder.setDownsampleEnabled(false).setRequestListeners(requestListeners);
        if (this.mDiskCacheConfig != null) {
            builder.setMainDiskCacheConfig(this.mDiskCacheConfig);
        }
        ImagePipelineConfig config = builder.build();
        Fresco.initialize((Context)context, (ImagePipelineConfig)config);
    }

    @Override
    public String getName() {
        return "FrescoModule";
    }

    @Override
    public void clearSensitiveData() {
        ImagePipelineFactory imagePipelineFactory = Fresco.getImagePipelineFactory();
        imagePipelineFactory.getBitmapMemoryCache().removeAll(AndroidPredicates.True());
        imagePipelineFactory.getEncodedMemoryCache().removeAll(AndroidPredicates.True());
        imagePipelineFactory.getMainDiskStorageCache().clearAll();
        imagePipelineFactory.getSmallImageDiskStorageCache().clearAll();
    }
}

