/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.futures;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class SimpleSettableFuture<T> {
    private final CountDownLatch mReadyLatch = new CountDownLatch(1);
    @Nullable
    private volatile T mResult;

    public void set(T result) {
        if (this.mReadyLatch.getCount() == 0L) {
            throw new RuntimeException("Result has already been set!");
        }
        this.mResult = result;
        this.mReadyLatch.countDown();
    }

    @Nullable
    public T get(long timeoutMS) {
        try {
            if (!this.mReadyLatch.await(timeoutMS, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.mResult;
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException() {
            super("Timed out waiting for future");
        }
    }
}

