/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistration;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaScriptModulesConfig {
    private final List<JavaScriptModuleRegistration> mModules;

    private JavaScriptModulesConfig(List<JavaScriptModuleRegistration> modules) {
        this.mModules = modules;
    }

    List<JavaScriptModuleRegistration> getModuleDefinitions() {
        return this.mModules;
    }

    String moduleDescriptions() {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jg = jsonFactory.createGenerator((Writer)writer);
            jg.writeStartObject();
            for (JavaScriptModuleRegistration registration : this.mModules) {
                jg.writeObjectFieldStart(registration.getName());
                this.appendJSModuleToJSONObject(jg, registration);
                jg.writeEndObject();
            }
            jg.writeEndObject();
            jg.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize JavaScript module declaration", ioe);
        }
        return writer.getBuffer().toString();
    }

    private void appendJSModuleToJSONObject(JsonGenerator jg, JavaScriptModuleRegistration registration) throws IOException {
        jg.writeObjectField("moduleID", (Object)registration.getModuleId());
        jg.writeObjectFieldStart("methods");
        for (Method method : registration.getMethods()) {
            jg.writeObjectFieldStart(method.getName());
            jg.writeObjectField("methodID", (Object)registration.getMethodId(method));
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }

    public static class Builder {
        private int mLastJSModuleId = 0;
        private List<JavaScriptModuleRegistration> mModules = new ArrayList<JavaScriptModuleRegistration>();

        public Builder add(Class<? extends JavaScriptModule> moduleInterfaceClass) {
            int moduleId = this.mLastJSModuleId++;
            this.mModules.add(new JavaScriptModuleRegistration(moduleId, moduleInterfaceClass));
            return this;
        }

        public JavaScriptModulesConfig build() {
            return new JavaScriptModulesConfig(this.mModules);
        }
    }
}

