/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSLayout;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSStyle;
import com.facebook.csslayout.CSSWrap;
import com.facebook.csslayout.CachedCSSLayout;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.LayoutEngine;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.csslayout.Spacing;
import com.facebook.infer.annotation.Assertions;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class CSSNode {
    final CSSStyle style = new CSSStyle();
    final CSSLayout layout = new CSSLayout();
    final CachedCSSLayout lastLayout = new CachedCSSLayout();
    public int lineIndex = 0;
    CSSNode nextAbsoluteChild;
    CSSNode nextFlexChild;
    @Nullable
    private ArrayList<CSSNode> mChildren;
    @Nullable
    private CSSNode mParent;
    @Nullable
    private MeasureFunction mMeasureFunction = null;
    private LayoutState mLayoutState = LayoutState.DIRTY;

    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public CSSNode getChildAt(int i) {
        Assertions.assertNotNull(this.mChildren);
        return this.mChildren.get(i);
    }

    public void addChildAt(CSSNode child, int i) {
        if (child.mParent != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList(4);
        }
        this.mChildren.add(i, child);
        child.mParent = this;
        this.dirty();
    }

    public CSSNode removeChildAt(int i) {
        Assertions.assertNotNull(this.mChildren);
        CSSNode removed = this.mChildren.remove(i);
        removed.mParent = null;
        this.dirty();
        return removed;
    }

    @Nullable
    public CSSNode getParent() {
        return this.mParent;
    }

    public int indexOf(CSSNode child) {
        Assertions.assertNotNull(this.mChildren);
        return this.mChildren.indexOf(child);
    }

    public void setMeasureFunction(MeasureFunction measureFunction) {
        if (this.mMeasureFunction != measureFunction) {
            this.mMeasureFunction = measureFunction;
            this.dirty();
        }
    }

    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    MeasureOutput measure(MeasureOutput measureOutput, float width) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        measureOutput.height = Float.NaN;
        measureOutput.width = Float.NaN;
        ((MeasureFunction)Assertions.assertNotNull((Object)this.mMeasureFunction)).measure(this, width, measureOutput);
        return measureOutput;
    }

    public void calculateLayout(CSSLayoutContext layoutContext) {
        this.layout.resetResult();
        LayoutEngine.layoutNode(layoutContext, this, Float.NaN, null);
    }

    protected boolean isDirty() {
        return this.mLayoutState == LayoutState.DIRTY;
    }

    public boolean hasNewLayout() {
        return this.mLayoutState == LayoutState.HAS_NEW_LAYOUT;
    }

    protected void dirty() {
        if (this.mLayoutState == LayoutState.DIRTY) {
            return;
        }
        if (this.mLayoutState == LayoutState.HAS_NEW_LAYOUT) {
            throw new IllegalStateException("Previous layout was ignored! markLayoutSeen() never called");
        }
        this.mLayoutState = LayoutState.DIRTY;
        if (this.mParent != null) {
            this.mParent.dirty();
        }
    }

    void markHasNewLayout() {
        this.mLayoutState = LayoutState.HAS_NEW_LAYOUT;
    }

    public void markLayoutSeen() {
        if (!this.hasNewLayout()) {
            throw new IllegalStateException("Expected node to have a new layout to be seen!");
        }
        this.mLayoutState = LayoutState.UP_TO_DATE;
    }

    private void toStringWithIndentation(StringBuilder result, int level) {
        int i;
        StringBuilder indentation = new StringBuilder();
        for (i = 0; i < level; ++i) {
            indentation.append("__");
        }
        result.append(indentation.toString());
        result.append(this.layout.toString());
        if (this.getChildCount() == 0) {
            return;
        }
        result.append(", children: [\n");
        for (i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).toStringWithIndentation(result, level + 1);
            result.append("\n");
        }
        result.append(indentation + "]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringWithIndentation(sb, 0);
        return sb.toString();
    }

    protected boolean valuesEqual(float f1, float f2) {
        return FloatUtil.floatsEqual(f1, f2);
    }

    public CSSDirection getStyleDirection() {
        return this.style.direction;
    }

    public void setDirection(CSSDirection direction) {
        if (this.style.direction != direction) {
            this.style.direction = direction;
            this.dirty();
        }
    }

    public CSSFlexDirection getFlexDirection() {
        return this.style.flexDirection;
    }

    public void setFlexDirection(CSSFlexDirection flexDirection) {
        if (this.style.flexDirection != flexDirection) {
            this.style.flexDirection = flexDirection;
            this.dirty();
        }
    }

    public CSSJustify getJustifyContent() {
        return this.style.justifyContent;
    }

    public void setJustifyContent(CSSJustify justifyContent) {
        if (this.style.justifyContent != justifyContent) {
            this.style.justifyContent = justifyContent;
            this.dirty();
        }
    }

    public CSSAlign getAlignItems() {
        return this.style.alignItems;
    }

    public void setAlignItems(CSSAlign alignItems) {
        if (this.style.alignItems != alignItems) {
            this.style.alignItems = alignItems;
            this.dirty();
        }
    }

    public CSSAlign getAlignSelf() {
        return this.style.alignSelf;
    }

    public void setAlignSelf(CSSAlign alignSelf) {
        if (this.style.alignSelf != alignSelf) {
            this.style.alignSelf = alignSelf;
            this.dirty();
        }
    }

    public CSSPositionType getPositionType() {
        return this.style.positionType;
    }

    public void setPositionType(CSSPositionType positionType) {
        if (this.style.positionType != positionType) {
            this.style.positionType = positionType;
            this.dirty();
        }
    }

    public void setWrap(CSSWrap flexWrap) {
        if (this.style.flexWrap != flexWrap) {
            this.style.flexWrap = flexWrap;
            this.dirty();
        }
    }

    public float getFlex() {
        return this.style.flex;
    }

    public void setFlex(float flex) {
        if (!this.valuesEqual(this.style.flex, flex)) {
            this.style.flex = flex;
            this.dirty();
        }
    }

    public Spacing getMargin() {
        return this.style.margin;
    }

    public void setMargin(int spacingType, float margin) {
        if (this.style.margin.set(spacingType, margin)) {
            this.dirty();
        }
    }

    public Spacing getPadding() {
        return this.style.padding;
    }

    public void setPadding(int spacingType, float padding) {
        if (this.style.padding.set(spacingType, padding)) {
            this.dirty();
        }
    }

    public Spacing getBorder() {
        return this.style.border;
    }

    public void setBorder(int spacingType, float border) {
        if (this.style.border.set(spacingType, border)) {
            this.dirty();
        }
    }

    public float getPositionTop() {
        return this.style.position[1];
    }

    public void setPositionTop(float positionTop) {
        if (!this.valuesEqual(this.style.position[1], positionTop)) {
            this.style.position[1] = positionTop;
            this.dirty();
        }
    }

    public float getPositionBottom() {
        return this.style.position[3];
    }

    public void setPositionBottom(float positionBottom) {
        if (!this.valuesEqual(this.style.position[3], positionBottom)) {
            this.style.position[3] = positionBottom;
            this.dirty();
        }
    }

    public float getPositionLeft() {
        return this.style.position[0];
    }

    public void setPositionLeft(float positionLeft) {
        if (!this.valuesEqual(this.style.position[0], positionLeft)) {
            this.style.position[0] = positionLeft;
            this.dirty();
        }
    }

    public float getPositionRight() {
        return this.style.position[2];
    }

    public void setPositionRight(float positionRight) {
        if (!this.valuesEqual(this.style.position[2], positionRight)) {
            this.style.position[2] = positionRight;
            this.dirty();
        }
    }

    public float getStyleWidth() {
        return this.style.dimensions[0];
    }

    public void setStyleWidth(float width) {
        if (!this.valuesEqual(this.style.dimensions[0], width)) {
            this.style.dimensions[0] = width;
            this.dirty();
        }
    }

    public float getStyleHeight() {
        return this.style.dimensions[1];
    }

    public void setStyleHeight(float height) {
        if (!this.valuesEqual(this.style.dimensions[1], height)) {
            this.style.dimensions[1] = height;
            this.dirty();
        }
    }

    public float getLayoutX() {
        return this.layout.position[0];
    }

    public float getLayoutY() {
        return this.layout.position[1];
    }

    public float getLayoutWidth() {
        return this.layout.dimensions[0];
    }

    public float getLayoutHeight() {
        return this.layout.dimensions[1];
    }

    public CSSDirection getLayoutDirection() {
        return this.layout.direction;
    }

    public void setDefaultPadding(int spacingType, float padding) {
        if (this.style.padding.setDefault(spacingType, padding)) {
            this.dirty();
        }
    }

    public void reset() {
        if (this.mParent != null || this.mChildren != null && this.mChildren.size() > 0) {
            throw new IllegalStateException("You should not reset an attached CSSNode");
        }
        this.style.reset();
        this.layout.resetResult();
        this.lineIndex = 0;
        this.mLayoutState = LayoutState.DIRTY;
    }

    public static interface MeasureFunction {
        public void measure(CSSNode var1, float var2, MeasureOutput var3);
    }

    private static enum LayoutState {
        DIRTY,
        HAS_NEW_LAYOUT,
        UP_TO_DATE;

    }
}

