/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.TouchEventType;

class TouchesHelper {
    private static final String PAGE_X_KEY = "pageX";
    private static final String PAGE_Y_KEY = "pageY";
    private static final String TARGET_KEY = "target";
    private static final String TIMESTAMP_KEY = "timeStamp";
    private static final String POINTER_IDENTIFIER_KEY = "identifier";
    private static final String LOCATION_X_KEY = "locationX";
    private static final String LOCATION_Y_KEY = "locationY";

    TouchesHelper() {
    }

    private static WritableArray createsPointersArray(int reactTarget, MotionEvent event) {
        WritableArray touches = Arguments.createArray();
        float offsetX = event.getRawX() - event.getX();
        float offsetY = event.getRawY() - event.getY();
        for (int index = 0; index < event.getPointerCount(); ++index) {
            WritableMap touch = Arguments.createMap();
            touch.putDouble(PAGE_X_KEY, PixelUtil.toDIPFromPixel(event.getX(index) + offsetX));
            touch.putDouble(PAGE_Y_KEY, PixelUtil.toDIPFromPixel(event.getY(index) + offsetY));
            touch.putDouble(LOCATION_X_KEY, PixelUtil.toDIPFromPixel(event.getX(index)));
            touch.putDouble(LOCATION_Y_KEY, PixelUtil.toDIPFromPixel(event.getY(index)));
            touch.putInt(TARGET_KEY, reactTarget);
            touch.putDouble(TIMESTAMP_KEY, event.getEventTime());
            touch.putDouble(POINTER_IDENTIFIER_KEY, event.getPointerId(index));
            touches.pushMap(touch);
        }
        return touches;
    }

    public static void sendTouchEvent(RCTEventEmitter rctEventEmitter, TouchEventType type, int reactTarget, MotionEvent androidMotionEvent) {
        WritableArray pointers = TouchesHelper.createsPointersArray(reactTarget, androidMotionEvent);
        WritableArray changedIndices = Arguments.createArray();
        if (type == TouchEventType.MOVE || type == TouchEventType.CANCEL) {
            for (int i = 0; i < androidMotionEvent.getPointerCount(); ++i) {
                changedIndices.pushInt(i);
            }
        } else if (type == TouchEventType.START || type == TouchEventType.END) {
            changedIndices.pushInt(androidMotionEvent.getActionIndex());
        } else {
            throw new RuntimeException("Unknown touch type: " + (Object)((Object)type));
        }
        rctEventEmitter.receiveTouches(type.getJSEventName(), pointers, changedIndices);
    }
}

