/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.switchviewview;

import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import android.widget.CompoundButton;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.views.switchviewview.ReactSwitch;
import com.facebook.react.views.switchviewview.ReactSwitchEvent;

public class ReactSwitchManager
extends SimpleViewManager<ReactSwitch> {
    private static final String REACT_CLASS = "AndroidSwitch";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_ENABLED = "enabled";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_ON = "on";
    private static final CompoundButton.OnCheckedChangeListener ON_CHECKED_CHANGE_LISTENER = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            ReactContext reactContext = (ReactContext)buttonView.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactSwitchEvent(buttonView.getId(), SystemClock.uptimeMillis(), isChecked));
        }
    };

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    public ReactShadowNode createCSSNodeInstance() {
        return new ReactSwitchShadowNode();
    }

    @Override
    protected ReactSwitch createViewInstance(ThemedReactContext context) {
        ReactSwitch view = new ReactSwitch((Context)context);
        view.setShowText(false);
        return view;
    }

    public void updateView(ReactSwitch view, CatalystStylesDiffMap props) {
        super.updateView((View)view, props);
        if (props.hasKey(PROP_ENABLED)) {
            view.setEnabled(props.getBoolean(PROP_ENABLED, true));
        }
        if (props.hasKey(PROP_ON)) {
            view.setOnCheckedChangeListener(null);
            view.setOn(props.getBoolean(PROP_ON, false));
            view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
        }
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactSwitch view) {
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    private static class ReactSwitchShadowNode
    extends ReactShadowNode
    implements CSSNode.MeasureFunction {
        private int mWidth;
        private int mHeight;
        private boolean mMeasured;

        private ReactSwitchShadowNode() {
            this.setMeasureFunction(this);
        }

        @Override
        public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
            if (!this.mMeasured) {
                ReactSwitch reactSwitch = new ReactSwitch((Context)this.getThemedContext());
                int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
                reactSwitch.measure(spec, spec);
                this.mWidth = reactSwitch.getMeasuredWidth();
                this.mHeight = reactSwitch.getMeasuredHeight();
                this.mMeasured = true;
            }
            measureOutput.width = this.mWidth;
            measureOutput.height = this.mHeight;
        }
    }
}

