/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public class ScrollEvent
extends Event<ScrollEvent> {
    public static final String EVENT_NAME = "topScroll";
    private final int mScrollX;
    private final int mScrollY;
    private final int mContentWidth;
    private final int mContentHeight;
    private final int mScrollViewWidth;
    private final int mScrollViewHeight;

    public ScrollEvent(int viewTag, long timestampMs, int scrollX, int scrollY, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        super(viewTag, timestampMs);
        this.mScrollX = scrollX;
        this.mScrollY = scrollY;
        this.mContentWidth = contentWidth;
        this.mContentHeight = contentHeight;
        this.mScrollViewWidth = scrollViewWidth;
        this.mScrollViewHeight = scrollViewHeight;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public short getCoalescingKey() {
        return 0;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        WritableMap contentInset = Arguments.createMap();
        contentInset.putDouble("top", 0.0);
        contentInset.putDouble("bottom", 0.0);
        contentInset.putDouble("left", 0.0);
        contentInset.putDouble("right", 0.0);
        WritableMap contentOffset = Arguments.createMap();
        contentOffset.putDouble("x", PixelUtil.toDIPFromPixel(this.mScrollX));
        contentOffset.putDouble("y", PixelUtil.toDIPFromPixel(this.mScrollY));
        WritableMap contentSize = Arguments.createMap();
        contentSize.putDouble("width", PixelUtil.toDIPFromPixel(this.mContentWidth));
        contentSize.putDouble("height", PixelUtil.toDIPFromPixel(this.mContentHeight));
        WritableMap layoutMeasurement = Arguments.createMap();
        layoutMeasurement.putDouble("width", PixelUtil.toDIPFromPixel(this.mScrollViewWidth));
        layoutMeasurement.putDouble("height", PixelUtil.toDIPFromPixel(this.mScrollViewHeight));
        WritableMap event = Arguments.createMap();
        event.putMap("contentInset", contentInset);
        event.putMap("contentOffset", contentOffset);
        event.putMap("contentSize", contentSize);
        event.putMap("layoutMeasurement", layoutMeasurement);
        event.putInt("target", this.getViewTag());
        event.putBoolean("responderIgnoreScroll", true);
        return event;
    }
}

