/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ReactPropGroup;
import com.facebook.react.uimanager.ViewManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class ViewManagersPropertyCache {
    private static final Map<Class, Map<String, PropSetter>> CLASS_PROPS_CACHE = new HashMap<Class, Map<String, PropSetter>>();
    private static final Map<String, PropSetter> EMPTY_PROPS_MAP = new HashMap<String, PropSetter>();

    ViewManagersPropertyCache() {
    }

    static Map<String, String> getNativePropsForClass(Class<? extends ViewManager> topLevelClass) {
        HashMap<String, String> nativeProps = new HashMap<String, String>();
        Map<String, PropSetter> props = ViewManagersPropertyCache.getNativePropSettersForClass(topLevelClass);
        for (PropSetter setter : props.values()) {
            nativeProps.put(setter.getPropName(), setter.getPropType());
        }
        return nativeProps;
    }

    static Map<String, PropSetter> getNativePropSettersForClass(Class<? extends ViewManager> cls) {
        if (cls == ViewManager.class) {
            return EMPTY_PROPS_MAP;
        }
        Map<String, PropSetter> props = CLASS_PROPS_CACHE.get(cls);
        if (props != null) {
            return props;
        }
        props = new HashMap<String, PropSetter>(ViewManagersPropertyCache.getNativePropSettersForClass(cls.getSuperclass()));
        for (Method method : cls.getDeclaredMethods()) {
            int i;
            Class<?> propTypeClass;
            Class<?>[] paramTypes;
            Annotation annotation = method.getAnnotation(ReactProp.class);
            if (annotation != null) {
                PropSetter propSetter;
                paramTypes = method.getParameterTypes();
                if (paramTypes.length != 2) {
                    throw new RuntimeException("Wrong number of args for prop setter: " + cls.getName() + "#" + method.getName());
                }
                if (!View.class.isAssignableFrom(paramTypes[0])) {
                    throw new RuntimeException("First param should be a view subclass to be updated: " + cls.getName() + "#" + method.getName());
                }
                propTypeClass = paramTypes[1];
                if (propTypeClass == Boolean.TYPE) {
                    propSetter = new BooleanPropSetter((ReactProp)annotation, method, annotation.defaultBoolean());
                } else if (propTypeClass == Integer.TYPE) {
                    propSetter = new IntPropSetter((ReactProp)annotation, method, annotation.defaultInt());
                } else if (propTypeClass == Float.TYPE) {
                    propSetter = new FloatPropSetter((ReactProp)annotation, method, annotation.defaultFloat());
                } else if (propTypeClass == Double.TYPE) {
                    propSetter = new DoublePropSetter((ReactProp)annotation, method, annotation.defaultDouble());
                } else if (propTypeClass == String.class) {
                    propSetter = new StringPropSetter((ReactProp)annotation, method);
                } else if (propTypeClass == Boolean.class) {
                    propSetter = new BoxedBooleanPropSetter((ReactProp)annotation, method);
                } else if (propTypeClass == Integer.class) {
                    propSetter = new BoxedIntPropSetter((ReactProp)annotation, method);
                } else if (propTypeClass == ReadableArray.class) {
                    propSetter = new ArrayPropSetter((ReactProp)annotation, method);
                } else if (propTypeClass == ReadableMap.class) {
                    propSetter = new MapPropSetter((ReactProp)annotation, method);
                } else {
                    throw new RuntimeException("Unrecognized type");
                }
                props.put(annotation.name(), propSetter);
            }
            if ((annotation = method.getAnnotation(ReactPropGroup.class)) == null) continue;
            paramTypes = method.getParameterTypes();
            if (paramTypes.length != 3) {
                throw new RuntimeException("Wrong number of args for group prop setter: " + cls.getName() + "#" + method.getName());
            }
            if (!View.class.isAssignableFrom(paramTypes[0])) {
                throw new RuntimeException("First param should be a view subclass to be updated: " + cls.getName() + "#" + method.getName());
            }
            if (paramTypes[1] != Integer.TYPE) {
                throw new RuntimeException("Second argument should be property index: " + cls.getName() + "#" + method.getName());
            }
            propTypeClass = paramTypes[2];
            String[] names = annotation.names();
            if (propTypeClass == Integer.TYPE) {
                for (i = 0; i < names.length; ++i) {
                    props.put(names[i], new GroupIntSetter((ReactPropGroup)annotation, method, i, annotation.defaultInt()));
                }
                continue;
            }
            if (propTypeClass == Float.TYPE) {
                for (i = 0; i < names.length; ++i) {
                    props.put(names[i], new GroupFloatSetter((ReactPropGroup)annotation, method, i, annotation.defaultFloat()));
                }
                continue;
            }
            if (propTypeClass == Integer.class) {
                for (i = 0; i < names.length; ++i) {
                    props.put(names[i], new GroupBoxedIntSetter((ReactPropGroup)annotation, method, i));
                }
                continue;
            }
            throw new RuntimeException("Unrecognized type: " + paramTypes[2] + " for method: " + cls.getName() + "#" + method.getName());
        }
        CLASS_PROPS_CACHE.put(cls, props);
        return props;
    }

    private static class GroupBoxedIntSetter
    extends GroupSetter {
        protected GroupBoxedIntSetter(ReactPropGroup prop, Method setter, int index) {
            super(prop, "number", setter, index);
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, this.mIndex, props.isNull(this.mPropName) ? null : Integer.valueOf(props.getInt(this.mPropName, 0)));
        }
    }

    private static class GroupFloatSetter
    extends GroupSetter {
        private final float mDefaultValue;

        public GroupFloatSetter(ReactPropGroup prop, Method setter, int index, float defaultValue) {
            super(prop, "number", setter, index);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, this.mIndex, Float.valueOf(props.getFloat(this.mPropName, this.mDefaultValue)));
        }
    }

    private static class GroupIntSetter
    extends GroupSetter {
        private final int mDefaultValue;

        public GroupIntSetter(ReactPropGroup prop, Method setter, int index, int defaultValue) {
            super(prop, "number", setter, index);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, this.mIndex, props.getInt(this.mPropName, this.mDefaultValue));
        }
    }

    private static abstract class GroupSetter
    extends PropSetter {
        protected final int mIndex;

        protected GroupSetter(ReactPropGroup prop, String defaultType, Method setter, int index) {
            super(prop, defaultType, setter, index);
            this.mIndex = index;
        }
    }

    private static class BoxedIntPropSetter
    extends PropSetter {
        public BoxedIntPropSetter(ReactProp prop, Method setter) {
            super(prop, "number", setter);
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            Integer value = null;
            if (!props.isNull(this.mPropName)) {
                value = props.getInt(this.mPropName, 0);
            }
            this.mSetter.invoke((Object)viewManager, viewToUpdate, value);
        }
    }

    private static class BoxedBooleanPropSetter
    extends PropSetter {
        public BoxedBooleanPropSetter(ReactProp prop, Method setter) {
            super(prop, "boolean", setter);
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            Boolean value = null;
            if (!props.isNull(this.mPropName)) {
                value = props.getBoolean(this.mPropName, false) ? Boolean.TRUE : Boolean.FALSE;
            }
            this.mSetter.invoke((Object)viewManager, viewToUpdate, value);
        }
    }

    private static class StringPropSetter
    extends PropSetter {
        public StringPropSetter(ReactProp prop, Method setter) {
            super(prop, "String", setter);
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, props.getString(this.mPropName));
        }
    }

    private static class MapPropSetter
    extends PropSetter {
        public MapPropSetter(ReactProp prop, Method setter) {
            super(prop, "Map", setter);
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, props.getMap(this.mPropName));
        }
    }

    private static class ArrayPropSetter
    extends PropSetter {
        public ArrayPropSetter(ReactProp prop, Method setter) {
            super(prop, "Array", setter);
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, props.getArray(this.mPropName));
        }
    }

    private static class FloatPropSetter
    extends PropSetter {
        private final float mDefaultValue;

        public FloatPropSetter(ReactProp prop, Method setter, float defaultValue) {
            super(prop, "number", setter);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, Float.valueOf(props.getFloat(this.mPropName, this.mDefaultValue)));
        }
    }

    private static class BooleanPropSetter
    extends PropSetter {
        private final boolean mDefaultValue;

        public BooleanPropSetter(ReactProp prop, Method setter, boolean defaultValue) {
            super(prop, "boolean", setter);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, props.getBoolean(this.mPropName, this.mDefaultValue));
        }
    }

    private static class DoublePropSetter
    extends PropSetter {
        private final double mDefaultValue;

        public DoublePropSetter(ReactProp prop, Method setter, double defaultValue) {
            super(prop, "number", setter);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, props.getDouble(this.mPropName, this.mDefaultValue));
        }
    }

    private static class IntPropSetter
    extends PropSetter {
        private final int mDefaultValue;

        public IntPropSetter(ReactProp prop, Method setter, int defaultValue) {
            super(prop, "number", setter);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected void updateProperty(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) throws InvocationTargetException, IllegalAccessException {
            this.mSetter.invoke((Object)viewManager, viewToUpdate, props.getInt(this.mPropName, this.mDefaultValue));
        }
    }

    static abstract class PropSetter {
        protected final String mPropName;
        protected final String mPropType;
        protected final Method mSetter;

        private PropSetter(ReactProp prop, String defaultType, Method setter) {
            this.mPropName = prop.name();
            this.mPropType = "__default_type__".equals(prop.customType()) ? defaultType : prop.customType();
            this.mSetter = setter;
        }

        private PropSetter(ReactPropGroup prop, String defaultType, Method setter, int index) {
            this.mPropName = prop.names()[index];
            this.mPropType = "__default_type__".equals(prop.customType()) ? defaultType : prop.customType();
            this.mSetter = setter;
        }

        public String getPropName() {
            return this.mPropName;
        }

        public String getPropType() {
            return this.mPropType;
        }

        public void updateProp(ViewManager viewManager, View viewToUpdate, CatalystStylesDiffMap props) {
            try {
                this.updateProperty(viewManager, viewToUpdate, props);
            }
            catch (Throwable t) {
                FLog.e(ViewManager.class, (String)("Error while updating prop " + this.mPropName), (Throwable)t);
                throw new JSApplicationIllegalArgumentException("Error while updating property '" + this.mPropName + "' of a view managed by: " + viewManager.getName(), t);
            }
        }

        protected abstract void updateProperty(ViewManager var1, View var2, CatalystStylesDiffMap var3) throws InvocationTargetException, IllegalAccessException;
    }
}

