/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.csslayout.CSSNode;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.BaseCSSPropertyApplicator;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ReactShadowNode
extends CSSNode {
    private int mReactTag;
    @Nullable
    private String mViewClassName;
    @Nullable
    private ReactShadowNode mRootNode;
    @Nullable
    private ThemedReactContext mThemedContext;
    private boolean mShouldNotifyOnLayout;
    private boolean mNodeUpdated = true;
    private boolean mIsLayoutOnly;
    private int mTotalNativeChildren = 0;
    @Nullable
    private ReactShadowNode mNativeParent;
    @Nullable
    private ArrayList<ReactShadowNode> mNativeChildren;
    private float mAbsoluteLeft;
    private float mAbsoluteTop;
    private float mAbsoluteRight;
    private float mAbsoluteBottom;

    public boolean isVirtual() {
        return false;
    }

    public boolean isVirtualAnchor() {
        return false;
    }

    public final String getViewClass() {
        return (String)Assertions.assertNotNull((Object)this.mViewClassName);
    }

    public final boolean hasUpdates() {
        return this.mNodeUpdated || this.hasNewLayout() || this.isDirty();
    }

    public final void markUpdateSeen() {
        this.mNodeUpdated = false;
        if (this.hasNewLayout()) {
            this.markLayoutSeen();
        }
    }

    protected void markUpdated() {
        if (this.mNodeUpdated) {
            return;
        }
        this.mNodeUpdated = true;
        ReactShadowNode parent = this.getParent();
        if (parent != null) {
            parent.markUpdated();
        }
    }

    @Override
    protected void dirty() {
        if (!this.isVirtual()) {
            super.dirty();
        }
    }

    @Override
    public void addChildAt(CSSNode child, int i) {
        super.addChildAt(child, i);
        this.markUpdated();
        ReactShadowNode node = (ReactShadowNode)child;
        int increase = node.mIsLayoutOnly ? node.mTotalNativeChildren : 1;
        this.mTotalNativeChildren += increase;
        if (this.mIsLayoutOnly) {
            for (ReactShadowNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
                parent.mTotalNativeChildren += increase;
                if (!parent.mIsLayoutOnly) break;
            }
        }
    }

    @Override
    public ReactShadowNode removeChildAt(int i) {
        ReactShadowNode removed = (ReactShadowNode)super.removeChildAt(i);
        this.markUpdated();
        int decrease = removed.mIsLayoutOnly ? removed.mTotalNativeChildren : 1;
        this.mTotalNativeChildren -= decrease;
        if (this.mIsLayoutOnly) {
            for (ReactShadowNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
                parent.mTotalNativeChildren -= decrease;
                if (!parent.mIsLayoutOnly) break;
            }
        }
        return removed;
    }

    public void onBeforeLayout() {
    }

    public void updateProperties(CatalystStylesDiffMap styles) {
        BaseCSSPropertyApplicator.applyCSSProperties(this, styles);
    }

    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
    }

    void dispatchUpdates(float absoluteX, float absoluteY, UIViewOperationQueue uiViewOperationQueue, NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        if (this.mNodeUpdated) {
            this.onCollectExtraUpdates(uiViewOperationQueue);
        }
        if (this.hasNewLayout()) {
            this.mAbsoluteLeft = Math.round(absoluteX + this.getLayoutX());
            this.mAbsoluteTop = Math.round(absoluteY + this.getLayoutY());
            this.mAbsoluteRight = Math.round(absoluteX + this.getLayoutX() + this.getLayoutWidth());
            this.mAbsoluteBottom = Math.round(absoluteY + this.getLayoutY() + this.getLayoutHeight());
            nativeViewHierarchyOptimizer.handleUpdateLayout(this);
        }
    }

    public final int getReactTag() {
        return this.mReactTag;
    }

    final void setReactTag(int reactTag) {
        this.mReactTag = reactTag;
    }

    public final ReactShadowNode getRootNode() {
        return (ReactShadowNode)Assertions.assertNotNull((Object)this.mRootNode);
    }

    final void setRootNode(ReactShadowNode rootNode) {
        this.mRootNode = rootNode;
    }

    final void setViewClassName(String viewClassName) {
        this.mViewClassName = viewClassName;
    }

    @Override
    public final ReactShadowNode getChildAt(int i) {
        return (ReactShadowNode)super.getChildAt(i);
    }

    @Override
    @Nullable
    public final ReactShadowNode getParent() {
        return (ReactShadowNode)super.getParent();
    }

    public ThemedReactContext getThemedContext() {
        return (ThemedReactContext)((Object)Assertions.assertNotNull((Object)((Object)this.mThemedContext)));
    }

    protected void setThemedContext(ThemedReactContext themedContext) {
        this.mThemedContext = themedContext;
    }

    void setShouldNotifyOnLayout(boolean shouldNotifyOnLayout) {
        this.mShouldNotifyOnLayout = shouldNotifyOnLayout;
    }

    boolean shouldNotifyOnLayout() {
        return this.mShouldNotifyOnLayout;
    }

    public void addNativeChildAt(ReactShadowNode child, int nativeIndex) {
        Assertions.assertCondition((!this.mIsLayoutOnly ? 1 : 0) != 0);
        Assertions.assertCondition((!child.mIsLayoutOnly ? 1 : 0) != 0);
        if (this.mNativeChildren == null) {
            this.mNativeChildren = new ArrayList(4);
        }
        this.mNativeChildren.add(nativeIndex, child);
        child.mNativeParent = this;
    }

    public ReactShadowNode removeNativeChildAt(int i) {
        Assertions.assertNotNull(this.mNativeChildren);
        ReactShadowNode removed = this.mNativeChildren.remove(i);
        removed.mNativeParent = null;
        return removed;
    }

    public int getNativeChildCount() {
        return this.mNativeChildren == null ? 0 : this.mNativeChildren.size();
    }

    public int indexOfNativeChild(ReactShadowNode nativeChild) {
        Assertions.assertNotNull(this.mNativeChildren);
        return this.mNativeChildren.indexOf(nativeChild);
    }

    @Nullable
    public ReactShadowNode getNativeParent() {
        return this.mNativeParent;
    }

    public void setIsLayoutOnly(boolean isLayoutOnly) {
        Assertions.assertCondition((this.getParent() == null ? 1 : 0) != 0, (String)"Must remove from no opt parent first");
        Assertions.assertCondition((this.mNativeParent == null ? 1 : 0) != 0, (String)"Must remove from native parent first");
        Assertions.assertCondition((this.getNativeChildCount() == 0 ? 1 : 0) != 0, (String)"Must remove all native children first");
        this.mIsLayoutOnly = isLayoutOnly;
    }

    public boolean isLayoutOnly() {
        return this.mIsLayoutOnly;
    }

    public int getTotalNativeChildren() {
        return this.mTotalNativeChildren;
    }

    public int getNativeOffsetForChild(ReactShadowNode child) {
        int index = 0;
        boolean found = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ReactShadowNode current = this.getChildAt(i);
            if (child == current) {
                found = true;
                break;
            }
            index += current.mIsLayoutOnly ? current.getTotalNativeChildren() : 1;
        }
        if (!found) {
            throw new RuntimeException("Child " + child.mReactTag + " was not a child of " + this.mReactTag);
        }
        return index;
    }

    public int getScreenX() {
        return Math.round(this.getLayoutX());
    }

    public int getScreenY() {
        return Math.round(this.getLayoutY());
    }

    public int getScreenWidth() {
        return Math.round(this.mAbsoluteRight - this.mAbsoluteLeft);
    }

    public int getScreenHeight() {
        return Math.round(this.mAbsoluteBottom - this.mAbsoluteTop);
    }
}

