/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.react.uimanager.CSSColorUtil;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.image.ReactImageView;
import javax.annotation.Nullable;

public class ReactImageManager
extends SimpleViewManager<ReactImageView> {
    public static final String REACT_CLASS = "RCTImageView";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_SRC = "src";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_BORDER_RADIUS = "borderRadius";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_RESIZE_MODE = "resizeMode";
    private static final String PROP_TINT_COLOR = "tintColor";
    @Nullable
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    @Nullable
    private final Object mCallerContext;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    public ReactImageManager(AbstractDraweeControllerBuilder draweeControllerBuilder, Object callerContext) {
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mCallerContext = callerContext;
    }

    public ReactImageManager() {
        this.mDraweeControllerBuilder = null;
        this.mCallerContext = null;
    }

    @Override
    public ReactImageView createViewInstance(ThemedReactContext context) {
        return new ReactImageView((Context)context, (AbstractDraweeControllerBuilder)(this.mDraweeControllerBuilder == null ? Fresco.newDraweeControllerBuilder() : this.mDraweeControllerBuilder), this.mCallerContext);
    }

    @Override
    public void updateView(ReactImageView view, CatalystStylesDiffMap props) {
        super.updateView(view, props);
        if (props.hasKey(PROP_RESIZE_MODE)) {
            view.setScaleType(ImageResizeMode.toScaleType(props.getString(PROP_RESIZE_MODE)));
        }
        if (props.hasKey(PROP_SRC)) {
            view.setSource(props.getString(PROP_SRC));
        }
        if (props.hasKey(PROP_BORDER_RADIUS)) {
            view.setBorderRadius(props.getFloat(PROP_BORDER_RADIUS, 0.0f));
        }
        if (props.hasKey(PROP_TINT_COLOR)) {
            String tintColorString = props.getString(PROP_TINT_COLOR);
            if (tintColorString == null) {
                view.clearColorFilter();
            } else {
                view.setColorFilter(CSSColorUtil.getColor(tintColorString));
            }
        }
        view.maybeUpdateView();
    }
}

