/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.drawer;

import android.content.Context;
import android.support.v4.widget.DrawerLayout;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.NativeGestureUtil;

class ReactDrawerLayout
extends DrawerLayout {
    public static final int DEFAULT_DRAWER_WIDTH = -1;
    private int mDrawerPosition = 0x800003;
    private int mDrawerWidth = -1;

    public ReactDrawerLayout(ReactContext reactContext) {
        super((Context)reactContext);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            return true;
        }
        return false;
    }

    void openDrawer() {
        this.openDrawer(this.mDrawerPosition);
    }

    void closeDrawer() {
        this.closeDrawer(this.mDrawerPosition);
    }

    void setDrawerPosition(int drawerPosition) {
        this.mDrawerPosition = drawerPosition;
        this.setDrawerProperties();
    }

    void setDrawerWidth(int drawerWidth) {
        this.mDrawerWidth = (int)PixelUtil.toPixelFromDIP(drawerWidth);
        this.setDrawerProperties();
    }

    void setDrawerProperties() {
        if (this.getChildCount() == 2) {
            View drawerView = this.getChildAt(1);
            DrawerLayout.LayoutParams layoutParams = (DrawerLayout.LayoutParams)drawerView.getLayoutParams();
            layoutParams.gravity = this.mDrawerPosition;
            layoutParams.width = this.mDrawerWidth;
            drawerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            drawerView.setClickable(true);
        }
    }
}

