/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.LifecycleState;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSCJavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptModulesConfig;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.CatalystQueueConfigurationSpec;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.AppRegistry;
import com.facebook.react.uimanager.ReactNative;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.soloader.SoLoader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ReactInstanceManager {
    private final List<ReactRootView> mAttachedRootViews = new ArrayList<ReactRootView>();
    private LifecycleState mLifecycleState;
    @Nullable
    private final String mBundleAssetName;
    @Nullable
    private final String mJSMainModuleName;
    private final List<ReactPackage> mPackages;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    private final ReactInstanceDevCommandsHandler mDevInterface = new ReactInstanceDevCommandsHandler(){

        @Override
        public void onReloadWithJSDebugger(ProxyJavaScriptExecutor proxyExecutor) {
            ReactInstanceManager.this.onReloadWithJSDebugger(proxyExecutor);
        }

        @Override
        public void onJSBundleLoadedFromServer() {
            ReactInstanceManager.this.onJSBundleLoadedFromServer();
        }

        @Override
        public void toggleElementInspector() {
            ReactInstanceManager.this.toggleElementInspector();
        }
    };
    private final DefaultHardwareBackBtnHandler mBackBtnHandler = new DefaultHardwareBackBtnHandler(){

        @Override
        public void invokeDefaultOnBackPressed() {
            ReactInstanceManager.this.invokeDefaultOnBackPressed();
        }
    };

    private ReactInstanceManager(Context applicationContext, @Nullable String bundleAssetName, @Nullable String jsMainModuleName, List<ReactPackage> packages, boolean useDeveloperSupport, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState) {
        ReactInstanceManager.initializeSoLoaderIfNecessary(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mBundleAssetName = bundleAssetName;
        this.mJSMainModuleName = jsMainModuleName;
        this.mPackages = packages;
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mDevSupportManager = new DevSupportManager(applicationContext, this.mDevInterface, this.mJSMainModuleName, useDeveloperSupport);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
    }

    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init(applicationContext, false);
    }

    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"React", (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)))).getNativeModule(DeviceEventManagerModule.class);
            deviceEventManagerModule.emitHardwareBackPressed();
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    private void toggleElementInspector() {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
        }
    }

    public void onPause() {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onPause();
        }
    }

    public void onResume(DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.RESUMED;
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(true);
        }
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onResume();
        }
    }

    public void onDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onDestroy();
        }
    }

    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    void attachMeasuredRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        this.mAttachedRootViews.add(rootView);
        if (this.mCurrentReactContext == null) {
            this.initializeReactContext();
        } else {
            this.attachMeasuredRootViewToInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    void detachRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        if (this.mAttachedRootViews.remove(rootView) && this.mCurrentReactContext != null && this.mCurrentReactContext.hasActiveCatalystInstance()) {
            this.detachViewFromInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    List<ViewManager> createAllViewManagers(ReactApplicationContext catalystApplicationContext) {
        ArrayList<ViewManager> allViewManagers = new ArrayList<ViewManager>();
        for (ReactPackage reactPackage : this.mPackages) {
            allViewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
        }
        return allViewManagers;
    }

    @Nullable
    @VisibleForTesting
    public ReactContext getCurrentReactContext() {
        return this.mCurrentReactContext;
    }

    private void onReloadWithJSDebugger(ProxyJavaScriptExecutor proxyExecutor) {
        this.recreateReactContext(proxyExecutor, JSBundleLoader.createRemoteDebuggerBundleLoader(this.mDevSupportManager.getJSBundleURLForRemoteDebugging()));
    }

    private void onJSBundleLoadedFromServer() {
        this.recreateReactContext(new JSCJavaScriptExecutor(), JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile()));
    }

    private void initializeReactContext() {
        if (this.mUseDeveloperSupport) {
            if (this.mDevSupportManager.hasUpToDateJSBundleInCache()) {
                this.onJSBundleLoadedFromServer();
                return;
            }
            if (this.mBundleAssetName == null || !this.mDevSupportManager.hasBundleInAssets(this.mBundleAssetName)) {
                this.mDevSupportManager.handleReloadJS();
                return;
            }
        }
        this.recreateReactContext(new JSCJavaScriptExecutor(), JSBundleLoader.createAssetLoader(this.mApplicationContext.getAssets(), this.mBundleAssetName));
    }

    private void recreateReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        UiThreadUtil.assertOnUiThread();
        if (this.mCurrentReactContext != null) {
            this.tearDownReactContext(this.mCurrentReactContext);
        }
        this.mCurrentReactContext = this.createReactContext(jsExecutor, jsBundleLoader);
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.attachMeasuredRootViewToInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    private void attachMeasuredRootViewToInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        rootView.removeAllViews();
        rootView.setId(-1);
        UIManagerModule uiManagerModule = catalystInstance.getNativeModule(UIManagerModule.class);
        int rootTag = uiManagerModule.addMeasuredRootView(rootView);
        Bundle launchOptions = rootView.getLaunchOptions();
        WritableMap initialProps = launchOptions != null ? Arguments.fromBundle(launchOptions) : Arguments.createMap();
        String jsAppModuleName = rootView.getJSModuleName();
        WritableNativeMap appParams = new WritableNativeMap();
        appParams.putDouble("rootTag", rootTag);
        appParams.putMap("initialProps", initialProps);
        catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
    }

    private void detachViewFromInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        catalystInstance.getJSModule(ReactNative.class).unmountComponentAtNodeAndRemoveContainer(rootView.getId());
    }

    private void tearDownReactContext(ReactContext reactContext) {
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onPause();
        }
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.detachViewFromInstance(rootView, reactContext.getCatalystInstance());
        }
        reactContext.onDestroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
    }

    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        NativeModuleRegistry.Builder nativeRegistryBuilder = new NativeModuleRegistry.Builder();
        JavaScriptModulesConfig.Builder jsModulesBuilder = new JavaScriptModulesConfig.Builder();
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        if (this.mUseDeveloperSupport) {
            reactContext.setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        }
        CoreModulesPackage coreModulesPackage = new CoreModulesPackage(this, this.mBackBtnHandler);
        this.processPackage(coreModulesPackage, reactContext, nativeRegistryBuilder, jsModulesBuilder);
        for (ReactPackage reactPackage : this.mPackages) {
            this.processPackage(reactPackage, reactContext, nativeRegistryBuilder, jsModulesBuilder);
        }
        CatalystInstance.Builder catalystInstanceBuilder = new CatalystInstance.Builder().setCatalystQueueConfigurationSpec(CatalystQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeRegistryBuilder.build()).setJSModulesConfig(jsModulesBuilder.build()).setJSBundleLoader(jsBundleLoader).setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        CatalystInstance catalystInstance = catalystInstanceBuilder.build();
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        reactContext.initializeWithInstance(catalystInstance);
        catalystInstance.initialize();
        this.mDevSupportManager.onNewReactContextCreated(reactContext);
        this.moveReactContextToCurrentLifecycleState(reactContext);
        return reactContext;
    }

    private void processPackage(ReactPackage reactPackage, ReactApplicationContext reactContext, NativeModuleRegistry.Builder nativeRegistryBuilder, JavaScriptModulesConfig.Builder jsModulesBuilder) {
        for (NativeModule nativeModule : reactPackage.createNativeModules(reactContext)) {
            nativeRegistryBuilder.add(nativeModule);
        }
        for (Class clazz : reactPackage.createJSModules()) {
            jsModulesBuilder.add(clazz);
        }
    }

    private void moveReactContextToCurrentLifecycleState(ReactApplicationContext reactContext) {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onResume();
        }
    }

    public static class Builder {
        private final List<ReactPackage> mPackages = new ArrayList<ReactPackage>();
        @Nullable
        private String mBundleAssetName;
        @Nullable
        private String mJSMainModuleName;
        @Nullable
        private NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
        @Nullable
        private Application mApplication;
        private boolean mUseDeveloperSupport;
        @Nullable
        private LifecycleState mInitialLifecycleState;

        private Builder() {
        }

        public Builder setBundleAssetName(String bundleAssetName) {
            this.mBundleAssetName = bundleAssetName;
            return this;
        }

        public Builder setJSMainModuleName(String jsMainModuleName) {
            this.mJSMainModuleName = jsMainModuleName;
            return this;
        }

        public Builder addPackage(ReactPackage reactPackage) {
            this.mPackages.add(reactPackage);
            return this;
        }

        public Builder setBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener) {
            this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
            return this;
        }

        public Builder setApplication(Application application) {
            this.mApplication = application;
            return this;
        }

        public Builder setUseDeveloperSupport(boolean useDeveloperSupport) {
            this.mUseDeveloperSupport = useDeveloperSupport;
            return this;
        }

        public Builder setInitialLifecycleState(LifecycleState initialLifecycleState) {
            this.mInitialLifecycleState = initialLifecycleState;
            return this;
        }

        public ReactInstanceManager build() {
            Assertions.assertCondition((this.mUseDeveloperSupport || this.mBundleAssetName != null ? 1 : 0) != 0, (String)"JS Bundle has to be provided in app assets when dev support is disabled");
            Assertions.assertCondition((this.mBundleAssetName != null || this.mJSMainModuleName != null ? 1 : 0) != 0, (String)"Either BundleAssetName or MainModuleName needs to be provided");
            return new ReactInstanceManager((Context)Assertions.assertNotNull((Object)this.mApplication, (String)"Application property has not been set with this builder"), this.mBundleAssetName, this.mJSMainModuleName, this.mPackages, this.mUseDeveloperSupport, this.mBridgeIdleDebugListener, (LifecycleState)((Object)Assertions.assertNotNull((Object)((Object)this.mInitialLifecycleState), (String)"Initial lifecycle state was not set")));
        }
    }
}

