/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.FloatUtil;
import javax.annotation.Nullable;

public class Spacing {
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int VERTICAL = 4;
    public static final int HORIZONTAL = 5;
    public static final int START = 6;
    public static final int END = 7;
    public static final int ALL = 8;
    private final float[] mSpacing = Spacing.newFullSpacingArray();
    @Nullable
    private float[] mDefaultSpacing = null;

    public boolean set(int spacingType, float value) {
        if (!FloatUtil.floatsEqual(this.mSpacing[spacingType], value)) {
            this.mSpacing[spacingType] = value;
            return true;
        }
        return false;
    }

    public boolean setDefault(int spacingType, float value) {
        if (this.mDefaultSpacing == null) {
            this.mDefaultSpacing = Spacing.newSpacingResultArray();
        }
        if (!FloatUtil.floatsEqual(this.mDefaultSpacing[spacingType], value)) {
            this.mDefaultSpacing[spacingType] = value;
            return true;
        }
        return false;
    }

    public float get(int spacingType) {
        float defaultValue;
        int secondType = spacingType == 1 || spacingType == 3 ? 4 : 5;
        float f = defaultValue = spacingType == 6 || spacingType == 7 ? Float.NaN : 0.0f;
        return !CSSConstants.isUndefined(this.mSpacing[spacingType]) ? this.mSpacing[spacingType] : (!CSSConstants.isUndefined(this.mSpacing[secondType]) ? this.mSpacing[secondType] : (!CSSConstants.isUndefined(this.mSpacing[8]) ? this.mSpacing[8] : (this.mDefaultSpacing != null ? this.mDefaultSpacing[spacingType] : defaultValue)));
    }

    public float getRaw(int spacingType) {
        return this.mSpacing[spacingType];
    }

    private static float[] newFullSpacingArray() {
        return new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    }

    private static float[] newSpacingResultArray() {
        return Spacing.newSpacingResultArray(0.0f);
    }

    private static float[] newSpacingResultArray(float defaultValue) {
        return new float[]{defaultValue, defaultValue, defaultValue, defaultValue, defaultValue, defaultValue, Float.NaN, Float.NaN, defaultValue};
    }
}

