/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000201B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020 H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R$\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0012\"\u0004\b\u001b\u0010\u0014R$\u0010!\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001a\u0010#\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R$\u0010%\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R$\u0010'\u001a\u00020\u00108\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010)\u001a\u0004\b'\u0010\u0012\"\u0004\b*\u0010\u0014R$\u0010.\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0012\"\u0004\b/\u0010\u0014\u00a8\u00062"}, d2={"Lcom/facebook/react/devsupport/DevInternalSettings;", "Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "applicationContext", "Landroid/content/Context;", "listener", "Lcom/facebook/react/devsupport/DevInternalSettings$Listener;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/devsupport/DevInternalSettings$Listener;)V", "preferences", "Landroid/content/SharedPreferences;", "packagerConnectionSettings", "Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;", "getPackagerConnectionSettings", "()Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;", "value", "", "isFpsDebugEnabled", "()Z", "setFpsDebugEnabled", "(Z)V", "_", "isAnimationFpsDebugEnabled", "setAnimationFpsDebugEnabled", "isJSDevModeEnabled", "setJSDevModeEnabled", "isJSMinifyEnabled", "setJSMinifyEnabled", "onSharedPreferenceChanged", "", "sharedPreferences", "key", "", "isElementInspectorEnabled", "setElementInspectorEnabled", "isDeviceDebugEnabled", "setDeviceDebugEnabled", "isRemoteJSDebugEnabled", "setRemoteJSDebugEnabled", "isStartSamplingProfilerOnInit", "isStartSamplingProfilerOnInit$annotations", "()V", "setStartSamplingProfilerOnInit", "addMenuItem", "title", "enabled", "isHotModuleReplacementEnabled", "setHotModuleReplacementEnabled", "Listener", "Companion", "ReactAndroid_release"})
public final class DevInternalSettings
implements DeveloperSettings,
SharedPreferences.OnSharedPreferenceChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Listener listener;
    @NotNull
    private final SharedPreferences preferences;
    @NotNull
    private final PackagerConnectionSettings packagerConnectionSettings;
    private boolean isDeviceDebugEnabled;
    private boolean isStartSamplingProfilerOnInit;
    @NotNull
    private static final String PREFS_FPS_DEBUG_KEY = "fps_debug";
    @NotNull
    private static final String PREFS_JS_DEV_MODE_DEBUG_KEY = "js_dev_mode_debug";
    @NotNull
    private static final String PREFS_JS_MINIFY_DEBUG_KEY = "js_minify_debug";
    @NotNull
    private static final String PREFS_ANIMATIONS_DEBUG_KEY = "animations_debug";
    @NotNull
    private static final String PREFS_INSPECTOR_DEBUG_KEY = "inspector_debug";
    @NotNull
    private static final String PREFS_HOT_MODULE_REPLACEMENT_KEY = "hot_module_replacement";
    @NotNull
    private static final String PREFS_REMOTE_JS_DEBUG_KEY = "remote_js_debug";

    public DevInternalSettings(@NotNull Context applicationContext, @Nullable Listener listener) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.listener = listener;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)applicationContext);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getDefaultSharedPreferences(...)");
        this.preferences = sharedPreferences;
        this.packagerConnectionSettings = new PackagerConnectionSettings(applicationContext);
        this.preferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.isDeviceDebugEnabled = ReactBuildConfig.DEBUG;
    }

    @Override
    @NotNull
    public PackagerConnectionSettings getPackagerConnectionSettings() {
        return this.packagerConnectionSettings;
    }

    @Override
    public boolean isFpsDebugEnabled() {
        return this.preferences.getBoolean(PREFS_FPS_DEBUG_KEY, false);
    }

    @Override
    public void setFpsDebugEnabled(boolean value) {
        this.preferences.edit().putBoolean(PREFS_FPS_DEBUG_KEY, value).apply();
    }

    @Override
    public boolean isAnimationFpsDebugEnabled() {
        return this.preferences.getBoolean(PREFS_ANIMATIONS_DEBUG_KEY, false);
    }

    @Override
    public void setAnimationFpsDebugEnabled(boolean bl) {
    }

    @Override
    public boolean isJSDevModeEnabled() {
        return this.preferences.getBoolean(PREFS_JS_DEV_MODE_DEBUG_KEY, true);
    }

    @Override
    public void setJSDevModeEnabled(boolean value) {
        this.preferences.edit().putBoolean(PREFS_JS_DEV_MODE_DEBUG_KEY, value).apply();
    }

    @Override
    public boolean isJSMinifyEnabled() {
        return this.preferences.getBoolean(PREFS_JS_MINIFY_DEBUG_KEY, false);
    }

    @Override
    public void setJSMinifyEnabled(boolean bl) {
    }

    public void onSharedPreferenceChanged(@NotNull SharedPreferences sharedPreferences, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        if (this.listener != null && (Intrinsics.areEqual((Object)PREFS_FPS_DEBUG_KEY, (Object)key) || Intrinsics.areEqual((Object)PREFS_JS_DEV_MODE_DEBUG_KEY, (Object)key) || Intrinsics.areEqual((Object)PREFS_JS_MINIFY_DEBUG_KEY, (Object)key))) {
            this.listener.onInternalSettingsChanged();
        }
    }

    @Override
    public boolean isElementInspectorEnabled() {
        return this.preferences.getBoolean(PREFS_INSPECTOR_DEBUG_KEY, false);
    }

    @Override
    public void setElementInspectorEnabled(boolean value) {
        this.preferences.edit().putBoolean(PREFS_INSPECTOR_DEBUG_KEY, value).apply();
    }

    @Override
    public boolean isDeviceDebugEnabled() {
        return this.isDeviceDebugEnabled;
    }

    @Override
    public void setDeviceDebugEnabled(boolean bl) {
        this.isDeviceDebugEnabled = bl;
    }

    @Override
    public boolean isRemoteJSDebugEnabled() {
        return this.preferences.getBoolean(PREFS_REMOTE_JS_DEBUG_KEY, false);
    }

    @Override
    public void setRemoteJSDebugEnabled(boolean value) {
        this.preferences.edit().putBoolean(PREFS_REMOTE_JS_DEBUG_KEY, value).apply();
    }

    @Override
    public boolean isStartSamplingProfilerOnInit() {
        return this.isStartSamplingProfilerOnInit;
    }

    @Override
    public void setStartSamplingProfilerOnInit(boolean bl) {
        this.isStartSamplingProfilerOnInit = bl;
    }

    @Deprecated(message="Legacy sampling profiler is no longer supported - This field will be removed in React Native 0.77")
    public static /* synthetic */ void isStartSamplingProfilerOnInit$annotations() {
    }

    @Override
    public void addMenuItem(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
    }

    @Override
    public boolean isHotModuleReplacementEnabled() {
        return this.preferences.getBoolean(PREFS_HOT_MODULE_REPLACEMENT_KEY, true);
    }

    @Override
    public void setHotModuleReplacementEnabled(boolean enabled) {
        this.preferences.edit().putBoolean(PREFS_HOT_MODULE_REPLACEMENT_KEY, enabled).apply();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/devsupport/DevInternalSettings$Companion;", "", "<init>", "()V", "PREFS_FPS_DEBUG_KEY", "", "PREFS_JS_DEV_MODE_DEBUG_KEY", "PREFS_JS_MINIFY_DEBUG_KEY", "PREFS_ANIMATIONS_DEBUG_KEY", "PREFS_INSPECTOR_DEBUG_KEY", "PREFS_HOT_MODULE_REPLACEMENT_KEY", "PREFS_REMOTE_JS_DEBUG_KEY", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/devsupport/DevInternalSettings$Listener;", "", "onInternalSettingsChanged", "", "ReactAndroid_release"})
    public static interface Listener {
        public void onInternalSettingsChanged();
    }
}

