/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.hermes.reactexecutor.HermesExecutor;
import com.facebook.hermes.reactexecutor.HermesExecutorFactory;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.devsupport.DefaultDevSupportManagerFactory;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.internal.ChoreographerProvider;
import com.facebook.react.jscexecutor.JSCExecutor;
import com.facebook.react.jscexecutor.JSCExecutorFactory;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.RequestHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReactInstanceManagerBuilder {
    private static final String TAG = ReactInstanceManagerBuilder.class.getSimpleName();
    private final List<ReactPackage> mPackages = new ArrayList<ReactPackage>();
    @Nullable
    private String mJSBundleAssetUrl;
    @Nullable
    private JSBundleLoader mJSBundleLoader;
    @Nullable
    private String mJSMainModulePath;
    @Nullable
    private NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    private Application mApplication;
    private boolean mUseDeveloperSupport;
    @Nullable
    private DevSupportManagerFactory mDevSupportManagerFactory;
    private boolean mRequireActivity;
    private boolean mKeepActivity;
    @Nullable
    private LifecycleState mInitialLifecycleState;
    @Nullable
    private JSExceptionHandler mJSExceptionHandler;
    @Nullable
    private Activity mCurrentActivity;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultHardwareBackBtnHandler;
    @Nullable
    private RedBoxHandler mRedBoxHandler;
    private boolean mLazyViewManagersEnabled;
    @Nullable
    private DevBundleDownloadListener mDevBundleDownloadListener;
    @Nullable
    private JavaScriptExecutorFactory mJavaScriptExecutorFactory;
    private int mMinNumShakes = 1;
    private int mMinTimeLeftInFrameForNonBatchedOperationMs = -1;
    @Nullable
    private UIManagerProvider mUIManagerProvider;
    @Nullable
    private Map<String, RequestHandler> mCustomPackagerCommandHandlers;
    @Nullable
    private ReactPackageTurboModuleManagerDelegate.Builder mTMMDelegateBuilder;
    @Nullable
    private SurfaceDelegateFactory mSurfaceDelegateFactory;
    @Nullable
    private DevLoadingViewManager mDevLoadingViewManager;
    @Nullable
    private JSEngineResolutionAlgorithm mJSEngineResolutionAlgorithm = null;
    @Nullable
    private ChoreographerProvider mChoreographerProvider = null;
    @Nullable
    private PausedInDebuggerOverlayManager mPausedInDebuggerOverlayManager = null;

    ReactInstanceManagerBuilder() {
    }

    public ReactInstanceManagerBuilder setJavaScriptExecutorFactory(@Nullable JavaScriptExecutorFactory javaScriptExecutorFactory) {
        this.mJavaScriptExecutorFactory = javaScriptExecutorFactory;
        return this;
    }

    public ReactInstanceManagerBuilder setUIManagerProvider(UIManagerProvider uIManagerProvider) {
        this.mUIManagerProvider = uIManagerProvider;
        return this;
    }

    public ReactInstanceManagerBuilder setBundleAssetName(String bundleAssetName) {
        this.mJSBundleAssetUrl = bundleAssetName == null ? null : "assets://" + bundleAssetName;
        this.mJSBundleLoader = null;
        return this;
    }

    public ReactInstanceManagerBuilder setJSBundleFile(String jsBundleFile) {
        if (jsBundleFile.startsWith("assets://")) {
            this.mJSBundleAssetUrl = jsBundleFile;
            this.mJSBundleLoader = null;
            return this;
        }
        return this.setJSBundleLoader(JSBundleLoader.createFileLoader(jsBundleFile));
    }

    public ReactInstanceManagerBuilder setJSBundleLoader(JSBundleLoader jsBundleLoader) {
        this.mJSBundleLoader = jsBundleLoader;
        this.mJSBundleAssetUrl = null;
        return this;
    }

    public ReactInstanceManagerBuilder setJSEngineResolutionAlgorithm(@Nullable JSEngineResolutionAlgorithm jsEngineResolutionAlgorithm) {
        this.mJSEngineResolutionAlgorithm = jsEngineResolutionAlgorithm;
        return this;
    }

    public ReactInstanceManagerBuilder setJSMainModulePath(String jsMainModulePath) {
        this.mJSMainModulePath = jsMainModulePath;
        return this;
    }

    public ReactInstanceManagerBuilder addPackage(ReactPackage reactPackage) {
        this.mPackages.add(reactPackage);
        return this;
    }

    public ReactInstanceManagerBuilder addPackages(List<ReactPackage> reactPackages) {
        this.mPackages.addAll(reactPackages);
        return this;
    }

    public ReactInstanceManagerBuilder setBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener) {
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        return this;
    }

    public ReactInstanceManagerBuilder setApplication(Application application) {
        this.mApplication = application;
        return this;
    }

    public ReactInstanceManagerBuilder setCurrentActivity(Activity activity) {
        this.mCurrentActivity = activity;
        return this;
    }

    public ReactInstanceManagerBuilder setDefaultHardwareBackBtnHandler(DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler) {
        this.mDefaultHardwareBackBtnHandler = defaultHardwareBackBtnHandler;
        return this;
    }

    public ReactInstanceManagerBuilder setUseDeveloperSupport(boolean useDeveloperSupport) {
        this.mUseDeveloperSupport = useDeveloperSupport;
        return this;
    }

    public ReactInstanceManagerBuilder setDevSupportManagerFactory(DevSupportManagerFactory devSupportManagerFactory) {
        this.mDevSupportManagerFactory = devSupportManagerFactory;
        return this;
    }

    public ReactInstanceManagerBuilder setRequireActivity(boolean requireActivity) {
        this.mRequireActivity = requireActivity;
        return this;
    }

    public ReactInstanceManagerBuilder setKeepActivity(boolean keepActivity) {
        this.mKeepActivity = keepActivity;
        return this;
    }

    public ReactInstanceManagerBuilder setSurfaceDelegateFactory(@Nullable SurfaceDelegateFactory surfaceDelegateFactory) {
        this.mSurfaceDelegateFactory = surfaceDelegateFactory;
        return this;
    }

    public ReactInstanceManagerBuilder setDevLoadingViewManager(@Nullable DevLoadingViewManager devLoadingViewManager) {
        this.mDevLoadingViewManager = devLoadingViewManager;
        return this;
    }

    public ReactInstanceManagerBuilder setPausedInDebuggerOverlayManager(@Nullable PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager) {
        this.mPausedInDebuggerOverlayManager = pausedInDebuggerOverlayManager;
        return this;
    }

    public ReactInstanceManagerBuilder setInitialLifecycleState(LifecycleState initialLifecycleState) {
        this.mInitialLifecycleState = initialLifecycleState;
        return this;
    }

    public ReactInstanceManagerBuilder setJSExceptionHandler(@Nullable JSExceptionHandler handler) {
        this.mJSExceptionHandler = handler;
        return this;
    }

    public ReactInstanceManagerBuilder setRedBoxHandler(@Nullable RedBoxHandler redBoxHandler) {
        this.mRedBoxHandler = redBoxHandler;
        return this;
    }

    public ReactInstanceManagerBuilder setLazyViewManagersEnabled(boolean lazyViewManagersEnabled) {
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        return this;
    }

    public ReactInstanceManagerBuilder setDevBundleDownloadListener(@Nullable DevBundleDownloadListener listener) {
        this.mDevBundleDownloadListener = listener;
        return this;
    }

    public ReactInstanceManagerBuilder setMinNumShakes(int minNumShakes) {
        this.mMinNumShakes = minNumShakes;
        return this;
    }

    public ReactInstanceManagerBuilder setMinTimeLeftInFrameForNonBatchedOperationMs(int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
        return this;
    }

    public ReactInstanceManagerBuilder setCustomPackagerCommandHandlers(Map<String, RequestHandler> customPackagerCommandHandlers) {
        this.mCustomPackagerCommandHandlers = customPackagerCommandHandlers;
        return this;
    }

    public ReactInstanceManagerBuilder setReactPackageTurboModuleManagerDelegateBuilder(@Nullable ReactPackageTurboModuleManagerDelegate.Builder builder) {
        this.mTMMDelegateBuilder = builder;
        return this;
    }

    public ReactInstanceManagerBuilder setChoreographerProvider(@Nullable ChoreographerProvider choreographerProvider) {
        this.mChoreographerProvider = choreographerProvider;
        return this;
    }

    public ReactInstanceManager build() {
        Assertions.assertNotNull((Object)this.mApplication, (String)"Application property has not been set with this builder");
        if (this.mInitialLifecycleState == LifecycleState.RESUMED) {
            Assertions.assertNotNull((Object)this.mCurrentActivity, (String)"Activity needs to be set if initial lifecycle state is resumed");
        }
        Assertions.assertCondition((this.mUseDeveloperSupport || this.mJSBundleAssetUrl != null || this.mJSBundleLoader != null ? 1 : 0) != 0, (String)"JS Bundle File or Asset URL has to be provided when dev support is disabled");
        Assertions.assertCondition((this.mJSMainModulePath != null || this.mJSBundleAssetUrl != null || this.mJSBundleLoader != null ? 1 : 0) != 0, (String)"Either MainModulePath or JS Bundle File needs to be provided");
        String appName = this.mApplication.getPackageName();
        String deviceName = AndroidInfoHelpers.getFriendlyDeviceName();
        return new ReactInstanceManager((Context)this.mApplication, this.mCurrentActivity, this.mDefaultHardwareBackBtnHandler, this.mJavaScriptExecutorFactory == null ? this.getDefaultJSExecutorFactory(appName, deviceName, this.mApplication.getApplicationContext()) : this.mJavaScriptExecutorFactory, this.mJSBundleLoader == null && this.mJSBundleAssetUrl != null ? JSBundleLoader.createAssetLoader((Context)this.mApplication, this.mJSBundleAssetUrl, false) : this.mJSBundleLoader, this.mJSMainModulePath, this.mPackages, this.mUseDeveloperSupport, this.mDevSupportManagerFactory == null ? new DefaultDevSupportManagerFactory() : this.mDevSupportManagerFactory, this.mRequireActivity, this.mKeepActivity, this.mBridgeIdleDebugListener, (LifecycleState)((Object)Assertions.assertNotNull((Object)((Object)this.mInitialLifecycleState), (String)"Initial lifecycle state was not set")), this.mJSExceptionHandler, this.mRedBoxHandler, this.mLazyViewManagersEnabled, this.mDevBundleDownloadListener, this.mMinNumShakes, this.mMinTimeLeftInFrameForNonBatchedOperationMs, this.mUIManagerProvider, this.mCustomPackagerCommandHandlers, this.mTMMDelegateBuilder, this.mSurfaceDelegateFactory, this.mDevLoadingViewManager, this.mChoreographerProvider, this.mPausedInDebuggerOverlayManager);
    }

    private JavaScriptExecutorFactory getDefaultJSExecutorFactory(String appName, String deviceName, Context applicationContext) {
        ReactInstanceManager.initializeSoLoaderIfNecessary(applicationContext);
        if (this.mJSEngineResolutionAlgorithm == null) {
            try {
                HermesExecutor.loadLibrary();
                return new HermesExecutorFactory();
            }
            catch (UnsatisfiedLinkError ignoredHermesError) {
                try {
                    JSCExecutor.loadLibrary();
                    return new JSCExecutorFactory(appName, deviceName);
                }
                catch (UnsatisfiedLinkError jscError) {
                    FLog.e((String)TAG, (String)"Unable to load neither the Hermes nor the JSC native library. Your application is not built correctly and will fail to execute");
                    if (jscError.getMessage().contains("__cxa_bad_typeid")) {
                        throw jscError;
                    }
                    return null;
                }
            }
        }
        if (this.mJSEngineResolutionAlgorithm == JSEngineResolutionAlgorithm.HERMES) {
            HermesExecutor.loadLibrary();
            return new HermesExecutorFactory();
        }
        JSCExecutor.loadLibrary();
        return new JSCExecutorFactory(appName, deviceName);
    }
}

