/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.image.GlobalImageLoadListener;
import com.facebook.react.views.image.ImageLoadEvent;
import com.facebook.react.views.image.ImageResizeMethod;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.image.ReactCallerContextFactory;
import com.facebook.react.views.image.ReactImageView;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RCTImageView")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0007\u0018\u0000 D2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001DB=\b\u0007\u0012\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB-\b\u0017\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\t\u0010\rB7\b\u0017\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001a\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\u001a\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010#\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010#\u001a\u0004\u0018\u00010\u0013H\u0007J\u001f\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010&\u001a\u0004\u0018\u00010'H\u0007\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010*\u001a\u0004\u0018\u00010'H\u0007\u00a2\u0006\u0002\u0010(J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001fH\u0007J \u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001fH\u0007J\u001a\u00100\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u00101\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u00103\u001a\u0004\u0018\u00010\u0013H\u0007J\u0018\u00104\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u001fH\u0007J\u001f\u00106\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u00107\u001a\u0004\u0018\u00010'H\u0007\u00a2\u0006\u0002\u0010(J\u0018\u00108\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0018H\u0007J\u0018\u0010:\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010;\u001a\u00020'H\u0007J\u0018\u0010<\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u0018H\u0007J\u001a\u0010>\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010?\u001a\u0004\u0018\u00010@H\u0007J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0BH\u0016J\u0010\u0010C\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014R \u0010\u0003\u001a\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/facebook/react/views/image/ReactImageManager;", "Lcom/facebook/react/uimanager/SimpleViewManager;", "Lcom/facebook/react/views/image/ReactImageView;", "draweeControllerBuilder", "Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;", "globalImageLoadListener", "Lcom/facebook/react/views/image/GlobalImageLoadListener;", "callerContextFactory", "Lcom/facebook/react/views/image/ReactCallerContextFactory;", "<init>", "(Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;Lcom/facebook/react/views/image/GlobalImageLoadListener;Lcom/facebook/react/views/image/ReactCallerContextFactory;)V", "callerContext", "", "(Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;Ljava/lang/Object;)V", "(Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;Lcom/facebook/react/views/image/GlobalImageLoadListener;Ljava/lang/Object;)V", "createViewInstance", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "getName", "", "setAccessible", "", "view", "accessible", "", "setSrc", "sources", "Lcom/facebook/react/bridge/ReadableArray;", "setSource", "setBlurRadius", "blurRadius", "", "setInternal_AnalyticsTag", "analyticTag", "setDefaultSource", "source", "setLoadingIndicatorSource", "setBorderColor", "borderColor", "", "(Lcom/facebook/react/views/image/ReactImageView;Ljava/lang/Integer;)V", "setOverlayColor", "overlayColor", "setBorderWidth", "borderWidth", "setBorderRadius", "index", "borderRadius", "setResizeMode", "resizeMode", "setResizeMethod", "resizeMethod", "setResizeMultiplier", "resizeMultiplier", "setTintColor", "tintColor", "setProgressiveRenderingEnabled", "enabled", "setFadeDuration", "durationMs", "setLoadHandlersRegistered", "shouldNotifyLoadEvents", "setHeaders", "headers", "Lcom/facebook/react/bridge/ReadableMap;", "getExportedCustomDirectEventTypeConstants", "", "onAfterUpdateTransaction", "Companion", "ReactAndroid_debug"})
public final class ReactImageManager
extends SimpleViewManager<ReactImageView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder;
    @Nullable
    private final GlobalImageLoadListener globalImageLoadListener;
    @Nullable
    private final ReactCallerContextFactory callerContextFactory;
    @Nullable
    private Object callerContext;
    @NotNull
    public static final String REACT_CLASS = "RCTImageView";
    @NotNull
    private static final String REGISTRATION_NAME = "registrationName";
    @NotNull
    private static final String ON_LOAD_START = "onLoadStart";
    @NotNull
    private static final String ON_PROGRESS = "onProgress";
    @NotNull
    private static final String ON_LOAD = "onLoad";
    @NotNull
    private static final String ON_ERROR = "onError";
    @NotNull
    private static final String ON_LOAD_END = "onLoadEnd";

    @JvmOverloads
    public ReactImageManager(@Nullable AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder, @Nullable GlobalImageLoadListener globalImageLoadListener, @Nullable ReactCallerContextFactory callerContextFactory) {
        this.draweeControllerBuilder = draweeControllerBuilder;
        this.globalImageLoadListener = globalImageLoadListener;
        this.callerContextFactory = callerContextFactory;
    }

    public /* synthetic */ ReactImageManager(AbstractDraweeControllerBuilder abstractDraweeControllerBuilder, GlobalImageLoadListener globalImageLoadListener, ReactCallerContextFactory reactCallerContextFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            abstractDraweeControllerBuilder = null;
        }
        if ((n & 2) != 0) {
            globalImageLoadListener = null;
        }
        if ((n & 4) != 0) {
            reactCallerContextFactory = null;
        }
        this(abstractDraweeControllerBuilder, globalImageLoadListener, reactCallerContextFactory);
    }

    @Deprecated(message="Use the constructor with ReactCallerContextFactory instead", replaceWith=@ReplaceWith(expression="ReactImageManager(draweeControllerBuilder, globalImageLoadListener, callerContextFactory)", imports={}))
    public ReactImageManager(@Nullable AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder, @Nullable Object callerContext) {
        this(draweeControllerBuilder, null, null);
        this.callerContext = callerContext;
    }

    @Deprecated(message="Use the constructor with ReactCallerContextFactory instead", replaceWith=@ReplaceWith(expression="ReactImageManager(draweeControllerBuilder, globalImageLoadListener, callerContextFactory)", imports={}))
    public ReactImageManager(@Nullable AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder, @Nullable GlobalImageLoadListener globalImageLoadListener, @Nullable Object callerContext) {
        this(draweeControllerBuilder, globalImageLoadListener, null);
        this.callerContext = callerContext;
    }

    @Override
    @NotNull
    public ReactImageView createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Object object = this.callerContext;
        if (object == null) {
            ReactCallerContextFactory reactCallerContextFactory = this.callerContextFactory;
            object = reactCallerContextFactory != null ? reactCallerContextFactory.getOrCreateCallerContext(context.getModuleName(), null) : null;
        }
        Object callerContext = object;
        Context context2 = (Context)context;
        AbstractDraweeControllerBuilder abstractDraweeControllerBuilder = this.draweeControllerBuilder;
        if (abstractDraweeControllerBuilder == null) {
            abstractDraweeControllerBuilder = (AbstractDraweeControllerBuilder)Fresco.newDraweeControllerBuilder();
        }
        AbstractDraweeControllerBuilder abstractDraweeControllerBuilder2 = abstractDraweeControllerBuilder;
        Intrinsics.checkNotNull((Object)abstractDraweeControllerBuilder2);
        return new ReactImageView(context2, abstractDraweeControllerBuilder2, this.globalImageLoadListener, callerContext);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @ReactProp(name="accessible")
    public final void setAccessible(@NotNull ReactImageView view, boolean accessible) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFocusable(accessible);
    }

    @ReactProp(name="src")
    public final void setSrc(@NotNull ReactImageView view, @Nullable ReadableArray sources) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        this.setSource(view, sources);
    }

    @ReactProp(name="source")
    public final void setSource(@NotNull ReactImageView view, @Nullable ReadableArray sources) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setSource(sources);
    }

    @ReactProp(name="blurRadius")
    public final void setBlurRadius(@NotNull ReactImageView view, float blurRadius) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setBlurRadius(blurRadius);
    }

    @ReactProp(name="internal_analyticTag")
    public final void setInternal_AnalyticsTag(@NotNull ReactImageView view, @Nullable String analyticTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (this.callerContextFactory != null) {
            Context context = view.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
            view.updateCallerContext(this.callerContextFactory.getOrCreateCallerContext(((ThemedReactContext)context).getModuleName(), analyticTag));
        }
    }

    @ReactProp(name="defaultSource", customType="ImageSource")
    public final void setDefaultSource(@NotNull ReactImageView view, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setDefaultSource(source);
    }

    @ReactProp(name="loadingIndicatorSrc")
    public final void setLoadingIndicatorSource(@NotNull ReactImageView view, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setLoadingIndicatorSource(source);
    }

    @ReactProp(name="borderColor", customType="Color")
    public final void setBorderColor(@NotNull ReactImageView view, @Nullable Integer borderColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.ALL, borderColor);
    }

    @ReactProp(name="overlayColor", customType="Color")
    public final void setOverlayColor(@NotNull ReactImageView view, @Nullable Integer overlayColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (overlayColor == null) {
            view.setOverlayColor(0);
        } else {
            view.setOverlayColor(overlayColor);
        }
    }

    @ReactProp(name="borderWidth")
    public final void setBorderWidth(@NotNull ReactImageView view, float borderWidth) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        BackgroundStyleApplicator.setBorderWidth((View)view, LogicalEdge.ALL, Float.valueOf(borderWidth));
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public final void setBorderRadius(@NotNull ReactImageView view, int index, float borderRadius) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)view, BorderRadiusProp.values()[index], radius);
    }

    @ReactProp(name="resizeMode")
    public final void setResizeMode(@NotNull ReactImageView view, @Nullable String resizeMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setScaleType(ImageResizeMode.toScaleType(resizeMode));
        view.setTileMode(ImageResizeMode.toTileMode(resizeMode));
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="resizeMethod")
    public final void setResizeMethod(@NotNull ReactImageView view, @Nullable String resizeMethod) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        var3_3 = resizeMethod;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 3005871: {
                if (var3_3.equals("auto")) {
                    tmp = 1;
                }
                break;
            }
            case -934437708: {
                if (var3_3.equals("resize")) {
                    tmp = 2;
                }
                break;
            }
            case 109250890: {
                if (var3_3.equals("scale")) {
                    tmp = 3;
                }
                break;
            }
            case 3387192: {
                if (var3_3.equals("none")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: lbl-1000:
            // 2 sources

            {
                view.setResizeMethod(ImageResizeMethod.AUTO);
                break;
            }
            case 2: {
                view.setResizeMethod(ImageResizeMethod.RESIZE);
                break;
            }
            case 3: {
                view.setResizeMethod(ImageResizeMethod.SCALE);
                break;
            }
            case 4: {
                view.setResizeMethod(ImageResizeMethod.NONE);
                break;
            }
            default: {
                view.setResizeMethod(ImageResizeMethod.AUTO);
                FLog.w((String)"ReactNative", (String)("Invalid resize method: '" + resizeMethod + "'"));
            }
        }
    }

    @ReactProp(name="resizeMultiplier")
    public final void setResizeMultiplier(@NotNull ReactImageView view, float resizeMultiplier) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (resizeMultiplier < 0.01f) {
            FLog.w((String)"ReactNative", (String)("Invalid resize multiplier: '" + resizeMultiplier + "'"));
        }
        view.setResizeMultiplier(resizeMultiplier);
    }

    @ReactProp(name="tintColor", customType="Color")
    public final void setTintColor(@NotNull ReactImageView view, @Nullable Integer tintColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (tintColor == null) {
            view.clearColorFilter();
        } else {
            view.setColorFilter(tintColor, PorterDuff.Mode.SRC_IN);
        }
    }

    @ReactProp(name="progressiveRenderingEnabled")
    public final void setProgressiveRenderingEnabled(@NotNull ReactImageView view, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setProgressiveRenderingEnabled(enabled);
    }

    @ReactProp(name="fadeDuration")
    public final void setFadeDuration(@NotNull ReactImageView view, int durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFadeDuration(durationMs);
    }

    @ReactProp(name="shouldNotifyLoadEvents")
    public final void setLoadHandlersRegistered(@NotNull ReactImageView view, boolean shouldNotifyLoadEvents) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setShouldNotifyLoadEvents(shouldNotifyLoadEvents);
    }

    @ReactProp(name="headers")
    public final void setHeaders(@NotNull ReactImageView view, @Nullable ReadableMap headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (headers != null) {
            view.setHeaders(headers);
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map map;
        Map map2 = super.getExportedCustomDirectEventTypeConstants();
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map $this$getExportedCustomDirectEventTypeConstants_u24lambda_u240 = map = map2;
        boolean bl = false;
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u240.put(ImageLoadEvent.Companion.eventNameForType(4), MapsKt.mapOf((Pair)TuplesKt.to((Object)REGISTRATION_NAME, (Object)ON_LOAD_START)));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u240.put(ImageLoadEvent.Companion.eventNameForType(5), MapsKt.mapOf((Pair)TuplesKt.to((Object)REGISTRATION_NAME, (Object)ON_PROGRESS)));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u240.put(ImageLoadEvent.Companion.eventNameForType(2), MapsKt.mapOf((Pair)TuplesKt.to((Object)REGISTRATION_NAME, (Object)ON_LOAD)));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u240.put(ImageLoadEvent.Companion.eventNameForType(1), MapsKt.mapOf((Pair)TuplesKt.to((Object)REGISTRATION_NAME, (Object)ON_ERROR)));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u240.put(ImageLoadEvent.Companion.eventNameForType(3), MapsKt.mapOf((Pair)TuplesKt.to((Object)REGISTRATION_NAME, (Object)ON_LOAD_END)));
        return map;
    }

    @Override
    protected void onAfterUpdateTransaction(@NotNull ReactImageView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        super.onAfterUpdateTransaction((View)view);
        view.maybeUpdateView();
    }

    @JvmOverloads
    public ReactImageManager(@Nullable AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder, @Nullable GlobalImageLoadListener globalImageLoadListener) {
        this(draweeControllerBuilder, globalImageLoadListener, null, 4, null);
    }

    @JvmOverloads
    public ReactImageManager(@Nullable AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder) {
        this(draweeControllerBuilder, null, null, 6, null);
    }

    @JvmOverloads
    public ReactImageManager() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/views/image/ReactImageManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "REGISTRATION_NAME", "ON_LOAD_START", "ON_PROGRESS", "ON_LOAD", "ON_ERROR", "ON_LOAD_END", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

